/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.text.RtfPhrase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfParagraph
extends RtfPhrase {
    public static final byte[] PARAGRAPH = "\\par".getBytes();
    public static final byte[] ALIGN_LEFT = "\\ql".getBytes();
    public static final byte[] ALIGN_RIGHT = "\\qr".getBytes();
    public static final byte[] ALIGN_CENTER = "\\qc".getBytes();
    public static final byte[] ALIGN_JUSTIFY = "\\qj".getBytes();
    public static final byte[] INDENT_LEFT = "\\li".getBytes();
    public static final byte[] INDENT_RIGHT = "\\ri".getBytes();
    public static final byte[] KEEP_TOGETHER = "\\keep".getBytes();
    public static final byte[] KEEP_TOGETHER_WITH_NEXT = "\\keepn".getBytes();
    private static final byte[] SPACING_BEFORE = "\\sb".getBytes();
    private static final byte[] SPACING_AFTER = "\\sa".getBytes();
    private int alignment = -1;
    private int indentLeft = 0;
    private int indentRight = 0;
    private boolean keepTogether = false;
    private boolean keepTogetherWithNext = false;
    private int spacingBefore = 0;
    private int spacingAfter = 0;

    public RtfParagraph(RtfDocument rtfDocument, Paragraph paragraph) {
        super(rtfDocument, paragraph);
        this.alignment = paragraph.alignment();
        this.indentLeft = (int)((double)paragraph.indentationLeft() * 20.0);
        this.indentRight = (int)((double)paragraph.indentationRight() * 20.0);
        this.keepTogether = paragraph.getKeepTogether();
        this.spacingBefore = (int)((double)paragraph.spacingBefore() * 20.0);
        this.spacingAfter = (int)((double)paragraph.spacingAfter() * 20.0);
    }

    public void setKeepTogetherWithNext(boolean bl) {
        this.keepTogetherWithNext = bl;
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(PARAGRAPH_DEFAULTS);
            if (this.keepTogether) {
                byteArrayOutputStream.write(KEEP_TOGETHER);
            }
            if (this.keepTogetherWithNext) {
                byteArrayOutputStream.write(KEEP_TOGETHER_WITH_NEXT);
            }
            if (this.inTable) {
                byteArrayOutputStream.write(IN_TABLE);
            }
            switch (this.alignment) {
                case 0: {
                    byteArrayOutputStream.write(ALIGN_LEFT);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(ALIGN_CENTER);
                    break;
                }
                case 3: 
                case 8: {
                    byteArrayOutputStream.write(ALIGN_JUSTIFY);
                }
            }
            byteArrayOutputStream.write(INDENT_LEFT);
            byteArrayOutputStream.write(this.intToByteArray(this.indentLeft));
            byteArrayOutputStream.write(INDENT_RIGHT);
            byteArrayOutputStream.write(this.intToByteArray(this.indentRight));
            if (this.spacingBefore > 0) {
                byteArrayOutputStream.write(SPACING_BEFORE);
                byteArrayOutputStream.write(this.intToByteArray(this.spacingBefore));
            }
            if (this.spacingAfter > 0) {
                byteArrayOutputStream.write(SPACING_AFTER);
                byteArrayOutputStream.write(this.intToByteArray(this.spacingAfter));
            }
            if (this.lineLeading > 0) {
                byteArrayOutputStream.write(LINE_SPACING);
                byteArrayOutputStream.write(this.intToByteArray(this.lineLeading));
            }
            for (int i2 = 0; i2 < this.chunks.size(); ++i2) {
                byteArrayOutputStream.write(((RtfBasicElement)this.chunks.get(i2)).write());
            }
            if (!this.inTable) {
                byteArrayOutputStream.write(PARAGRAPH);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

