/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfFontList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] DEFAULT_FONT = "\\deff".getBytes();
    private static final byte[] FONT_TABLE = "\\fonttbl".getBytes();
    public static final byte[] FONT_NUMBER = "\\f".getBytes();
    private ArrayList fontList = new ArrayList();

    public RtfFontList(RtfDocument rtfDocument) {
        super(rtfDocument);
        this.fontList.add(new RtfFont(this.document, 0));
    }

    public int getFontNumber(RtfFont rtfFont) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.fontList.size(); ++i2) {
            if (!this.fontList.get(i2).equals(rtfFont)) continue;
            n2 = i2;
        }
        if (n2 == -1) {
            n2 = this.fontList.size();
            this.fontList.add(rtfFont);
        }
        return n2;
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(DEFAULT_FONT);
            byteArrayOutputStream.write(this.intToByteArray(0));
            byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
            byteArrayOutputStream.write(FONT_TABLE);
            for (int i2 = 0; i2 < this.fontList.size(); ++i2) {
                byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
                byteArrayOutputStream.write(FONT_NUMBER);
                byteArrayOutputStream.write(this.intToByteArray(i2));
                byteArrayOutputStream.write(((RtfFont)this.fontList.get(i2)).writeDefinition());
                byteArrayOutputStream.write(RtfBasicElement.COMMA_DELIMITER);
                byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
            }
            byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
            byteArrayOutputStream.write(10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

