/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfListTable
extends RtfElement
implements RtfExtendedElement {
    protected static final byte[] LIST_NUMBER = "\\ls".getBytes();
    private static final byte[] LIST_TABLE = "\\*\\listtable".getBytes();
    private static final byte[] LIST = "\\list".getBytes();
    private static final byte[] LIST_TEMPLATE_ID = "\\listtemplateid".getBytes();
    private static final byte[] LIST_HYBRID = "\\hybrid".getBytes();
    private static final byte[] LIST_ID = "\\listid".getBytes();
    private static final byte[] LIST_OVERRIDE_TABLE = "\\*\\listoverridetable".getBytes();
    private static final byte[] LIST_OVERRIDE = "\\listoverride".getBytes();
    private static final byte[] LIST_OVERRIDE_COUNT = "\\listoverridecount".getBytes();
    private ArrayList lists = new ArrayList();

    public RtfListTable(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int[] nArray = new int[this.lists.size()];
        try {
            int n2;
            byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
            byteArrayOutputStream.write(LIST_TABLE);
            byteArrayOutputStream.write("\n".getBytes());
            for (n2 = 0; n2 < this.lists.size(); ++n2) {
                byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
                byteArrayOutputStream.write(LIST);
                byteArrayOutputStream.write(LIST_TEMPLATE_ID);
                byteArrayOutputStream.write(this.intToByteArray(this.document.getRandomInt()));
                byteArrayOutputStream.write(LIST_HYBRID);
                byteArrayOutputStream.write("\n".getBytes());
                byteArrayOutputStream.write(((RtfList)this.lists.get(n2)).writeDefinition());
                byteArrayOutputStream.write(LIST_ID);
                nArray[n2] = this.document.getRandomInt();
                byteArrayOutputStream.write(this.intToByteArray(nArray[n2]));
                byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
                byteArrayOutputStream.write("\n".getBytes());
            }
            byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
            byteArrayOutputStream.write("\n".getBytes());
            byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
            byteArrayOutputStream.write(LIST_OVERRIDE_TABLE);
            byteArrayOutputStream.write("\n".getBytes());
            for (n2 = 0; n2 < this.lists.size(); ++n2) {
                byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
                byteArrayOutputStream.write(LIST_OVERRIDE);
                byteArrayOutputStream.write(LIST_ID);
                byteArrayOutputStream.write(this.intToByteArray(nArray[n2]));
                byteArrayOutputStream.write(LIST_OVERRIDE_COUNT);
                byteArrayOutputStream.write(this.intToByteArray(0));
                byteArrayOutputStream.write(LIST_NUMBER);
                byteArrayOutputStream.write(this.intToByteArray(((RtfList)this.lists.get(n2)).getListNumber()));
                byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
                byteArrayOutputStream.write("\n".getBytes());
            }
            byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
            byteArrayOutputStream.write("\n".getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getListNumber(RtfList rtfList) {
        if (this.lists.contains(rtfList)) {
            return this.lists.indexOf(rtfList);
        }
        this.lists.add(rtfList);
        return this.lists.size();
    }

    public void freeListNumber(RtfList rtfList) {
        int n2 = this.lists.indexOf(rtfList);
        if (n2 >= 0) {
            this.lists.remove(n2);
        }
    }
}

