/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfCell;
import com.lowagie.text.rtf.RtfRow;
import com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfTable {
    private ArrayList rowsList = new ArrayList();
    private RtfWriter writer = null;
    private Table origTable = null;

    public RtfTable(RtfWriter rtfWriter) {
        this.writer = rtfWriter;
    }

    public boolean importTable(Table table, int n2) {
        RtfRow rtfRow;
        int n3;
        this.origTable = table;
        Iterator iterator = table.iterator();
        Row row = null;
        int n4 = (int)table.widthPercentage();
        int n5 = (int)((double)table.cellpadding() * 20.0);
        int n6 = (int)((double)table.cellspacing() * 20.0);
        float[] fArray = table.getProportionalWidths();
        int n7 = table.border();
        Color color = table.borderColor();
        float f2 = table.borderWidth();
        for (n3 = 0; n3 < table.size(); ++n3) {
            rtfRow = new RtfRow(this.writer, this);
            rtfRow.pregenerateRows(table.columns());
            this.rowsList.add(rtfRow);
        }
        n3 = 0;
        while (iterator.hasNext()) {
            row = (Row)iterator.next();
            row.setHorizontalAlignment(table.alignment());
            rtfRow = (RtfRow)this.rowsList.get(n3);
            rtfRow.importRow(row, fArray, n4, n2, n5, n6, n7, color, f2, n3);
            ++n3;
        }
        return true;
    }

    public boolean writeTable(ByteArrayOutputStream byteArrayOutputStream) throws DocumentException, IOException {
        if (!this.writer.writingHeaderFooter()) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfWriter.paragraph);
        }
        int n2 = this.rowsList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            RtfRow rtfRow = (RtfRow)this.rowsList.get(i2);
            rtfRow.writeRow(byteArrayOutputStream, i2, this.origTable);
            byteArrayOutputStream.write(10);
        }
        if (!this.writer.writingHeaderFooter()) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfWriter.paragraphDefaults);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfWriter.paragraph);
            switch (this.origTable.alignment()) {
                case 0: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(RtfWriter.alignLeft);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(RtfWriter.alignRight);
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(RtfWriter.alignCenter);
                    break;
                }
                case 3: 
                case 8: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(RtfWriter.alignJustify);
                }
            }
        }
        return true;
    }

    public void setMerge(int n2, int n3, int n4, RtfCell rtfCell) {
        RtfRow rtfRow = (RtfRow)this.rowsList.get(n3);
        rtfRow.setMerge(n2, n4, rtfCell);
    }

    protected Table getOriginalTable() {
        return this.origTable;
    }
}

