/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfCell;
import com.lowagie.text.rtf.RtfTable;
import com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfRow {
    public static final byte[] tableBorder = "brdrs".getBytes();
    public static final byte[] tableBorderWidth = "brdrw".getBytes();
    public static final byte[] tableBorderColor = "brdrcf".getBytes();
    private static final byte[] rowBegin = "trowd".getBytes();
    private static final byte[] rowEnd = "row".getBytes();
    private static final byte[] rowAutofit = "trautofit1".getBytes();
    private static final byte[] graphLeft = "trgaph".getBytes();
    private static final byte[] rowBorderLeft = "trbrdrl".getBytes();
    private static final byte[] rowBorderRight = "trbrdrr".getBytes();
    private static final byte[] rowBorderTop = "trbrdrt".getBytes();
    private static final byte[] rowBorderBottom = "trbrdrb".getBytes();
    private static final byte[] rowBorderInlineHorizontal = "trbrdrh".getBytes();
    private static final byte[] rowBorderInlineVertical = "trbrdrv".getBytes();
    private static final byte[] rowSpacingLeft = "trspdl".getBytes();
    private static final byte[] rowSpacingRight = "trspdr".getBytes();
    private static final byte[] rowSpacingTop = "trspdt".getBytes();
    private static final byte[] rowSpacingBottom = "trspdb".getBytes();
    private static final byte[] rowSpacingLeftStyle = "trspdfl3".getBytes();
    private static final byte[] rowSpacingRightStyle = "trspdfr3".getBytes();
    private static final byte[] rowSpacingTopStyle = "trspdft3".getBytes();
    private static final byte[] rowSpacingBottomStyle = "trspdfb3".getBytes();
    private static final byte[] rowPaddingLeft = "trpaddl".getBytes();
    private static final byte[] rowPaddingRight = "trpaddr".getBytes();
    private static final byte[] rowPaddingLeftStyle = "trpaddfl3".getBytes();
    private static final byte[] rowPaddingRightStyle = "trpaddfr3".getBytes();
    private static final byte[] rowWidthStyle = "trftsWidth3".getBytes();
    private static final byte[] rowWidth = "trwWidth".getBytes();
    private static final byte[] rowHeader = "trhdr".getBytes();
    private static final byte[] rowKeep = "trkeep".getBytes();
    private static final byte[] rowAlignLeft = "trql".getBytes();
    private static final byte[] rowAlignCenter = "trqc".getBytes();
    private static final byte[] rowAlignRight = "trqr".getBytes();
    private ArrayList cells = new ArrayList();
    private RtfWriter writer = null;
    private RtfTable mainTable = null;
    private int width = 100;
    private int cellpadding = 115;
    private int cellspacing = 14;
    private int borders = 0;
    private Color borderColor = null;
    private float borderWidth = 0.0f;
    private Row origRow = null;

    public RtfRow(RtfWriter rtfWriter, RtfTable rtfTable) {
        this.writer = rtfWriter;
        this.mainTable = rtfTable;
    }

    public void pregenerateRows(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            RtfCell rtfCell = new RtfCell(this.writer, this.mainTable);
            this.cells.add(rtfCell);
        }
    }

    public boolean importRow(Row row, float[] fArray, int n2, int n3, int n4, int n5, int n6, Color color, float f2, int n7) {
        Object object;
        int n8;
        this.origRow = row;
        this.width = n3 / 100 * n2;
        this.cellpadding = n4;
        this.cellspacing = n5;
        this.borders = n6;
        this.borderColor = color;
        this.borderWidth = f2;
        if (this.borderWidth > 2.0f) {
            this.borderWidth = 2.0f;
        }
        int n9 = 0;
        for (n8 = 0; n8 < row.columns(); ++n8) {
            Element element = (Element)row.getCell(n8);
            int n10 = (int)((float)(this.width / 100) * fArray[n8]);
            if (element != null) {
                if (element.type() != 20) continue;
                object = (RtfCell)this.cells.get(n8);
                n9 = ((RtfCell)object).importCell((Cell)element, n9, n10, n8, n7, n4);
                continue;
            }
            object = (RtfCell)this.cells.get(n8);
            n9 = ((RtfCell)object).importCell(null, n9, n10, n8, n7, n4);
        }
        n8 = row.columns();
        for (int i2 = 0; i2 < n8; ++i2) {
            RtfCell rtfCell = (RtfCell)this.cells.get(i2);
            object = rtfCell.getStore();
            int n11 = 0;
            if (object != null) {
                n11 = ((Cell)object).colspan();
            }
            if (n11 <= 1) continue;
            RtfCell rtfCell2 = (RtfCell)this.cells.get(i2 + n11 - 1);
            rtfCell.setCellRight(rtfCell2.getCellRight());
            int n12 = rtfCell.getCellWidth();
            for (int i3 = i2 + 1; i3 < i2 + n11; ++i3) {
                RtfCell rtfCell3 = (RtfCell)this.cells.get(i3);
                n12 += rtfCell3.getCellWidth();
            }
            rtfCell.setCellWidth(n12);
            i2 += n11 - 1;
        }
        return true;
    }

    public boolean writeRow(ByteArrayOutputStream byteArrayOutputStream, int n2, Table table) throws DocumentException, IOException {
        RtfCell rtfCell;
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(rowBegin);
        byteArrayOutputStream.write(10);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(rowWidthStyle);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(rowWidth);
        this.writeInt(byteArrayOutputStream, this.width);
        if (this.mainTable.getOriginalTable().hasToFitPageCells()) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(rowKeep);
        }
        if (n2 < table.firstDataRow()) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(rowHeader);
        }
        byteArrayOutputStream.write(92);
        switch (this.origRow.horizontalAlignment()) {
            case 0: {
                byteArrayOutputStream.write(rowAlignLeft);
                break;
            }
            case 1: {
                byteArrayOutputStream.write(rowAlignCenter);
                break;
            }
            case 2: {
                byteArrayOutputStream.write(rowAlignRight);
                break;
            }
            default: {
                byteArrayOutputStream.write(rowAlignLeft);
            }
        }
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(graphLeft);
        this.writeInt(byteArrayOutputStream, 10);
        if ((this.borders & 4) == 4 && this.borderWidth > 0.0f) {
            this.writeBorder(byteArrayOutputStream, rowBorderLeft);
        }
        if ((this.borders & 1) == 1 && this.borderWidth > 0.0f) {
            this.writeBorder(byteArrayOutputStream, rowBorderTop);
        }
        if ((this.borders & 2) == 2 && this.borderWidth > 0.0f) {
            this.writeBorder(byteArrayOutputStream, rowBorderBottom);
        }
        if ((this.borders & 8) == 8 && this.borderWidth > 0.0f) {
            this.writeBorder(byteArrayOutputStream, rowBorderRight);
        }
        if ((this.borders & 0xF) == 15 && this.borderWidth > 0.0f) {
            this.writeBorder(byteArrayOutputStream, rowBorderInlineHorizontal);
            this.writeBorder(byteArrayOutputStream, rowBorderInlineVertical);
        }
        if (this.cellspacing > 0) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(rowSpacingLeft);
            this.writeInt(byteArrayOutputStream, this.cellspacing / 2);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(rowSpacingLeftStyle);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(rowSpacingTop);
            this.writeInt(byteArrayOutputStream, this.cellspacing / 2);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(rowSpacingTopStyle);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(rowSpacingBottom);
            this.writeInt(byteArrayOutputStream, this.cellspacing / 2);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(rowSpacingBottomStyle);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(rowSpacingRight);
            this.writeInt(byteArrayOutputStream, this.cellspacing / 2);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(rowSpacingRightStyle);
        }
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(rowPaddingLeft);
        this.writeInt(byteArrayOutputStream, this.cellpadding / 2);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(rowPaddingRight);
        this.writeInt(byteArrayOutputStream, this.cellpadding / 2);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(rowPaddingLeftStyle);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(rowPaddingRightStyle);
        byteArrayOutputStream.write(10);
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            rtfCell = (RtfCell)iterator.next();
            rtfCell.writeCellSettings(byteArrayOutputStream);
        }
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write("intbl".getBytes());
        iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            rtfCell = (RtfCell)iterator.next();
            rtfCell.writeCellContent(byteArrayOutputStream);
        }
        byteArrayOutputStream.write(32);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(rowEnd);
        return true;
    }

    private void writeBorder(ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) throws IOException {
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(tableBorder);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(tableBorderWidth);
        this.writeInt(byteArrayOutputStream, (int)((double)this.borderWidth * 20.0));
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(tableBorderColor);
        if (this.borderColor == null) {
            this.writeInt(byteArrayOutputStream, this.writer.addColor(new Color(0, 0, 0)));
        } else {
            this.writeInt(byteArrayOutputStream, this.writer.addColor(this.borderColor));
        }
        byteArrayOutputStream.write(10);
    }

    public void setMerge(int n2, int n3, RtfCell rtfCell) {
        RtfCell rtfCell2 = (RtfCell)this.cells.get(n2);
        rtfCell2.setMerge(n3, rtfCell);
    }

    private void writeInt(ByteArrayOutputStream byteArrayOutputStream, int n2) throws IOException {
        byteArrayOutputStream.write(Integer.toString(n2).getBytes());
    }
}

