/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.pdf.hyphenation.Hyphenation;
import com.lowagie.text.pdf.hyphenation.HyphenationException;
import com.lowagie.text.pdf.hyphenation.HyphenationTree;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class Hyphenator {
    static Hashtable hyphenTrees = new Hashtable();
    private HyphenationTree hyphenTree = null;
    private int remainCharCount = 2;
    private int pushCharCount = 2;
    private static boolean errorDump = false;
    private static String hyphenDir = "";
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$com$lowagie$text$pdf$hyphenation$Hyphenator;

    public Hyphenator(String string, String string2, int n2, int n3) {
        this.hyphenTree = Hyphenator.getHyphenationTree(string, string2);
        this.remainCharCount = n2;
        this.pushCharCount = n3;
    }

    public static HyphenationTree getHyphenationTree(String string, String string2) {
        String string3 = string;
        if (string2 != null && !string2.equals("none")) {
            string3 = string3 + "_" + string2;
        }
        if (hyphenTrees.containsKey(string3)) {
            return (HyphenationTree)hyphenTrees.get(string3);
        }
        if (hyphenTrees.containsKey(string)) {
            return (HyphenationTree)hyphenTrees.get(string);
        }
        HyphenationTree hyphenationTree = Hyphenator.getFopHyphenationTree(string3);
        if (hyphenationTree == null && hyphenDir != null) {
            hyphenationTree = Hyphenator.getUserHyphenationTree(string3, hyphenDir);
        }
        if (hyphenationTree != null) {
            hyphenTrees.put(string3, hyphenationTree);
        } else {
            System.out.println("Couldn't find hyphenation pattern " + string3);
        }
        return hyphenationTree;
    }

    private static InputStream getResourceStream(String string) {
        InputStream inputStream = null;
        try {
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = Hyphenator.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", new Class[0]);
            if (method != null) {
                ClassLoader classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
                inputStream = classLoader.getResourceAsStream("hyph/" + string + ".hyp");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = (class$com$lowagie$text$pdf$hyphenation$Hyphenator == null ? (class$com$lowagie$text$pdf$hyphenation$Hyphenator = Hyphenator.class$("com.lowagie.text.pdf.hyphenation.Hyphenator")) : class$com$lowagie$text$pdf$hyphenation$Hyphenator).getResourceAsStream("hyph/" + string + ".hyp");
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HyphenationTree getFopHyphenationTree(String string) {
        InputStream inputStream;
        HyphenationTree hyphenationTree;
        block15: {
            block16: {
                hyphenationTree = null;
                inputStream = null;
                inputStream = Hyphenator.getResourceStream(string);
                if (inputStream != null) break block15;
                if (string.length() != 5) break block16;
                inputStream = Hyphenator.getResourceStream(string.substring(0, 2));
                if (inputStream != null) {
                    System.out.println("Couldn't find hyphenation pattern  " + string + "\nusing general language pattern " + string.substring(0, 2) + " instead.");
                    break block15;
                }
                if (errorDump) {
                    System.out.println("Couldn't find precompiled hyphenation pattern " + string + ".hyp");
                }
                HyphenationTree hyphenationTree2 = null;
                Object var5_6 = null;
                if (inputStream == null) return hyphenationTree2;
                try {
                    inputStream.close();
                    return hyphenationTree2;
                }
                catch (IOException iOException) {
                    System.out.println("can't close hyphenation stream");
                }
                return hyphenationTree2;
            }
            if (errorDump) {
                System.out.println("Couldn't find precompiled hyphenation pattern " + string + ".hyp");
            }
            HyphenationTree hyphenationTree3 = null;
            Object var5_7 = null;
            if (inputStream == null) return hyphenationTree3;
            try {
                inputStream.close();
                return hyphenationTree3;
            }
            catch (IOException iOException) {
                System.out.println("can't close hyphenation stream");
            }
            return hyphenationTree3;
        }
        hyphenationTree = new HyphenationTree();
        hyphenationTree.loadInternalPatterns(inputStream);
        Object var5_8 = null;
        if (inputStream == null) return hyphenationTree;
        try {
            inputStream.close();
            return hyphenationTree;
        }
        catch (IOException iOException) {
            System.out.println("can't close hyphenation stream");
        }
        return hyphenationTree;
        {
            catch (Exception exception) {
                Object var5_9 = null;
                if (inputStream == null) return hyphenationTree;
                try {
                    inputStream.close();
                    return hyphenationTree;
                }
                catch (IOException iOException) {
                    System.out.println("can't close hyphenation stream");
                }
                return hyphenationTree;
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                System.out.println("can't close hyphenation stream");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HyphenationTree getUserHyphenationTree(String string, String string2) {
        HyphenationTree hyphenationTree = null;
        File file = new File(string2, string + ".hyp");
        if (file.exists()) {
            ObjectInputStream objectInputStream = null;
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            hyphenationTree = (HyphenationTree)objectInputStream.readObject();
            Object var7_6 = null;
            if (objectInputStream == null) return hyphenationTree;
            try {
                objectInputStream.close();
                return hyphenationTree;
            }
            catch (IOException iOException) {}
            return hyphenationTree;
            {
                catch (Exception exception) {
                    Object var7_7 = null;
                    if (objectInputStream == null) return hyphenationTree;
                    try {
                        objectInputStream.close();
                        return hyphenationTree;
                    }
                    catch (IOException iOException) {}
                    return hyphenationTree;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (objectInputStream == null) throw throwable;
                try {
                    objectInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        file = new File(string2, string + ".hyp");
        if (file.exists()) {
            hyphenationTree = new HyphenationTree();
            if (errorDump) {
                System.out.println("reading " + string2 + string + ".hyp");
            }
            try {
                hyphenationTree.loadInternalPatterns(file.getPath());
                if (!errorDump) return hyphenationTree;
                System.out.println("Stats: ");
                hyphenationTree.printStats();
                return hyphenationTree;
            }
            catch (HyphenationException hyphenationException) {
                if (!errorDump) return null;
                System.out.println("Can't load user patterns from file " + string2 + string + ".hyp");
                return null;
            }
        }
        if (!errorDump) return null;
        System.out.println("Tried to load " + file.toString() + "\nCannot find compiled nor xml file for " + "hyphenation pattern" + string);
        return null;
    }

    public static Hyphenation hyphenate(String string, String string2, String string3, int n2, int n3) {
        HyphenationTree hyphenationTree = Hyphenator.getHyphenationTree(string, string2);
        if (hyphenationTree == null) {
            System.out.println("Error building hyphenation tree for language " + string);
            return null;
        }
        return hyphenationTree.hyphenate(string3, n2, n3);
    }

    public static Hyphenation hyphenate(String string, String string2, char[] cArray, int n2, int n3, int n4, int n5) {
        HyphenationTree hyphenationTree = Hyphenator.getHyphenationTree(string, string2);
        if (hyphenationTree == null) {
            System.out.println("Error building hyphenation tree for language " + string);
            return null;
        }
        return hyphenationTree.hyphenate(cArray, n2, n3, n4, n5);
    }

    public void setMinRemainCharCount(int n2) {
        this.remainCharCount = n2;
    }

    public void setMinPushCharCount(int n2) {
        this.pushCharCount = n2;
    }

    public void setLanguage(String string, String string2) {
        this.hyphenTree = Hyphenator.getHyphenationTree(string, string2);
    }

    public Hyphenation hyphenate(char[] cArray, int n2, int n3) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(cArray, n2, n3, this.remainCharCount, this.pushCharCount);
    }

    public Hyphenation hyphenate(String string) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(string, this.remainCharCount, this.pushCharCount);
    }

    public static String getHyphenDir() {
        return hyphenDir;
    }

    public static void setHyphenDir(String string) {
        hyphenDir = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

