/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import java.io.Serializable;

public class ByteVector
implements Serializable {
    private static final int DEFAULT_BLOCK_SIZE = 2048;
    private int BLOCK_SIZE;
    private byte[] array;
    private int n;

    public ByteVector() {
        this(2048);
    }

    public ByteVector(int n2) {
        this.BLOCK_SIZE = n2 > 0 ? n2 : 2048;
        this.array = new byte[this.BLOCK_SIZE];
        this.n = 0;
    }

    public ByteVector(byte[] byArray) {
        this.BLOCK_SIZE = 2048;
        this.array = byArray;
        this.n = 0;
    }

    public ByteVector(byte[] byArray, int n2) {
        this.BLOCK_SIZE = n2 > 0 ? n2 : 2048;
        this.array = byArray;
        this.n = 0;
    }

    public byte[] getArray() {
        return this.array;
    }

    public int length() {
        return this.n;
    }

    public int capacity() {
        return this.array.length;
    }

    public void put(int n2, byte by) {
        this.array[n2] = by;
    }

    public byte get(int n2) {
        return this.array[n2];
    }

    public int alloc(int n2) {
        int n3 = this.n;
        int n4 = this.array.length;
        if (this.n + n2 >= n4) {
            byte[] byArray = new byte[n4 + this.BLOCK_SIZE];
            System.arraycopy(this.array, 0, byArray, 0, n4);
            this.array = byArray;
        }
        this.n += n2;
        return n3;
    }

    public void trimToSize() {
        if (this.n < this.array.length) {
            byte[] byArray = new byte[this.n];
            System.arraycopy(this.array, 0, byArray, 0, this.n);
            this.array = byArray;
        }
    }
}

