/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class PngImage {
    public static final int[] PNGID = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    public static final String IHDR = "IHDR";
    public static final String PLTE = "PLTE";
    public static final String IDAT = "IDAT";
    public static final String IEND = "IEND";
    public static final String tRNS = "tRNS";
    public static final String pHYs = "pHYs";
    public static final String gAMA = "gAMA";
    public static final String cHRM = "cHRM";
    public static final String sRGB = "sRGB";
    public static final String iCCP = "iCCP";
    private static final int TRANSFERSIZE = 4096;
    private static final int PNG_FILTER_NONE = 0;
    private static final int PNG_FILTER_SUB = 1;
    private static final int PNG_FILTER_UP = 2;
    private static final int PNG_FILTER_AVERAGE = 3;
    private static final int PNG_FILTER_PAETH = 4;
    private static final PdfName[] intents = new PdfName[]{PdfName.PERCEPTUAL, PdfName.RELATIVECALORIMETRIC, PdfName.SATURATION, PdfName.ABSOLUTECALORIMETRIC};
    InputStream is;
    DataInputStream dataStream;
    int width;
    int height;
    int bitDepth;
    int colorType;
    int compressionMethod;
    int filterMethod;
    int interlaceMethod;
    PdfDictionary additional = new PdfDictionary();
    byte[] image;
    byte[] smask;
    byte[] trans;
    NewByteArrayOutputStream idat = new NewByteArrayOutputStream();
    int dpiX;
    int dpiY;
    float XYRatio;
    boolean genBWMask;
    boolean palShades;
    int transRedGray = -1;
    int transGreen = -1;
    int transBlue = -1;
    int inputBands;
    int bytesPerPixel;
    byte[] colorTable;
    float gamma = 1.0f;
    boolean hasCHRM = false;
    float xW;
    float yW;
    float xR;
    float yR;
    float xG;
    float yG;
    float xB;
    float yB;
    PdfName intent;
    ICC_Profile icc_profile;

    PngImage(InputStream inputStream) {
        this.is = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Image image = PngImage.getImage(inputStream);
            image.setUrl(uRL);
            Image image2 = image;
            return image2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static Image getImage(InputStream inputStream) throws IOException {
        PngImage pngImage = new PngImage(inputStream);
        return pngImage.getImage();
    }

    public static Image getImage(String string) throws IOException {
        return PngImage.getImage(Image.toURL(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            Image image = PngImage.getImage(byteArrayInputStream);
            image.setOriginalData(byArray);
            Image image2 = image;
            return image2;
        }
        finally {
            if (byteArrayInputStream != null) {
                ((InputStream)byteArrayInputStream).close();
            }
        }
    }

    boolean checkMarker(String string) {
        if (string.length() != 4) {
            return false;
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') continue;
            return false;
        }
        return true;
    }

    void readPng() throws IOException {
        for (int i2 = 0; i2 < PNGID.length; ++i2) {
            if (PNGID[i2] == this.is.read()) continue;
            throw new IOException("File is not a valid PNG.");
        }
        byte[] byArray = new byte[4096];
        while (true) {
            int n2;
            int n3;
            int n4;
            String string = PngImage.getString(this.is);
            if (n4 < 0 || !this.checkMarker(string)) {
                throw new IOException("Corrupted PNG file.");
            }
            if (IDAT.equals(string)) {
                int n5;
                for (n4 = PngImage.getInt(this.is); n4 != 0; n4 -= n5) {
                    n5 = this.is.read(byArray, 0, Math.min(n4, 4096));
                    if (n5 < 0) {
                        return;
                    }
                    this.idat.write(byArray, 0, n5);
                }
            } else if (tRNS.equals(string)) {
                switch (this.colorType) {
                    case 0: {
                        if (n4 < 2) break;
                        n4 -= 2;
                        int n6 = PngImage.getWord(this.is);
                        if (this.bitDepth == 16) {
                            this.transRedGray = n6;
                            break;
                        }
                        this.additional.put(PdfName.MASK, new PdfLiteral("[" + n6 + " " + n6 + "]"));
                        break;
                    }
                    case 2: {
                        if (n4 < 6) break;
                        n4 -= 6;
                        int n7 = PngImage.getWord(this.is);
                        n3 = PngImage.getWord(this.is);
                        n2 = PngImage.getWord(this.is);
                        if (this.bitDepth == 16) {
                            this.transRedGray = n7;
                            this.transGreen = n3;
                            this.transBlue = n2;
                            break;
                        }
                        this.additional.put(PdfName.MASK, new PdfLiteral("[" + n7 + " " + n7 + " " + n3 + " " + n3 + " " + n2 + " " + n2 + "]"));
                        break;
                    }
                    case 3: {
                        if (n4 <= 0) break;
                        this.trans = new byte[n4];
                        for (int i3 = 0; i3 < n4; ++i3) {
                            this.trans[i3] = (byte)this.is.read();
                        }
                        n4 = 0;
                    }
                }
                Image.skip(this.is, n4);
            } else if (IHDR.equals(string)) {
                this.width = PngImage.getInt(this.is);
                this.height = PngImage.getInt(this.is);
                this.bitDepth = this.is.read();
                this.colorType = this.is.read();
                this.compressionMethod = this.is.read();
                this.filterMethod = this.is.read();
                this.interlaceMethod = this.is.read();
            } else if (PLTE.equals(string)) {
                if (this.colorType == 3) {
                    PdfArray pdfArray = new PdfArray();
                    pdfArray.add(PdfName.INDEXED);
                    pdfArray.add(this.getColorspace());
                    pdfArray.add(new PdfNumber(n4 / 3 - 1));
                    ByteBuffer byteBuffer = new ByteBuffer();
                    while (n4-- > 0) {
                        byteBuffer.append_i(this.is.read());
                    }
                    this.colorTable = byteBuffer.toByteArray();
                    pdfArray.add(new PdfString(this.colorTable));
                    this.additional.put(PdfName.COLORSPACE, pdfArray);
                } else {
                    Image.skip(this.is, n4);
                }
            } else if (pHYs.equals(string)) {
                int n8 = PngImage.getInt(this.is);
                n3 = PngImage.getInt(this.is);
                n2 = this.is.read();
                if (n2 == 1) {
                    this.dpiX = (int)((float)n8 * 0.0254f);
                    this.dpiY = (int)((float)n3 * 0.0254f);
                } else if (n3 != 0) {
                    this.XYRatio = (float)n8 / (float)n3;
                }
            } else if (cHRM.equals(string)) {
                this.xW = (float)PngImage.getInt(this.is) / 100000.0f;
                this.yW = (float)PngImage.getInt(this.is) / 100000.0f;
                this.xR = (float)PngImage.getInt(this.is) / 100000.0f;
                this.yR = (float)PngImage.getInt(this.is) / 100000.0f;
                this.xG = (float)PngImage.getInt(this.is) / 100000.0f;
                this.yG = (float)PngImage.getInt(this.is) / 100000.0f;
                this.xB = (float)PngImage.getInt(this.is) / 100000.0f;
                this.yB = (float)PngImage.getInt(this.is) / 100000.0f;
                this.hasCHRM = !(Math.abs(this.xW) < 1.0E-4f || Math.abs(this.yW) < 1.0E-4f || Math.abs(this.xR) < 1.0E-4f || Math.abs(this.yR) < 1.0E-4f || Math.abs(this.xG) < 1.0E-4f || Math.abs(this.yG) < 1.0E-4f || Math.abs(this.xB) < 1.0E-4f || Math.abs(this.yB) < 1.0E-4f);
            } else if (sRGB.equals(string)) {
                int n9 = this.is.read();
                this.intent = intents[n9];
                this.gamma = 2.2f;
                this.xW = 0.3127f;
                this.yW = 0.329f;
                this.xR = 0.64f;
                this.yR = 0.33f;
                this.xG = 0.3f;
                this.yG = 0.6f;
                this.xB = 0.15f;
                this.yB = 0.06f;
                this.hasCHRM = true;
            } else if (gAMA.equals(string)) {
                int n10 = PngImage.getInt(this.is);
                if (n10 != 0) {
                    this.gamma = 100000.0f / (float)n10;
                    if (!this.hasCHRM) {
                        this.xW = 0.3127f;
                        this.yW = 0.329f;
                        this.xR = 0.64f;
                        this.yR = 0.33f;
                        this.xG = 0.3f;
                        this.yG = 0.6f;
                        this.xB = 0.15f;
                        this.yB = 0.06f;
                        this.hasCHRM = true;
                    }
                }
            } else if (iCCP.equals(string)) {
                do {
                    --n4;
                } while (this.is.read() != 0);
                this.is.read();
                byte[] byArray2 = new byte[--n4];
                n3 = 0;
                while (n4 > 0) {
                    n2 = this.is.read(byArray2, n3, n4);
                    if (n2 < 0) {
                        throw new IOException("Premature end of file.");
                    }
                    n3 += n2;
                    n4 -= n2;
                }
                byte[] byArray3 = PdfReader.FlateDecode(byArray2, true);
                byArray2 = null;
                try {
                    this.icc_profile = ICC_Profile.getInstance(byArray3);
                }
                catch (Exception exception) {
                    this.icc_profile = null;
                }
            } else {
                if (IEND.equals(string)) break;
                Image.skip(this.is, n4);
            }
            Image.skip(this.is, 4);
        }
    }

    PdfObject getColorspace() {
        if (this.icc_profile != null) {
            if ((this.colorType & 2) == 0) {
                return PdfName.DEVICEGRAY;
            }
            return PdfName.DEVICERGB;
        }
        if (this.gamma == 1.0f && !this.hasCHRM) {
            if ((this.colorType & 2) == 0) {
                return PdfName.DEVICEGRAY;
            }
            return PdfName.DEVICERGB;
        }
        PdfArray pdfArray = new PdfArray();
        PdfDictionary pdfDictionary = new PdfDictionary();
        if ((this.colorType & 2) == 0) {
            if (this.gamma == 1.0f) {
                return PdfName.DEVICEGRAY;
            }
            pdfArray.add(PdfName.CALGRAY);
            pdfDictionary.put(PdfName.GAMMA, new PdfNumber(this.gamma));
            pdfDictionary.put(PdfName.WHITEPOINT, new PdfLiteral("[1 1 1]"));
            pdfArray.add(pdfDictionary);
        } else {
            PdfObject pdfObject = new PdfLiteral("[1 1 1]");
            pdfArray.add(PdfName.CALRGB);
            if (this.gamma != 1.0f) {
                PdfArray pdfArray2 = new PdfArray();
                PdfNumber pdfNumber = new PdfNumber(this.gamma);
                pdfArray2.add(pdfNumber);
                pdfArray2.add(pdfNumber);
                pdfArray2.add(pdfNumber);
                pdfDictionary.put(PdfName.GAMMA, pdfArray2);
            }
            if (this.hasCHRM) {
                float f2 = this.yW * ((this.xG - this.xB) * this.yR - (this.xR - this.xB) * this.yG + (this.xR - this.xG) * this.yB);
                float f3 = this.yR * ((this.xG - this.xB) * this.yW - (this.xW - this.xB) * this.yG + (this.xW - this.xG) * this.yB) / f2;
                float f4 = f3 * this.xR / this.yR;
                float f5 = f3 * ((1.0f - this.xR) / this.yR - 1.0f);
                float f6 = -this.yG * ((this.xR - this.xB) * this.yW - (this.xW - this.xB) * this.yR + (this.xW - this.xR) * this.yB) / f2;
                float f7 = f6 * this.xG / this.yG;
                float f8 = f6 * ((1.0f - this.xG) / this.yG - 1.0f);
                float f9 = this.yB * ((this.xR - this.xG) * this.yW - (this.xW - this.xG) * this.yW + (this.xW - this.xR) * this.yG) / f2;
                float f10 = f9 * this.xB / this.yB;
                float f11 = f9 * ((1.0f - this.xB) / this.yB - 1.0f);
                float f12 = f4 + f7 + f10;
                float f13 = 1.0f;
                float f14 = f5 + f8 + f11;
                PdfArray pdfArray3 = new PdfArray();
                pdfArray3.add(new PdfNumber(f12));
                pdfArray3.add(new PdfNumber(f13));
                pdfArray3.add(new PdfNumber(f14));
                pdfObject = pdfArray3;
                PdfArray pdfArray4 = new PdfArray();
                pdfArray4.add(new PdfNumber(f4));
                pdfArray4.add(new PdfNumber(f3));
                pdfArray4.add(new PdfNumber(f5));
                pdfArray4.add(new PdfNumber(f7));
                pdfArray4.add(new PdfNumber(f6));
                pdfArray4.add(new PdfNumber(f8));
                pdfArray4.add(new PdfNumber(f10));
                pdfArray4.add(new PdfNumber(f9));
                pdfArray4.add(new PdfNumber(f11));
                pdfDictionary.put(PdfName.MATRIX, pdfArray4);
            }
            pdfDictionary.put(PdfName.WHITEPOINT, pdfObject);
            pdfArray.add(pdfDictionary);
        }
        return pdfArray;
    }

    Image getImage() throws IOException {
        this.readPng();
        try {
            Object object;
            Image image;
            int n2;
            int n3;
            int n4;
            int n5 = 0;
            int n6 = 0;
            this.palShades = false;
            if (this.trans != null) {
                for (n4 = 0; n4 < this.trans.length; ++n4) {
                    n3 = this.trans[n4] & 0xFF;
                    if (n3 == 0) {
                        ++n5;
                        n6 = n4;
                    }
                    if (n3 == 0 || n3 == 255) continue;
                    this.palShades = true;
                    break;
                }
            }
            if ((this.colorType & 4) != 0) {
                this.palShades = true;
            }
            boolean bl = this.genBWMask = !this.palShades && (n5 > 1 || this.transRedGray >= 0);
            if (!this.palShades && !this.genBWMask && n5 == 1) {
                this.additional.put(PdfName.MASK, new PdfLiteral("[" + n6 + " " + n6 + "]"));
            }
            n4 = this.interlaceMethod == 1 || this.bitDepth == 16 || (this.colorType & 4) != 0 || this.palShades || this.genBWMask ? 1 : 0;
            switch (this.colorType) {
                case 0: {
                    this.inputBands = 1;
                    break;
                }
                case 2: {
                    this.inputBands = 3;
                    break;
                }
                case 3: {
                    this.inputBands = 1;
                    break;
                }
                case 4: {
                    this.inputBands = 2;
                    break;
                }
                case 6: {
                    this.inputBands = 4;
                }
            }
            if (n4 != 0) {
                this.decodeIdat();
            }
            n3 = this.inputBands;
            if ((this.colorType & 4) != 0) {
                --n3;
            }
            if ((n2 = this.bitDepth) == 16) {
                n2 = 8;
            }
            if (this.image != null) {
                image = Image.getInstance(this.width, this.height, n3, n2, this.image);
            } else {
                image = new ImgRaw(this.width, this.height, n3, n2, this.idat.toByteArray());
                image.setDeflated(true);
                object = new PdfDictionary();
                ((PdfDictionary)object).put(PdfName.BITSPERCOMPONENT, new PdfNumber(this.bitDepth));
                ((PdfDictionary)object).put(PdfName.PREDICTOR, new PdfNumber(15));
                ((PdfDictionary)object).put(PdfName.COLUMNS, new PdfNumber(this.width));
                ((PdfDictionary)object).put(PdfName.COLORS, new PdfNumber(this.colorType == 3 || (this.colorType & 2) == 0 ? 1 : 3));
                this.additional.put(PdfName.DECODEPARMS, (PdfObject)object);
            }
            if (this.additional.get(PdfName.COLORSPACE) == null) {
                this.additional.put(PdfName.COLORSPACE, this.getColorspace());
            }
            if (this.intent != null) {
                this.additional.put(PdfName.INTENT, this.intent);
            }
            if (this.additional.size() > 0) {
                image.setAdditional(this.additional);
            }
            if (this.icc_profile != null) {
                image.tagICC(this.icc_profile);
            }
            if (this.palShades) {
                object = Image.getInstance(this.width, this.height, 1, 8, this.smask);
                ((Image)object).makeMask();
                image.setImageMask((Image)object);
            }
            if (this.genBWMask) {
                object = Image.getInstance(this.width, this.height, 1, 1, this.smask);
                ((Image)object).makeMask();
                image.setImageMask((Image)object);
            }
            image.setDpi(this.dpiX, this.dpiY);
            image.setXYRatio(this.XYRatio);
            image.setOriginalType(2);
            return image;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    void decodeIdat() {
        int n2 = this.bitDepth;
        if (n2 == 16) {
            n2 = 8;
        }
        int n3 = -1;
        this.bytesPerPixel = this.bitDepth == 16 ? 2 : 1;
        switch (this.colorType) {
            case 0: {
                n3 = (n2 * this.width + 7) / 8 * this.height;
                break;
            }
            case 2: {
                n3 = this.width * 3 * this.height;
                this.bytesPerPixel *= 3;
                break;
            }
            case 3: {
                if (this.interlaceMethod == 1) {
                    n3 = (n2 * this.width + 7) / 8 * this.height;
                }
                this.bytesPerPixel = 1;
                break;
            }
            case 4: {
                n3 = this.width * this.height;
                this.bytesPerPixel *= 2;
                break;
            }
            case 6: {
                n3 = this.width * 3 * this.height;
                this.bytesPerPixel *= 4;
            }
        }
        if (n3 >= 0) {
            this.image = new byte[n3];
        }
        if (this.palShades) {
            this.smask = new byte[this.width * this.height];
        } else if (this.genBWMask) {
            this.smask = new byte[(this.width + 7) / 8 * this.height];
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.idat.getBuf(), 0, this.idat.size());
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, new Inflater());
        this.dataStream = new DataInputStream(inflaterInputStream);
        if (this.interlaceMethod != 1) {
            this.decodePass(0, 0, 1, 1, this.width, this.height);
        } else {
            this.decodePass(0, 0, 8, 8, (this.width + 7) / 8, (this.height + 7) / 8);
            this.decodePass(4, 0, 8, 8, (this.width + 3) / 8, (this.height + 7) / 8);
            this.decodePass(0, 4, 4, 8, (this.width + 3) / 4, (this.height + 3) / 8);
            this.decodePass(2, 0, 4, 4, (this.width + 1) / 4, (this.height + 3) / 4);
            this.decodePass(0, 2, 2, 4, (this.width + 1) / 2, (this.height + 1) / 4);
            this.decodePass(1, 0, 2, 2, this.width / 2, (this.height + 1) / 2);
            this.decodePass(0, 1, 1, 2, this.width, this.height / 2);
        }
    }

    void decodePass(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 == 0 || n7 == 0) {
            return;
        }
        int n8 = (this.inputBands * n6 * this.bitDepth + 7) / 8;
        byte[] byArray = new byte[n8];
        byte[] byArray2 = new byte[n8];
        int n9 = 0;
        int n10 = n3;
        while (n9 < n7) {
            int n11 = 0;
            try {
                n11 = this.dataStream.read();
                this.dataStream.readFully(byArray, 0, n8);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (n11) {
                case 0: {
                    break;
                }
                case 1: {
                    PngImage.decodeSubFilter(byArray, n8, this.bytesPerPixel);
                    break;
                }
                case 2: {
                    PngImage.decodeUpFilter(byArray, byArray2, n8);
                    break;
                }
                case 3: {
                    PngImage.decodeAverageFilter(byArray, byArray2, n8, this.bytesPerPixel);
                    break;
                }
                case 4: {
                    PngImage.decodePaethFilter(byArray, byArray2, n8, this.bytesPerPixel);
                    break;
                }
                default: {
                    throw new RuntimeException("PNG filter unknown.");
                }
            }
            this.processPixels(byArray, n2, n4, n10, n6);
            byte[] byArray3 = byArray2;
            byArray2 = byArray;
            byArray = byArray3;
            ++n9;
            n10 += n5;
        }
    }

    void processPixels(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int[] nArray = this.getPixel(byArray);
        int n9 = 0;
        switch (this.colorType) {
            case 0: 
            case 3: 
            case 4: {
                n9 = 1;
                break;
            }
            case 2: 
            case 6: {
                n9 = 3;
            }
        }
        if (this.image != null) {
            n8 = n2;
            n7 = (n9 * this.width * (this.bitDepth == 16 ? 8 : this.bitDepth) + 7) / 8;
            for (n6 = 0; n6 < n5; ++n6) {
                PngImage.setPixel(this.image, nArray, this.inputBands * n6, n9, n8, n4, this.bitDepth, n7);
                n8 += n3;
            }
        }
        if (this.palShades) {
            if ((this.colorType & 4) != 0) {
                if (this.bitDepth == 16) {
                    for (n7 = 0; n7 < n5; ++n7) {
                        int n10 = n7 * this.inputBands + n9;
                        nArray[n10] = nArray[n10] >>> 8;
                    }
                }
                n7 = this.width;
                n8 = n2;
                for (n6 = 0; n6 < n5; ++n6) {
                    PngImage.setPixel(this.smask, nArray, this.inputBands * n6 + n9, 1, n8, n4, 8, n7);
                    n8 += n3;
                }
            } else {
                n7 = this.width;
                int[] nArray2 = new int[1];
                n8 = n2;
                for (n6 = 0; n6 < n5; ++n6) {
                    int n11 = nArray[n6];
                    int n12 = 255;
                    if (n11 < this.trans.length) {
                        nArray2[0] = this.trans[n11];
                    }
                    PngImage.setPixel(this.smask, nArray2, 0, 1, n8, n4, 8, n7);
                    n8 += n3;
                }
            }
        } else if (this.genBWMask) {
            switch (this.colorType) {
                case 3: {
                    n7 = (this.width + 7) / 8;
                    int[] nArray3 = new int[1];
                    n8 = n2;
                    for (n6 = 0; n6 < n5; ++n6) {
                        int n13 = nArray[n6];
                        boolean bl = false;
                        if (n13 < this.trans.length) {
                            nArray3[0] = this.trans[n13] == 0 ? 1 : 0;
                        }
                        PngImage.setPixel(this.smask, nArray3, 0, 1, n8, n4, 1, n7);
                        n8 += n3;
                    }
                    break;
                }
                case 0: {
                    n7 = (this.width + 7) / 8;
                    int[] nArray4 = new int[1];
                    n8 = n2;
                    for (n6 = 0; n6 < n5; ++n6) {
                        int n14 = nArray[n6];
                        nArray4[0] = n14 == this.transRedGray ? 1 : 0;
                        PngImage.setPixel(this.smask, nArray4, 0, 1, n8, n4, 1, n7);
                        n8 += n3;
                    }
                    break;
                }
                case 2: {
                    n7 = (this.width + 7) / 8;
                    int[] nArray5 = new int[1];
                    n8 = n2;
                    for (n6 = 0; n6 < n5; ++n6) {
                        int n15 = this.inputBands * n6;
                        nArray5[0] = nArray[n15] == this.transRedGray && nArray[n15 + 1] == this.transGreen && nArray[n15 + 2] == this.transBlue ? 1 : 0;
                        PngImage.setPixel(this.smask, nArray5, 0, 1, n8, n4, 1, n7);
                        n8 += n3;
                    }
                    break;
                }
            }
        }
    }

    static int getPixel(byte[] byArray, int n2, int n3, int n4, int n5) {
        if (n4 == 8) {
            int n6 = n5 * n3 + n2;
            return byArray[n6] & 0xFF;
        }
        int n7 = n5 * n3 + n2 / (8 / n4);
        int n8 = byArray[n7] >> 8 - n4 * (n2 % (8 / n4)) - n4;
        return n8 & (1 << n4) - 1;
    }

    static void setPixel(byte[] byArray, int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 == 8) {
            int n8 = n7 * n5 + n3 * n4;
            for (int i2 = 0; i2 < n3; ++i2) {
                byArray[n8 + i2] = (byte)nArray[i2 + n2];
            }
        } else if (n6 == 16) {
            int n9 = n7 * n5 + n3 * n4;
            for (int i3 = 0; i3 < n3; ++i3) {
                byArray[n9 + i3] = (byte)(nArray[i3 + n2] >>> 8);
            }
        } else {
            int n10 = n7 * n5 + n4 / (8 / n6);
            int n11 = nArray[n2] << 8 - n6 * (n4 % (8 / n6)) - n6;
            int n12 = n10;
            byArray[n12] = (byte)(byArray[n12] | n11);
        }
    }

    int[] getPixel(byte[] byArray) {
        switch (this.bitDepth) {
            case 8: {
                int[] nArray = new int[byArray.length];
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    nArray[i2] = byArray[i2] & 0xFF;
                }
                return nArray;
            }
            case 16: {
                int[] nArray = new int[byArray.length / 2];
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    nArray[i3] = ((byArray[i3 * 2] & 0xFF) << 8) + (byArray[i3 * 2 + 1] & 0xFF);
                }
                return nArray;
            }
        }
        int[] nArray = new int[byArray.length * 8 / this.bitDepth];
        int n2 = 0;
        int n3 = 8 / this.bitDepth;
        int n4 = (1 << this.bitDepth) - 1;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            for (int i5 = n3 - 1; i5 >= 0; --i5) {
                nArray[n2++] = byArray[i4] >>> this.bitDepth * i5 & n4;
            }
        }
        return nArray;
    }

    private static void decodeSubFilter(byte[] byArray, int n2, int n3) {
        for (int i2 = n3; i2 < n2; ++i2) {
            int n4 = byArray[i2] & 0xFF;
            byArray[i2] = (byte)(n4 += byArray[i2 - n3] & 0xFF);
        }
    }

    private static void decodeUpFilter(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            int n4 = byArray2[i2] & 0xFF;
            byArray[i2] = (byte)(n3 + n4);
        }
    }

    private static void decodeAverageFilter(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < n3; ++n6) {
            n5 = byArray[n6] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n5 + n4 / 2);
        }
        for (n6 = n3; n6 < n2; ++n6) {
            n5 = byArray[n6] & 0xFF;
            int n7 = byArray[n6 - n3] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n5 + (n7 + n4) / 2);
        }
    }

    private static int paethPredictor(int n2, int n3, int n4) {
        int n5 = n2 + n3 - n4;
        int n6 = Math.abs(n5 - n2);
        int n7 = Math.abs(n5 - n3);
        int n8 = Math.abs(n5 - n4);
        if (n6 <= n7 && n6 <= n8) {
            return n2;
        }
        if (n7 <= n8) {
            return n3;
        }
        return n4;
    }

    private static void decodePaethFilter(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < n3; ++n6) {
            n5 = byArray[n6] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n5 + n4);
        }
        for (n6 = n3; n6 < n2; ++n6) {
            n5 = byArray[n6] & 0xFF;
            int n7 = byArray[n6 - n3] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            int n8 = byArray2[n6 - n3] & 0xFF;
            byArray[n6] = (byte)(n5 + PngImage.paethPredictor(n7, n4, n8));
        }
    }

    public static final int getInt(InputStream inputStream) throws IOException {
        return (inputStream.read() << 24) + (inputStream.read() << 16) + (inputStream.read() << 8) + inputStream.read();
    }

    public static final int getWord(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    public static final String getString(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < 4; ++i2) {
            stringBuffer.append((char)inputStream.read());
        }
        return stringBuffer.toString();
    }

    static class NewByteArrayOutputStream
    extends ByteArrayOutputStream {
        NewByteArrayOutputStream() {
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

