/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class GifImage {
    protected DataInputStream in;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int bgIndex;
    protected int bgColor;
    protected int pixelAspect;
    protected boolean lctFlag;
    protected boolean interlace;
    protected int lctSize;
    protected int ix;
    protected int iy;
    protected int iw;
    protected int ih;
    protected byte[] block = new byte[256];
    protected int blockSize = 0;
    protected int dispose = 0;
    protected boolean transparency = false;
    protected int delay = 0;
    protected int transIndex;
    protected static final int MaxStackSize = 4096;
    protected short[] prefix;
    protected byte[] suffix;
    protected byte[] pixelStack;
    protected byte[] pixels;
    protected byte[] m_out;
    protected int m_bpc;
    protected int m_gbpc;
    protected byte[] m_global_table;
    protected byte[] m_local_table;
    protected byte[] m_curr_table;
    protected int m_line_stride;
    protected byte[] fromData;
    protected URL fromUrl;
    protected ArrayList frames = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GifImage(URL uRL) throws IOException {
        this.fromUrl = uRL;
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            this.process(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public GifImage(String string) throws IOException {
        this(Image.toURL(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GifImage(byte[] byArray) throws IOException {
        this.fromData = byArray;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.process(byteArrayInputStream);
        }
        finally {
            if (byteArrayInputStream != null) {
                ((InputStream)byteArrayInputStream).close();
            }
        }
    }

    public GifImage(InputStream inputStream) throws IOException {
        this.process(inputStream);
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public Image getImage(int n2) {
        GifFrame gifFrame = (GifFrame)this.frames.get(n2 - 1);
        return gifFrame.image;
    }

    public int[] getFramePosition(int n2) {
        GifFrame gifFrame = (GifFrame)this.frames.get(n2 - 1);
        return new int[]{gifFrame.ix, gifFrame.iy};
    }

    public int[] getLogicalScreen() {
        return new int[]{this.width, this.height};
    }

    void process(InputStream inputStream) throws IOException {
        this.in = new DataInputStream(new BufferedInputStream(inputStream));
        this.readHeader();
        this.readContents();
        if (this.frames.size() == 0) {
            throw new IOException("The file does not contain any valid image.");
        }
    }

    protected void readHeader() throws IOException {
        String string = "";
        for (int i2 = 0; i2 < 6; ++i2) {
            string = string + (char)this.in.read();
        }
        if (!string.startsWith("GIF8")) {
            throw new IOException("Gif signature nor found.");
        }
        this.readLSD();
        if (this.gctFlag) {
            this.m_global_table = this.readColorTable(this.m_gbpc);
        }
    }

    protected void readLSD() throws IOException {
        this.width = this.readShort();
        this.height = this.readShort();
        int n2 = this.in.read();
        this.gctFlag = (n2 & 0x80) != 0;
        this.m_gbpc = (n2 & 7) + 1;
        this.bgIndex = this.in.read();
        this.pixelAspect = this.in.read();
    }

    protected int readShort() throws IOException {
        return this.in.read() | this.in.read() << 8;
    }

    protected int readBlock() throws IOException {
        this.blockSize = this.in.read();
        if (this.blockSize <= 0) {
            this.blockSize = 0;
            return 0;
        }
        for (int i2 = 0; i2 < this.blockSize; ++i2) {
            int n2 = this.in.read();
            if (n2 < 0) {
                this.blockSize = i2;
                return this.blockSize;
            }
            this.block[i2] = (byte)n2;
        }
        return this.blockSize;
    }

    protected byte[] readColorTable(int n2) throws IOException {
        int n3 = 1 << n2;
        int n4 = 3 * n3;
        n2 = GifImage.newBpc(n2);
        byte[] byArray = new byte[(1 << n2) * 3];
        this.in.readFully(byArray, 0, n4);
        return byArray;
    }

    protected static int newBpc(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                return 4;
            }
            default: {
                return 8;
            }
        }
        return n2;
    }

    protected void readContents() throws IOException {
        boolean bl = false;
        block8: while (!bl) {
            int n2 = this.in.read();
            switch (n2) {
                case 44: {
                    this.readImage();
                    continue block8;
                }
                case 33: {
                    n2 = this.in.read();
                    switch (n2) {
                        case 249: {
                            this.readGraphicControlExt();
                            continue block8;
                        }
                        case 255: {
                            this.readBlock();
                            this.skip();
                            continue block8;
                        }
                    }
                    this.skip();
                    continue block8;
                }
            }
            bl = true;
        }
    }

    protected void readImage() throws IOException {
        Object object;
        boolean bl;
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int n2 = this.in.read();
        this.lctFlag = (n2 & 0x80) != 0;
        this.interlace = (n2 & 0x40) != 0;
        this.lctSize = 2 << (n2 & 7);
        this.m_bpc = GifImage.newBpc(this.m_gbpc);
        if (this.lctFlag) {
            this.m_curr_table = this.readColorTable((n2 & 7) + 1);
            this.m_bpc = GifImage.newBpc((n2 & 7) + 1);
        } else {
            this.m_curr_table = this.m_global_table;
        }
        if (this.transparency && this.transIndex >= this.m_curr_table.length / 3) {
            this.transparency = false;
        }
        if (this.transparency && this.m_bpc == 1) {
            byte[] byArray = new byte[12];
            System.arraycopy(this.m_curr_table, 0, byArray, 0, 6);
            this.m_curr_table = byArray;
            this.m_bpc = 2;
        }
        if (!(bl = this.decodeImageData())) {
            this.skip();
        }
        ImgRaw imgRaw = null;
        try {
            imgRaw = new ImgRaw(this.iw, this.ih, 1, this.m_bpc, this.m_out);
            object = new PdfArray();
            ((PdfArray)object).add(PdfName.INDEXED);
            ((PdfArray)object).add(PdfName.DEVICERGB);
            int n3 = this.m_curr_table.length;
            ((PdfArray)object).add(new PdfNumber(n3 / 3 - 1));
            ((PdfArray)object).add(new PdfString(this.m_curr_table));
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.put(PdfName.COLORSPACE, (PdfObject)object);
            imgRaw.setAdditional(pdfDictionary);
            if (this.transparency) {
                imgRaw.setTransparency(new int[]{this.transIndex, this.transIndex});
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        imgRaw.setOriginalType(3);
        imgRaw.setOriginalData(this.fromData);
        imgRaw.setUrl(this.fromUrl);
        object = new GifFrame();
        ((GifFrame)object).image = imgRaw;
        ((GifFrame)object).ix = this.ix;
        ((GifFrame)object).iy = this.iy;
        this.frames.add(object);
        this.resetFrame();
    }

    protected boolean decodeImageData() throws IOException {
        int n2;
        int n3 = -1;
        int n4 = this.iw * this.ih;
        boolean bl = false;
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        this.m_line_stride = (this.iw * this.m_bpc + 7) / 8;
        this.m_out = new byte[this.m_line_stride * this.ih];
        int n5 = 1;
        int n6 = this.interlace ? 8 : 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = this.in.read();
        int n10 = 1 << n9;
        int n11 = n10 + 1;
        int n12 = n10 + 2;
        int n13 = n3;
        int n14 = n9 + 1;
        int n15 = (1 << n14) - 1;
        for (n2 = 0; n2 < n10; ++n2) {
            this.prefix[n2] = 0;
            this.suffix[n2] = (byte)n2;
        }
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        while (n23 < n4) {
            if (n18 == 0) {
                if (n21 < n14) {
                    if (n20 == 0) {
                        n20 = this.readBlock();
                        if (n20 <= 0) {
                            bl = true;
                            break;
                        }
                        n16 = 0;
                    }
                    n22 += (this.block[n16] & 0xFF) << n21;
                    n21 += 8;
                    ++n16;
                    --n20;
                    continue;
                }
                n2 = n22 & n15;
                n22 >>= n14;
                n21 -= n14;
                if (n2 > n12 || n2 == n11) break;
                if (n2 == n10) {
                    n14 = n9 + 1;
                    n15 = (1 << n14) - 1;
                    n12 = n10 + 2;
                    n13 = n3;
                    continue;
                }
                if (n13 == n3) {
                    this.pixelStack[n18++] = this.suffix[n2];
                    n13 = n2;
                    n19 = n2;
                    continue;
                }
                int n24 = n2;
                if (n2 == n12) {
                    this.pixelStack[n18++] = (byte)n19;
                    n2 = n13;
                }
                while (n2 > n10) {
                    this.pixelStack[n18++] = this.suffix[n2];
                    n2 = this.prefix[n2];
                }
                n19 = this.suffix[n2] & 0xFF;
                if (n12 >= 4096) break;
                this.pixelStack[n18++] = (byte)n19;
                this.prefix[n12] = (short)n13;
                this.suffix[n12] = (byte)n19;
                if ((++n12 & n15) == 0 && n12 < 4096) {
                    ++n14;
                    n15 += n12;
                }
                n13 = n24;
            }
            ++n23;
            this.setPixel(n8, n7, this.pixelStack[--n18]);
            if (++n8 < this.iw) continue;
            n8 = 0;
            if ((n7 += n6) < this.ih) continue;
            if (this.interlace) {
                do {
                    switch (++n5) {
                        case 2: {
                            n7 = 4;
                            break;
                        }
                        case 3: {
                            n7 = 2;
                            n6 = 4;
                            break;
                        }
                        case 4: {
                            n7 = 1;
                            n6 = 2;
                            break;
                        }
                        default: {
                            n7 = this.ih - 1;
                            n6 = 0;
                        }
                    }
                } while (n7 >= this.ih);
                continue;
            }
            n7 = this.ih - 1;
            n6 = 0;
        }
        return bl;
    }

    protected void setPixel(int n2, int n3, int n4) {
        if (this.m_bpc == 8) {
            int n5 = n2 + this.iw * n3;
            this.m_out[n5] = (byte)n4;
        } else {
            int n6 = this.m_line_stride * n3 + n2 / (8 / this.m_bpc);
            int n7 = n4 << 8 - this.m_bpc * (n2 % (8 / this.m_bpc)) - this.m_bpc;
            int n8 = n6;
            this.m_out[n8] = (byte)(this.m_out[n8] | n7);
        }
    }

    protected void resetFrame() {
        boolean bl = false;
        boolean bl2 = false;
    }

    protected void readGraphicControlExt() throws IOException {
        this.in.read();
        int n2 = this.in.read();
        this.dispose = (n2 & 0x1C) >> 2;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.transparency = (n2 & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.in.read();
        this.in.read();
    }

    protected void skip() throws IOException {
        do {
            this.readBlock();
        } while (this.blockSize > 0);
    }

    static class GifFrame {
        Image image;
        int ix;
        int iy;

        GifFrame() {
        }
    }
}

