/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;

public class TextField
extends BaseField {
    private String defaultText;
    private String[] choices;
    private String[] choiceExports;
    private int choiceSelection;
    private int topFirst;

    public TextField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        super(pdfWriter, rectangle, string);
    }

    public PdfAppearance getAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.text == null || this.text.length() == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        BaseFont baseFont = this.getRealFont();
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f2 = this.box.height() - this.borderWidth * 2.0f;
        float f3 = this.borderWidth;
        if (bl) {
            f2 -= this.borderWidth * 2.0f;
            f3 *= 2.0f;
        }
        float f4 = bl ? 2.0f * this.borderWidth : this.borderWidth;
        f4 = Math.max(f4, 1.0f);
        float f5 = Math.min(f3, f4);
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f5, f5, this.box.width() - 2.0f * f5, this.box.height() - 2.0f * f5);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        if (this.textColor == null) {
            pdfAppearance.setGrayFill(0.0f);
        } else {
            pdfAppearance.setColorFill(this.textColor);
        }
        pdfAppearance.beginText();
        if ((this.options & 4) != 0) {
            float f6;
            float f7;
            ArrayList arrayList;
            float f8 = this.fontSize;
            float f9 = this.box.width() - 3.0f * f4;
            ArrayList arrayList2 = arrayList = TextField.getHardBreaks(this.text);
            float f10 = baseFont.getFontDescriptor(8, 1.0f) - baseFont.getFontDescriptor(6, 1.0f);
            if (f8 == 0.0f) {
                f8 = f2 / (float)arrayList.size() / f10;
                if (f8 > 4.0f) {
                    if (f8 > 12.0f) {
                        f8 = 12.0f;
                    }
                    f7 = Math.max((f8 - 4.0f) / 10.0f, 0.2f);
                    while (f8 > 4.0f && !((float)(arrayList2 = TextField.breakLines(arrayList, baseFont, f8, f9)).size() * f8 * f10 <= f2)) {
                        f8 -= f7;
                    }
                }
                if (f8 <= 4.0f) {
                    f8 = 4.0f;
                    arrayList2 = TextField.breakLines(arrayList, baseFont, f8, f9);
                }
            } else {
                arrayList2 = TextField.breakLines(arrayList, baseFont, f8, f9);
            }
            pdfAppearance.setFontAndSize(baseFont, f8);
            pdfAppearance.setLeading(f8 * f10);
            f7 = f4 + f2 - baseFont.getFontDescriptor(8, f8);
            String string = (String)arrayList2.get(0);
            if (this.alignment == 2) {
                f6 = baseFont.getWidthPoint(string, f8);
                pdfAppearance.moveText(this.box.width() - 2.0f * f4 - f6, f7);
            } else if (this.alignment == 1) {
                string = string.trim();
                f6 = baseFont.getWidthPoint(string, f8);
                pdfAppearance.moveText(this.box.width() / 2.0f - f6 / 2.0f, f7);
            } else {
                pdfAppearance.moveText(2.0f * f4, f7);
            }
            pdfAppearance.showText(string);
            int n2 = (int)(f2 / f8 / f10) + 1;
            n2 = Math.min(n2, arrayList2.size());
            for (int i2 = 1; i2 < n2; ++i2) {
                float f11;
                string = (String)arrayList2.get(i2);
                if (this.alignment == 2) {
                    f11 = baseFont.getWidthPoint(string, f8);
                    pdfAppearance.moveText(this.box.width() - 2.0f * f4 - f11 - pdfAppearance.getXTLM(), 0.0f);
                } else if (this.alignment == 1) {
                    string = string.trim();
                    f11 = baseFont.getWidthPoint(string, f8);
                    pdfAppearance.moveText(this.box.width() / 2.0f - f11 / 2.0f - pdfAppearance.getXTLM(), 0.0f);
                }
                pdfAppearance.newlineShowText(string);
            }
        } else {
            float f12;
            float f13;
            float f14 = this.fontSize;
            if (f14 == 0.0f) {
                f13 = f2 / (baseFont.getFontDescriptor(7, 1.0f) - baseFont.getFontDescriptor(6, 1.0f));
                f12 = baseFont.getWidthPoint(this.text, 1.0f);
                f14 = f12 == 0.0f ? f13 : (this.box.width() - 2.0f * f4) / f12;
                if (f14 > f13) {
                    f14 = f13;
                }
                if (f14 < 4.0f) {
                    f14 = 4.0f;
                }
            }
            pdfAppearance.setFontAndSize(baseFont, f14);
            f13 = f5 + (this.box.height() - 2.0f * f5 - baseFont.getFontDescriptor(1, f14)) / 2.0f;
            if (f13 < f5) {
                f13 = f5;
            }
            if (f13 - f5 < -baseFont.getFontDescriptor(3, f14)) {
                f12 = -baseFont.getFontDescriptor(3, f14) + f5;
                float f15 = this.box.height() - f5 - baseFont.getFontDescriptor(1, f14);
                f13 = Math.min(f12, Math.max(f13, f15));
            }
            if ((this.options & 0x100) != 0 && this.maxCharacterLength > 0) {
                int n3 = Math.min(this.maxCharacterLength, this.text.length());
                int n4 = 0;
                if (this.alignment == 2) {
                    n4 = this.maxCharacterLength - n3;
                } else if (this.alignment == 1) {
                    n4 = (this.maxCharacterLength - n3) / 2;
                }
                float f16 = this.box.width() / (float)this.maxCharacterLength;
                float f17 = f16 / 2.0f + (float)n4 * f16;
                for (int i3 = 0; i3 < n3; ++i3) {
                    String string = this.text.substring(i3, i3 + 1);
                    float f18 = baseFont.getWidthPoint(string, f14);
                    pdfAppearance.setTextMatrix(f17 - f18 / 2.0f, f13);
                    pdfAppearance.showText(string);
                    f17 += f16;
                }
            } else {
                if (this.alignment == 2) {
                    f12 = baseFont.getWidthPoint(this.text, f14);
                    pdfAppearance.moveText(this.box.width() - 2.0f * f4 - f12, f13);
                } else if (this.alignment == 1) {
                    f12 = baseFont.getWidthPoint(this.text, f14);
                    pdfAppearance.moveText(this.box.width() / 2.0f - f12 / 2.0f, f13);
                } else {
                    pdfAppearance.moveText(2.0f * f4, f13);
                }
                pdfAppearance.showText(this.text);
            }
        }
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    PdfAppearance getListAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.choices == null || this.choices.length == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        int n2 = this.choiceSelection;
        if (n2 >= this.choices.length) {
            n2 = this.choices.length - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        BaseFont baseFont = this.getRealFont();
        float f2 = this.fontSize;
        if (f2 == 0.0f) {
            f2 = 12.0f;
        }
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f3 = this.box.height() - this.borderWidth * 2.0f;
        if (bl) {
            f3 -= this.borderWidth * 2.0f;
        }
        float f4 = bl ? 2.0f * this.borderWidth : this.borderWidth;
        float f5 = baseFont.getFontDescriptor(8, f2) - baseFont.getFontDescriptor(6, f2);
        int n3 = (int)(f3 / f5) + 1;
        int n4 = 0;
        int n5 = 0;
        n5 = n2 + n3 / 2 + 1;
        n4 = n5 - n3;
        if (n4 < 0) {
            n5 += n4;
            n4 = 0;
        }
        if ((n5 = n4 + n3) > this.choices.length) {
            n5 = this.choices.length;
        }
        this.topFirst = n4;
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f4, f4, this.box.width() - 2.0f * f4, this.box.height() - 2.0f * f4);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        Color color = this.textColor == null ? new GrayColor(0) : this.textColor;
        pdfAppearance.setColorFill(new Color(10, 36, 106));
        pdfAppearance.rectangle(f4, f4 + f3 - (float)(n2 - n4 + 1) * f5, this.box.width() - 2.0f * f4, f5);
        pdfAppearance.fill();
        pdfAppearance.beginText();
        pdfAppearance.setFontAndSize(baseFont, f2);
        pdfAppearance.setLeading(f5);
        pdfAppearance.moveText(f4 * 2.0f, f4 + f3 - baseFont.getFontDescriptor(8, f2) + f5);
        pdfAppearance.setColorFill(color);
        for (int i2 = n4; i2 < n5; ++i2) {
            if (i2 == n2) {
                pdfAppearance.setGrayFill(1.0f);
                pdfAppearance.newlineShowText(this.choices[i2]);
                pdfAppearance.setColorFill(color);
                continue;
            }
            pdfAppearance.newlineShowText(this.choices[i2]);
        }
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    public PdfFormField getTextField() throws IOException, DocumentException {
        if (this.maxCharacterLength <= 0) {
            this.options &= 0xFFFFFEFF;
        }
        if ((this.options & 0x100) != 0) {
            this.options &= 0xFFFFFFFB;
        }
        PdfFormField pdfFormField = PdfFormField.createTextField(this.writer, false, false, this.maxCharacterLength);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        switch (this.alignment) {
            case 1: {
                pdfFormField.setQuadding(1);
                break;
            }
            case 2: {
                pdfFormField.setQuadding(2);
            }
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            pdfFormField.setValueAsString(this.text);
            if (this.defaultText != null) {
                pdfFormField.setDefaultValueAsString(this.defaultText);
            }
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
            if ((this.options & 4) != 0) {
                pdfFormField.setFieldFlags(4096);
            }
            if ((this.options & 8) != 0) {
                pdfFormField.setFieldFlags(0x800000);
            }
            if ((this.options & 0x10) != 0) {
                pdfFormField.setFieldFlags(8192);
            }
            if ((this.options & 0x20) != 0) {
                pdfFormField.setFieldFlags(0x100000);
            }
            if ((this.options & 0x40) != 0) {
                pdfFormField.setFieldFlags(0x400000);
            }
            if ((this.options & 0x100) != 0) {
                pdfFormField.setFieldFlags(0x1000000);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance pdfAppearance = this.getAppearance();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        return pdfFormField;
    }

    public PdfFormField getComboField() throws IOException, DocumentException {
        return this.getChoiceField(false);
    }

    public PdfFormField getListField() throws IOException, DocumentException {
        return this.getChoiceField(true);
    }

    protected PdfFormField getChoiceField(boolean bl) throws IOException, DocumentException {
        PdfAppearance pdfAppearance;
        int n2;
        this.options &= 0xFFFFFEFB;
        String[] stringArray = this.choices;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if ((n2 = this.choiceSelection) >= stringArray.length) {
            n2 = stringArray.length - 1;
        }
        this.text = "";
        if (n2 >= 0) {
            this.text = stringArray[n2];
        }
        if (n2 < 0) {
            n2 = 0;
        }
        PdfFormField pdfFormField = null;
        String[][] stringArray2 = null;
        if (this.choiceExports == null) {
            pdfFormField = bl ? PdfFormField.createList(this.writer, stringArray, n2) : PdfFormField.createCombo(this.writer, (this.options & 0x80) != 0, stringArray, n2);
        } else {
            int n3;
            stringArray2 = new String[stringArray.length][2];
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                String string = stringArray[n3];
                stringArray2[n3][1] = string;
                stringArray2[n3][0] = string;
            }
            n3 = Math.min(stringArray.length, this.choiceExports.length);
            for (int i2 = 0; i2 < n3; ++i2) {
                if (this.choiceExports[i2] == null) continue;
                stringArray2[i2][0] = this.choiceExports[i2];
            }
            pdfFormField = bl ? PdfFormField.createList(this.writer, stringArray2, n2) : PdfFormField.createCombo(this.writer, (this.options & 0x80) != 0, stringArray2, n2);
        }
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if (stringArray.length > 0) {
                if (stringArray2 != null) {
                    pdfFormField.setValueAsString(stringArray2[n2][0]);
                    pdfFormField.setDefaultValueAsString(stringArray2[n2][0]);
                } else {
                    pdfFormField.setValueAsString(this.text);
                    pdfFormField.setDefaultValueAsString(this.text);
                }
            }
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
            if ((this.options & 0x40) != 0) {
                pdfFormField.setFieldFlags(0x400000);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        if (bl) {
            pdfAppearance = this.getListAppearance();
            if (this.topFirst > 0) {
                pdfFormField.put(PdfName.TI, new PdfNumber(this.topFirst));
            }
        } else {
            pdfAppearance = this.getAppearance();
        }
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        return pdfFormField;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String string) {
        this.defaultText = string;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public void setChoices(String[] stringArray) {
        this.choices = stringArray;
    }

    public String[] getChoiceExports() {
        return this.choiceExports;
    }

    public void setChoiceExports(String[] stringArray) {
        this.choiceExports = stringArray;
    }

    public int getChoiceSelection() {
        return this.choiceSelection;
    }

    public void setChoiceSelection(int n2) {
        this.choiceSelection = n2;
    }

    int getTopFirst() {
        return this.topFirst;
    }
}

