/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;

public class PushbuttonField
extends BaseField {
    public static final int LAYOUT_LABEL_ONLY = 1;
    public static final int LAYOUT_ICON_ONLY = 2;
    public static final int LAYOUT_ICON_TOP_LABEL_BOTTOM = 3;
    public static final int LAYOUT_LABEL_TOP_ICON_BOTTOM = 4;
    public static final int LAYOUT_ICON_LEFT_LABEL_RIGHT = 5;
    public static final int LAYOUT_LABEL_LEFT_ICON_RIGHT = 6;
    public static final int LAYOUT_LABEL_OVER_ICON = 7;
    public static final int SCALE_ICON_ALWAYS = 1;
    public static final int SCALE_ICON_NEVER = 2;
    public static final int SCALE_ICON_IS_TOO_BIG = 3;
    public static final int SCALE_ICON_IS_TOO_SMALL = 4;
    private int layout = 1;
    private Image image;
    private PdfTemplate template;
    private int scaleIcon = 1;
    private boolean proportionalIcon = true;
    private float iconVerticalAdjustment = 0.5f;
    private float iconHorizontalAdjustment = 0.5f;
    private boolean iconFitToBounds;
    private PdfTemplate tp;

    public PushbuttonField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        super(pdfWriter, rectangle, string);
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int n2) {
        if (n2 < 1 || n2 > 7) {
            throw new IllegalArgumentException("Layout out of bounds.");
        }
        this.layout = n2;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.template = null;
    }

    public PdfTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(PdfTemplate pdfTemplate) {
        this.template = pdfTemplate;
        this.image = null;
    }

    public int getScaleIcon() {
        return this.scaleIcon;
    }

    public void setScaleIcon(int n2) {
        if (n2 < 1 || n2 > 4) {
            n2 = 1;
        }
        this.scaleIcon = n2;
    }

    public boolean isProportionalIcon() {
        return this.proportionalIcon;
    }

    public void setProportionalIcon(boolean bl) {
        this.proportionalIcon = bl;
    }

    public float getIconVerticalAdjustment() {
        return this.iconVerticalAdjustment;
    }

    public void setIconVerticalAdjustment(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.iconVerticalAdjustment = f2;
    }

    public float getIconHorizontalAdjustment() {
        return this.iconHorizontalAdjustment;
    }

    public void setIconHorizontalAdjustment(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.iconHorizontalAdjustment = f2;
    }

    private float calculateFontSize(float f2, float f3) throws IOException, DocumentException {
        BaseFont baseFont = this.getRealFont();
        float f4 = this.fontSize;
        if (f4 == 0.0f) {
            float f5 = baseFont.getWidthPoint(this.text, 1.0f);
            f4 = f5 == 0.0f ? 12.0f : f2 / f5;
            float f6 = f3 / (1.0f - baseFont.getFontDescriptor(3, 1.0f));
            if ((f4 = Math.min(f4, f6)) < 4.0f) {
                f4 = 4.0f;
            }
        }
        return f4;
    }

    protected PdfAppearance getAppearance() throws IOException, DocumentException {
        float f2;
        float f3;
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        Rectangle rectangle = new Rectangle(pdfAppearance.getBoundingBox());
        if ((this.text == null || this.text.length() == 0) && (this.layout == 1 || this.image == null && this.template == null)) {
            return pdfAppearance;
        }
        if (this.layout == 2 && this.image == null && this.template == null) {
            return pdfAppearance;
        }
        BaseFont baseFont = this.getRealFont();
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f4 = rectangle.height() - this.borderWidth * 2.0f;
        float f5 = this.borderWidth;
        if (bl) {
            f4 -= this.borderWidth * 2.0f;
            f5 *= 2.0f;
        }
        float f6 = bl ? 2.0f * this.borderWidth : this.borderWidth;
        f6 = Math.max(f6, 1.0f);
        float f7 = Math.min(f5, f6);
        this.tp = null;
        Object var9_9 = null;
        float f8 = Float.NaN;
        float f9 = 0.0f;
        float f10 = this.fontSize;
        float f11 = rectangle.width() - 2.0f * f7 - 2.0f;
        float f12 = rectangle.height() - 2.0f * f7;
        float f13 = this.iconFitToBounds ? 0.0f : f7 + 1.0f;
        int n2 = this.layout;
        if (this.image == null && this.template == null) {
            n2 = 1;
        }
        Rectangle rectangle2 = null;
        block18: while (true) {
            switch (n2) {
                case 1: 
                case 7: {
                    if (this.text != null && this.text.length() > 0 && f11 > 0.0f && f12 > 0.0f) {
                        f10 = this.calculateFontSize(f11, f12);
                        f8 = (rectangle.width() - baseFont.getWidthPoint(this.text, f10)) / 2.0f;
                        f9 = (rectangle.height() - baseFont.getFontDescriptor(1, f10)) / 2.0f;
                    }
                }
                case 2: {
                    if (n2 != 7 && n2 != 2) break block18;
                    rectangle2 = new Rectangle(rectangle.left() + f13, rectangle.bottom() + f13, rectangle.right() - f13, rectangle.top() - f13);
                    break block18;
                }
                case 3: {
                    if (this.text == null || this.text.length() == 0 || f11 <= 0.0f || f12 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    f3 = rectangle.height() * 0.35f - f7;
                    f10 = f3 > 0.0f ? this.calculateFontSize(f11, f3) : 4.0f;
                    f8 = (rectangle.width() - baseFont.getWidthPoint(this.text, f10)) / 2.0f;
                    f9 = f7 - baseFont.getFontDescriptor(3, f10);
                    rectangle2 = new Rectangle(rectangle.left() + f13, f9 + f10, rectangle.right() - f13, rectangle.top() - f13);
                    break block18;
                }
                case 4: {
                    if (this.text == null || this.text.length() == 0 || f11 <= 0.0f || f12 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    f3 = rectangle.height() * 0.35f - f7;
                    f10 = f3 > 0.0f ? this.calculateFontSize(f11, f3) : 4.0f;
                    f8 = (rectangle.width() - baseFont.getWidthPoint(this.text, f10)) / 2.0f;
                    f9 = rectangle.height() - f7 - f10;
                    if (f9 < f7) {
                        f9 = f7;
                    }
                    rectangle2 = new Rectangle(rectangle.left() + f13, rectangle.bottom() + f13, rectangle.right() - f13, f9 + baseFont.getFontDescriptor(3, f10));
                    break block18;
                }
                case 6: {
                    if (this.text == null || this.text.length() == 0 || f11 <= 0.0f || f12 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    f2 = rectangle.width() * 0.35f - f7;
                    f10 = f2 > 0.0f ? this.calculateFontSize(f11, f2) : 4.0f;
                    if (baseFont.getWidthPoint(this.text, f10) >= f11) {
                        n2 = 1;
                        f10 = this.fontSize;
                        continue block18;
                    }
                    f8 = f7 + 1.0f;
                    f9 = (rectangle.height() - baseFont.getFontDescriptor(1, f10)) / 2.0f;
                    rectangle2 = new Rectangle(f8 + baseFont.getWidthPoint(this.text, f10), rectangle.bottom() + f13, rectangle.right() - f13, rectangle.top() - f13);
                    break block18;
                }
                case 5: {
                    if (this.text == null || this.text.length() == 0 || f11 <= 0.0f || f12 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    f2 = rectangle.width() * 0.35f - f7;
                    f10 = f2 > 0.0f ? this.calculateFontSize(f11, f2) : 4.0f;
                    if (baseFont.getWidthPoint(this.text, f10) >= f11) {
                        n2 = 1;
                        f10 = this.fontSize;
                        continue block18;
                    }
                    f8 = rectangle.width() - baseFont.getWidthPoint(this.text, f10) - f7 - 1.0f;
                    f9 = (rectangle.height() - baseFont.getFontDescriptor(1, f10)) / 2.0f;
                    rectangle2 = new Rectangle(rectangle.left() + f13, rectangle.bottom() + f13, f8 - 1.0f, rectangle.top() - f13);
                }
            }
            break;
        }
        if (f9 < rectangle.bottom() + f7) {
            f9 = rectangle.bottom() + f7;
        }
        if (rectangle2 != null && (rectangle2.width() <= 0.0f || rectangle2.height() <= 0.0f)) {
            rectangle2 = null;
        }
        if (rectangle2 != null) {
            if (this.image != null) {
                this.tp = new PdfTemplate(this.writer);
                this.tp.setBoundingBox(new Rectangle(this.image));
                this.writer.addDirectTemplateSimple(this.tp, new PdfName("FRM"));
                this.tp.addImage(this.image, this.image.width(), 0.0f, 0.0f, this.image.height(), 0.0f, 0.0f);
            } else if (this.template != null) {
                this.tp = new PdfTemplate(this.writer);
                this.tp.setBoundingBox(new Rectangle(this.template.getWidth(), this.template.getHeight()));
                this.writer.addDirectTemplateSimple(this.tp, new PdfName("FRM"));
                this.tp.addTemplate(this.template, this.template.getBoundingBox().left(), this.template.getBoundingBox().bottom());
            }
        }
        if (this.tp != null) {
            f3 = rectangle2.width() / this.tp.getBoundingBox().width();
            f2 = rectangle2.height() / this.tp.getBoundingBox().height();
            if (this.proportionalIcon) {
                switch (this.scaleIcon) {
                    case 3: {
                        f3 = Math.min(f3, f2);
                        f3 = Math.min(f3, 1.0f);
                        break;
                    }
                    case 4: {
                        f3 = Math.min(f3, f2);
                        f3 = Math.max(f3, 1.0f);
                        break;
                    }
                    case 2: {
                        f3 = 1.0f;
                        break;
                    }
                    default: {
                        f3 = Math.min(f3, f2);
                    }
                }
                f2 = f3;
            } else {
                switch (this.scaleIcon) {
                    case 3: {
                        f3 = Math.min(f3, 1.0f);
                        f2 = Math.min(f2, 1.0f);
                        break;
                    }
                    case 4: {
                        f3 = Math.max(f3, 1.0f);
                        f2 = Math.max(f2, 1.0f);
                        break;
                    }
                    case 2: {
                        f2 = 1.0f;
                        f3 = 1.0f;
                        break;
                    }
                }
            }
            float f14 = rectangle2.left() + (rectangle2.width() - this.tp.getBoundingBox().width() * f3) * this.iconHorizontalAdjustment;
            float f15 = rectangle2.bottom() + (rectangle2.height() - this.tp.getBoundingBox().height() * f2) * this.iconVerticalAdjustment;
            pdfAppearance.saveState();
            pdfAppearance.rectangle(rectangle2.left(), rectangle2.bottom(), rectangle2.width(), rectangle2.height());
            pdfAppearance.clip();
            pdfAppearance.newPath();
            pdfAppearance.addTemplate(this.tp, f3, 0.0f, 0.0f, f2, f14, f15);
            pdfAppearance.restoreState();
        }
        if (!Float.isNaN(f8)) {
            pdfAppearance.saveState();
            pdfAppearance.rectangle(f7, f7, rectangle.width() - 2.0f * f7, rectangle.height() - 2.0f * f7);
            pdfAppearance.clip();
            pdfAppearance.newPath();
            if (this.textColor == null) {
                pdfAppearance.resetGrayFill();
            } else {
                pdfAppearance.setColorFill(this.textColor);
            }
            pdfAppearance.beginText();
            pdfAppearance.setFontAndSize(baseFont, f10);
            pdfAppearance.setTextMatrix(f8, f9);
            pdfAppearance.showText(this.text);
            pdfAppearance.endText();
            pdfAppearance.restoreState();
        }
        return pdfAppearance;
    }

    public PdfFormField getField() throws IOException, DocumentException {
        PdfFormField pdfFormField = PdfFormField.createPushButton(this.writer);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
        }
        if (this.text != null) {
            pdfFormField.setMKNormalCaption(this.text);
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance pdfAppearance = this.getAppearance();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        if (this.tp != null) {
            pdfFormField.setMKNormalIcon(this.tp);
        }
        pdfFormField.setMKTextPosition(this.layout - 1);
        PdfName pdfName = PdfName.A;
        if (this.scaleIcon == 3) {
            pdfName = PdfName.B;
        } else if (this.scaleIcon == 4) {
            pdfName = PdfName.S;
        } else if (this.scaleIcon == 2) {
            pdfName = PdfName.N;
        }
        pdfFormField.setMKIconFit(pdfName, this.proportionalIcon ? PdfName.P : PdfName.A, this.iconHorizontalAdjustment, this.iconVerticalAdjustment, this.iconFitToBounds);
        return pdfFormField;
    }

    public boolean isIconFitToBounds() {
        return this.iconFitToBounds;
    }

    public void setIconFitToBounds(boolean bl) {
        this.iconFitToBounds = bl;
    }
}

