/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;

public class PdfPRow {
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;

    public PdfPRow(PdfPCell[] pdfPCellArray) {
        this.cells = pdfPCellArray;
        this.widths = new float[pdfPCellArray.length];
    }

    public PdfPRow(PdfPRow pdfPRow) {
        this.maxHeight = pdfPRow.maxHeight;
        this.calculated = pdfPRow.calculated;
        this.cells = new PdfPCell[pdfPRow.cells.length];
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (pdfPRow.cells[i2] == null) continue;
            this.cells[i2] = new PdfPCell(pdfPRow.cells[i2]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(pdfPRow.widths, 0, this.widths, 0, this.cells.length);
    }

    public boolean setWidths(float[] fArray) {
        if (fArray.length != this.cells.length) {
            return false;
        }
        System.arraycopy(fArray, 0, this.widths, 0, this.cells.length);
        float f2 = 0.0f;
        this.calculated = false;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            PdfPCell pdfPCell = this.cells[i2];
            pdfPCell.setLeft(f2);
            int n2 = i2 + pdfPCell.getColspan();
            while (i2 < n2) {
                f2 += fArray[i2];
                ++i2;
            }
            --i2;
            pdfPCell.setRight(f2);
            pdfPCell.setTop(0.0f);
        }
        return true;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            float f2;
            PdfPCell pdfPCell = this.cells[i2];
            if (pdfPCell == null) continue;
            Image image = pdfPCell.getImage();
            if (image != null) {
                image.scalePercent(100.0f);
                f2 = (pdfPCell.right() - pdfPCell.getEffectivePaddingRight() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.left()) / image.scaledWidth();
                image.scalePercent(f2 * 100.0f);
                pdfPCell.setBottom(pdfPCell.top() - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom() - image.scaledHeight());
            } else {
                f2 = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.right() - pdfPCell.getEffectivePaddingRight();
                float f3 = pdfPCell.getFixedHeight() > 0.0f ? pdfPCell.top() - pdfPCell.getEffectivePaddingTop() + pdfPCell.getEffectivePaddingBottom() - pdfPCell.getFixedHeight() : -1.0737418E9f;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setSimpleColumn(pdfPCell.left() + pdfPCell.getEffectivePaddingLeft(), f3, f2, pdfPCell.top() - pdfPCell.getEffectivePaddingTop());
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                float f4 = columnText.getYLine();
                if (pdfPCell.isUseDescender()) {
                    f4 += columnText.getDescender();
                }
                pdfPCell.setBottom(f4 - pdfPCell.getEffectivePaddingBottom());
            }
            f2 = pdfPCell.getFixedHeight();
            if (f2 <= 0.0f) {
                f2 = pdfPCell.height();
            }
            if (f2 < pdfPCell.getFixedHeight()) {
                f2 = pdfPCell.getFixedHeight();
            } else if (f2 < pdfPCell.getMinimumHeight()) {
                f2 = pdfPCell.getMinimumHeight();
            }
            if (!(f2 > this.maxHeight)) continue;
            this.maxHeight = f2;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackground(float f2, float f3, PdfPCell pdfPCell, PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[2];
        PdfContentByte pdfContentByte2 = pdfContentByteArray[1];
        float f4 = pdfPCell.left() + f2;
        float f5 = pdfPCell.top() + f3;
        float f6 = pdfPCell.right() + f2;
        float f7 = f5 - this.maxHeight;
        Color color = pdfPCell.backgroundColor();
        if (color != null) {
            pdfContentByte2.setColorFill(color);
            pdfContentByte2.rectangle(f4, f7, f6 - f4, f5 - f7);
            pdfContentByte2.fill();
        } else if (pdfPCell.grayFill() > 0.0f) {
            pdfContentByte2.setGrayFill(pdfPCell.grayFill());
            pdfContentByte2.rectangle(f4, f7, f6 - f4, f5 - f7);
            pdfContentByte2.fill();
        }
        if (pdfPCell.hasBorders()) {
            if (pdfPCell.isUseVariableBorders()) {
                Rectangle rectangle = new Rectangle(pdfPCell.left() + f2, pdfPCell.top() - this.maxHeight + f3, pdfPCell.right() + f2, pdfPCell.top() + f3);
                rectangle.cloneNonPositionParameters(pdfPCell);
                pdfContentByte.rectangle(rectangle);
            } else {
                Color color2;
                if (pdfPCell.borderWidth() != -1.0f) {
                    pdfContentByte.setLineWidth(pdfPCell.borderWidth());
                }
                if ((color2 = pdfPCell.borderColor()) != null) {
                    pdfContentByte.setColorStroke(color2);
                }
                if (pdfPCell.hasBorder(15)) {
                    pdfContentByte.rectangle(f4, f7, f6 - f4, f5 - f7);
                } else {
                    if (pdfPCell.hasBorder(8)) {
                        pdfContentByte.moveTo(f6, f7);
                        pdfContentByte.lineTo(f6, f5);
                    }
                    if (pdfPCell.hasBorder(4)) {
                        pdfContentByte.moveTo(f4, f7);
                        pdfContentByte.lineTo(f4, f5);
                    }
                    if (pdfPCell.hasBorder(2)) {
                        pdfContentByte.moveTo(f4, f7);
                        pdfContentByte.lineTo(f6, f7);
                    }
                    if (pdfPCell.hasBorder(1)) {
                        pdfContentByte.moveTo(f4, f5);
                        pdfContentByte.lineTo(f6, f5);
                    }
                }
                pdfContentByte.stroke();
                if (color2 != null) {
                    pdfContentByte.resetRGBColorStroke();
                }
            }
        }
    }

    public void writeCells(int n2, int n3, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        int n4;
        if (!this.calculated) {
            this.calculateHeights();
        }
        if (n3 < 0) {
            n3 = this.cells.length;
        }
        n3 = Math.min(n3, this.cells.length);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= n3) {
            return;
        }
        for (n4 = n2; n4 >= 0 && this.cells[n4] == null; --n4) {
            f2 -= this.widths[n4 - 1];
        }
        f2 -= this.cells[n4].left();
        for (int i2 = n4; i2 < n3; ++i2) {
            float f4;
            PdfPCell pdfPCell = this.cells[i2];
            if (pdfPCell == null) continue;
            this.writeBorderAndBackground(f2, f3, pdfPCell, pdfContentByteArray);
            PdfPTable pdfPTable = pdfPCell.getTable();
            Image image = pdfPCell.getImage();
            float f5 = 0.0f;
            boolean bl = false;
            switch (pdfPCell.getVerticalAlignment()) {
                case 6: {
                    f5 = pdfPCell.top() + f3 - this.maxHeight + pdfPCell.height() - pdfPCell.getEffectivePaddingTop();
                    break;
                }
                case 5: {
                    f5 = pdfPCell.top() + f3 + (pdfPCell.height() - this.maxHeight) / 2.0f - pdfPCell.getEffectivePaddingTop();
                    break;
                }
                default: {
                    bl = true;
                    f5 = pdfPCell.top() + f3 - pdfPCell.getEffectivePaddingTop();
                }
            }
            if (image != null) {
                boolean bl2 = false;
                if (pdfPCell.height() > this.maxHeight) {
                    image.scalePercent(100.0f);
                    f4 = (this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom()) / image.scaledHeight();
                    image.scalePercent(f4 * 100.0f);
                    bl2 = true;
                }
                f4 = pdfPCell.left() + f2 + pdfPCell.getEffectivePaddingLeft();
                if (bl2) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f4 = f2 + (pdfPCell.left() + pdfPCell.getEffectivePaddingLeft() + pdfPCell.right() - pdfPCell.getEffectivePaddingRight() - image.scaledWidth()) / 2.0f;
                            break;
                        }
                        case 2: {
                            f4 = f2 + pdfPCell.right() - pdfPCell.getEffectivePaddingRight() - image.scaledWidth();
                            break;
                        }
                    }
                    f5 = pdfPCell.top() + f3 - pdfPCell.getEffectivePaddingTop();
                }
                image.setAbsolutePosition(f4, f5 - image.scaledHeight());
                try {
                    pdfContentByteArray[3].addImage(image);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            float f6 = pdfPCell.getFixedHeight();
            f4 = pdfPCell.right() + f2 - pdfPCell.getEffectivePaddingRight();
            float f7 = pdfPCell.left() + f2 + pdfPCell.getEffectivePaddingLeft();
            if (pdfPCell.isNoWrap()) {
                switch (pdfPCell.getHorizontalAlignment()) {
                    case 1: {
                        f4 += 10000.0f;
                        f7 -= 10000.0f;
                        break;
                    }
                    case 2: {
                        f7 -= 20000.0f;
                        break;
                    }
                    default: {
                        f4 += 20000.0f;
                    }
                }
            }
            ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
            columnText.setCanvas(pdfContentByteArray[3]);
            float f8 = f5 - (this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom());
            if (f6 > 0.0f && pdfPCell.height() > this.maxHeight) {
                f5 = pdfPCell.top() + f3 - pdfPCell.getEffectivePaddingTop();
                f8 = pdfPCell.top() + f3 - this.maxHeight + pdfPCell.getEffectivePaddingBottom();
            }
            if (f5 > f8 || columnText.zeroHeightElement()) {
                columnText.setSimpleColumn(f7, f8 - 0.001f, f4, f5);
                try {
                    columnText.go();
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            PdfPCellEvent pdfPCellEvent = pdfPCell.getCellEvent();
            if (pdfPCellEvent == null) continue;
            Rectangle rectangle = new Rectangle(pdfPCell.left() + f2, pdfPCell.top() + f3 - this.maxHeight, pdfPCell.right() + f2, pdfPCell.top() + f3);
            pdfPCellEvent.cellLayout(pdfPCell, rectangle, pdfContentByteArray);
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float f2) {
        this.maxHeight = f2;
    }

    float[] getEventWidth(float f2) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (this.cells[i2] == null) continue;
            ++n2;
        }
        float[] fArray = new float[n2 + 1];
        n2 = 0;
        fArray[n2++] = f2;
        for (int i3 = 0; i3 < this.cells.length; ++i3) {
            if (this.cells[i3] == null) continue;
            fArray[n2] = fArray[n2 - 1] + this.cells[i3].width();
            ++n2;
        }
        return fArray;
    }

    public PdfPRow splitRow(float f2) {
        PdfPCell pdfPCell;
        int n2;
        PdfPCell[] pdfPCellArray = new PdfPCell[this.cells.length];
        float[] fArray = new float[this.cells.length * 2];
        boolean bl = true;
        for (n2 = 0; n2 < this.cells.length; ++n2) {
            pdfPCell = this.cells[n2];
            if (pdfPCell == null) continue;
            fArray[n2 * 2] = pdfPCell.getFixedHeight();
            fArray[n2 * 2 + 1] = pdfPCell.getMinimumHeight();
            Image image = pdfPCell.getImage();
            PdfPCell pdfPCell2 = new PdfPCell(pdfPCell);
            if (image != null) {
                if (f2 > pdfPCell.getEffectivePaddingBottom() + pdfPCell.getEffectivePaddingTop() + 2.0f) {
                    pdfPCell2.setPhrase(null);
                    bl = false;
                }
            } else {
                boolean bl2;
                int n3;
                float f3 = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.right() - pdfPCell.getEffectivePaddingRight();
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                float f4 = pdfPCell.top() - f2 + pdfPCell.getEffectivePaddingBottom();
                float f5 = pdfPCell.top() - pdfPCell.getEffectivePaddingTop();
                float f6 = Math.max(f4, f5);
                columnText.setSimpleColumn(pdfPCell.left() + pdfPCell.getEffectivePaddingLeft(), f4, f3, f5);
                try {
                    n3 = columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                boolean bl3 = bl2 = columnText.getYLine() == f6;
                if (bl2) {
                    columnText = ColumnText.duplicate(pdfPCell.getColumn());
                }
                boolean bl4 = bl = bl && bl2;
                if ((n3 & 1) == 0 || bl2) {
                    pdfPCell2.setColumn(columnText);
                } else {
                    pdfPCell2.setPhrase(null);
                }
            }
            pdfPCellArray[n2] = pdfPCell2;
            pdfPCell.setFixedHeight(f2);
        }
        if (bl) {
            for (n2 = 0; n2 < this.cells.length; ++n2) {
                pdfPCell = this.cells[n2];
                if (pdfPCell == null) continue;
                float f7 = fArray[n2 * 2];
                float f8 = fArray[n2 * 2 + 1];
                if (f7 <= 0.0f) {
                    pdfPCell.setMinimumHeight(f8);
                    continue;
                }
                pdfPCell.setFixedHeight(f7);
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow pdfPRow = new PdfPRow(pdfPCellArray);
        pdfPRow.widths = (float[])this.widths.clone();
        pdfPRow.calculateHeights();
        return pdfPRow;
    }
}

