/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import java.security.MessageDigest;

public class PdfEncryption {
    static final byte[] pad = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    byte[] state = new byte[256];
    int x;
    int y;
    byte[] key;
    int keySize;
    byte[] mkey;
    byte[] extra = new byte[5];
    MessageDigest md5;
    byte[] ownerKey = new byte[32];
    byte[] userKey = new byte[32];
    int permissions;
    byte[] documentID;
    static long seq = System.currentTimeMillis();

    public PdfEncryption() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private byte[] padPassword(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        if (byArray == null) {
            System.arraycopy(pad, 0, byArray2, 0, 32);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, 32));
            if (byArray.length < 32) {
                System.arraycopy(pad, 0, byArray2, byArray.length, 32 - byArray.length);
            }
        }
        return byArray2;
    }

    private byte[] computeOwnerKey(byte[] byArray, byte[] byArray2, boolean bl) {
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = this.md5.digest(byArray2);
        if (bl) {
            int n2;
            byte[] byArray5 = new byte[16];
            for (n2 = 0; n2 < 50; ++n2) {
                byArray4 = this.md5.digest(byArray4);
            }
            System.arraycopy(byArray, 0, byArray3, 0, 32);
            for (n2 = 0; n2 < 20; ++n2) {
                for (int i2 = 0; i2 < byArray5.length; ++i2) {
                    byArray5[i2] = (byte)(byArray4[i2] ^ n2);
                }
                this.prepareRC4Key(byArray5);
                this.encryptRC4(byArray3);
            }
        } else {
            this.prepareRC4Key(byArray4, 0, 5);
            this.encryptRC4(byArray, byArray3);
        }
        return byArray3;
    }

    private void setupGlobalEncryptionKey(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, boolean bl) {
        this.documentID = byArray;
        this.ownerKey = byArray3;
        this.permissions = n2;
        this.mkey = new byte[bl ? 16 : 5];
        this.md5.reset();
        this.md5.update(byArray2);
        this.md5.update(byArray3);
        byte[] byArray4 = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)};
        this.md5.update(byArray4, 0, 4);
        if (byArray != null) {
            this.md5.update(byArray);
        }
        byte[] byArray5 = this.md5.digest();
        if (this.mkey.length == 16) {
            for (int i2 = 0; i2 < 50; ++i2) {
                byArray5 = this.md5.digest(byArray5);
            }
        }
        System.arraycopy(byArray5, 0, this.mkey, 0, this.mkey.length);
    }

    private void setupUserKey() {
        if (this.mkey.length == 16) {
            int n2;
            this.md5.update(pad);
            byte[] byArray = this.md5.digest(this.documentID);
            System.arraycopy(byArray, 0, this.userKey, 0, 16);
            for (n2 = 16; n2 < 32; ++n2) {
                this.userKey[n2] = 0;
            }
            for (n2 = 0; n2 < 20; ++n2) {
                for (int i2 = 0; i2 < this.mkey.length; ++i2) {
                    byArray[i2] = (byte)(this.mkey[i2] ^ n2);
                }
                this.prepareRC4Key(byArray, 0, this.mkey.length);
                this.encryptRC4(this.userKey, 0, 16);
            }
        } else {
            this.prepareRC4Key(this.mkey);
            this.encryptRC4(pad, this.userKey);
        }
    }

    public void setupAllKeys(byte[] byArray, byte[] byArray2, int n2, boolean bl) {
        if (byArray2 == null || byArray2.length == 0) {
            byArray2 = this.md5.digest(PdfEncryption.createDocumentId());
        }
        n2 |= bl ? -3904 : -64;
        byte[] byArray3 = this.padPassword(byArray);
        byte[] byArray4 = this.padPassword(byArray2);
        this.ownerKey = this.computeOwnerKey(byArray3, byArray4, bl);
        this.documentID = PdfEncryption.createDocumentId();
        this.setupByUserPad(this.documentID, byArray3, this.ownerKey, n2 &= 0xFFFFFFFC, bl);
    }

    public static byte[] createDocumentId() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        long l2 = System.currentTimeMillis();
        long l3 = Runtime.getRuntime().freeMemory();
        String string = l2 + "+" + l3 + "+" + seq++;
        return messageDigest.digest(string.getBytes());
    }

    public void setupByUserPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, boolean bl) {
        this.setupByUserPad(byArray, this.padPassword(byArray2), byArray3, n2, bl);
    }

    private void setupByUserPad(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, boolean bl) {
        this.setupGlobalEncryptionKey(byArray, byArray2, byArray3, n2, bl);
        this.setupUserKey();
    }

    public void setupByOwnerPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, boolean bl) {
        this.setupByOwnerPad(byArray, this.padPassword(byArray2), byArray3, byArray4, n2, bl);
    }

    private void setupByOwnerPad(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, boolean bl) {
        byte[] byArray5 = this.computeOwnerKey(byArray4, byArray2, bl);
        this.setupGlobalEncryptionKey(byArray, byArray5, byArray4, n2, bl);
        this.setupUserKey();
    }

    public void prepareKey() {
        this.prepareRC4Key(this.key, 0, this.keySize);
    }

    public void setHashKey(int n2, int n3) {
        this.md5.reset();
        this.extra[0] = (byte)n2;
        this.extra[1] = (byte)(n2 >> 8);
        this.extra[2] = (byte)(n2 >> 16);
        this.extra[3] = (byte)n3;
        this.extra[4] = (byte)(n3 >> 8);
        this.md5.update(this.mkey);
        this.key = this.md5.digest(this.extra);
        this.keySize = this.mkey.length + 5;
        if (this.keySize > 16) {
            this.keySize = 16;
        }
    }

    public static PdfObject createInfoId(byte[] byArray) {
        int n2;
        ByteBuffer byteBuffer = new ByteBuffer(90);
        byteBuffer.append('[').append('<');
        for (n2 = 0; n2 < 16; ++n2) {
            byteBuffer.appendHex(byArray[n2]);
        }
        byteBuffer.append('>').append('<');
        for (n2 = 0; n2 < 16; ++n2) {
            byteBuffer.appendHex(byArray[n2]);
        }
        byteBuffer.append('>').append(']');
        return new PdfLiteral(byteBuffer.toByteArray());
    }

    public PdfDictionary getEncryptionDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.FILTER, PdfName.STANDARD);
        pdfDictionary.put(PdfName.O, new PdfLiteral(PdfContentByte.escapeString(this.ownerKey)));
        pdfDictionary.put(PdfName.U, new PdfLiteral(PdfContentByte.escapeString(this.userKey)));
        pdfDictionary.put(PdfName.P, new PdfNumber(this.permissions));
        if (this.mkey.length > 5) {
            pdfDictionary.put(PdfName.V, new PdfNumber(2));
            pdfDictionary.put(PdfName.R, new PdfNumber(3));
            pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
        } else {
            pdfDictionary.put(PdfName.V, new PdfNumber(1));
            pdfDictionary.put(PdfName.R, new PdfNumber(2));
        }
        return pdfDictionary;
    }

    public void prepareRC4Key(byte[] byArray) {
        this.prepareRC4Key(byArray, 0, byArray.length);
    }

    public void prepareRC4Key(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        for (n4 = 0; n4 < 256; ++n4) {
            this.state[n4] = (byte)n4;
        }
        this.x = 0;
        this.y = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            n6 = byArray[n5 + n2] + this.state[i2] + n6 & 0xFF;
            n4 = this.state[i2];
            this.state[i2] = this.state[n6];
            this.state[n6] = n4;
            n5 = (n5 + 1) % n3;
        }
    }

    public void encryptRC4(byte[] byArray, int n2, int n3, byte[] byArray2) {
        int n4 = n3 + n2;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.state[this.x] + this.y & 0xFF;
            byte by = this.state[this.x];
            this.state[this.x] = this.state[this.y];
            this.state[this.y] = by;
            byArray2[i2] = (byte)(byArray[i2] ^ this.state[this.state[this.x] + this.state[this.y] & 0xFF]);
        }
    }

    public void encryptRC4(byte[] byArray, int n2, int n3) {
        this.encryptRC4(byArray, n2, n3, byArray);
    }

    public void encryptRC4(byte[] byArray, byte[] byArray2) {
        this.encryptRC4(byArray, 0, byArray.length, byArray2);
    }

    public void encryptRC4(byte[] byArray) {
        this.encryptRC4(byArray, 0, byArray.length, byArray);
    }

    public PdfObject getFileID() {
        return PdfEncryption.createInfoId(this.documentID);
    }
}

