/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;

public class DocumentFont
extends BaseFont {
    String fontName;
    PRIndirectReference refFont;
    PdfDictionary font;
    IntHashtable uni2byte = new IntHashtable();
    float Ascender = 800.0f;
    float CapHeight = 700.0f;
    float Descender = -200.0f;
    float ItalicAngle = 0.0f;
    float llx = -50.0f;
    float lly = -200.0f;
    float urx = 100.0f;
    float ury = 900.0f;
    BaseFont cjkMirror;
    String[] cjkNames = new String[]{"HeiseiMin-W3", "HeiseiKakuGo-W5", "STSong-Light", "MHei-Medium", "MSung-Light", "HYGoThic-Medium", "HYSMyeongJo-Medium", "MSungStd-Light", "STSongStd-Light", "HYSMyeongJoStd-Medium", "KozMinPro-Regular"};
    String[] cjkEncs = new String[]{"UniJIS-UCS2-H", "UniJIS-UCS2-H", "UniGB-UCS2-H", "UniCNS-UCS2-H", "UniCNS-UCS2-H", "UniKS-UCS2-H", "UniKS-UCS2-H", "UniCNS-UCS2-H", "UniGB-UCS2-H", "UniKS-UCS2-H", "UniJIS-UCS2-H"};
    static final int[] stdEnc = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 33, 34, 35, 36, 37, 38, 8217, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 8216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 162, 163, 8260, 165, 402, 167, 164, 39, 8220, 171, 8249, 8250, 64257, 64258, 0, 8211, 8224, 8225, 183, 0, 182, 8226, 8218, 8222, 8221, 187, 8230, 8240, 0, 191, 0, 96, 180, 710, 732, 175, 728, 729, 168, 0, 730, 184, 0, 733, 731, 711, 8212, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 0, 170, 0, 0, 0, 0, 321, 216, 338, 186, 0, 0, 0, 0, 0, 230, 0, 0, 0, 305, 0, 0, 322, 248, 339, 223, 0, 0, 0, 0};

    DocumentFont(PRIndirectReference pRIndirectReference) {
        this.encoding = "";
        this.fontSpecific = false;
        this.refFont = pRIndirectReference;
        this.fontType = 4;
        this.font = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
        this.fontName = PdfName.decodeName(((PdfName)PdfReader.getPdfObject(this.font.get(PdfName.BASEFONT))).toString());
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(this.font.get(PdfName.SUBTYPE));
        if (PdfName.TYPE1.equals(pdfName) || PdfName.TRUETYPE.equals(pdfName)) {
            this.doType1TT();
        } else {
            for (int i2 = 0; i2 < this.cjkNames.length; ++i2) {
                if (!this.fontName.startsWith(this.cjkNames[i2])) continue;
                this.fontName = this.cjkNames[i2];
                try {
                    this.cjkMirror = BaseFont.createFont(this.fontName, this.cjkEncs[i2], false);
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                return;
            }
        }
    }

    public void doType1TT() {
        int n2;
        Object object;
        PdfObject pdfObject;
        PdfObject pdfObject2;
        PdfObject pdfObject3 = PdfReader.getPdfObject(this.font.get(PdfName.ENCODING));
        if (pdfObject3 == null) {
            this.fillEncoding(null);
        } else if (pdfObject3.isName()) {
            this.fillEncoding((PdfName)pdfObject3);
        } else {
            pdfObject2 = (PdfDictionary)pdfObject3;
            if ((pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.BASEENCODING))) == null) {
                this.fillEncoding(null);
            } else {
                this.fillEncoding((PdfName)pdfObject3);
            }
            pdfObject = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.DIFFERENCES));
            if (pdfObject != null) {
                object = ((PdfArray)pdfObject).getArrayList();
                n2 = 0;
                for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                    PdfObject pdfObject4 = (PdfObject)((ArrayList)object).get(i2);
                    if (pdfObject4.isNumber()) {
                        n2 = ((PdfNumber)pdfObject4).intValue();
                        continue;
                    }
                    int[] nArray = GlyphList.nameToUnicode(PdfName.decodeName(((PdfName)pdfObject4).toString()));
                    if (nArray != null && nArray.length > 0) {
                        this.uni2byte.put(nArray[0], n2);
                    }
                    ++n2;
                }
            }
        }
        pdfObject2 = (PdfArray)PdfReader.getPdfObject(this.font.get(PdfName.WIDTHS));
        pdfObject = (PdfNumber)PdfReader.getPdfObject(this.font.get(PdfName.FIRSTCHAR));
        object = (PdfNumber)PdfReader.getPdfObject(this.font.get(PdfName.LASTCHAR));
        if (BuiltinFonts14.containsKey(this.fontName)) {
            BaseFont baseFont;
            try {
                baseFont = BaseFont.createFont(this.fontName, "Cp1252", false);
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            int[] nArray = this.uni2byte.toOrderedKeys();
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                int n3 = this.uni2byte.get(nArray[i3]);
                this.widths[n3] = baseFont.getRawWidth(n3, GlyphList.unicodeToName(nArray[i3]));
            }
            this.Ascender = baseFont.getFontDescriptor(1, 1000.0f);
            this.CapHeight = baseFont.getFontDescriptor(2, 1000.0f);
            this.Descender = baseFont.getFontDescriptor(3, 1000.0f);
            this.ItalicAngle = baseFont.getFontDescriptor(4, 1000.0f);
            this.llx = baseFont.getFontDescriptor(5, 1000.0f);
            this.lly = baseFont.getFontDescriptor(6, 1000.0f);
            this.urx = baseFont.getFontDescriptor(7, 1000.0f);
            this.ury = baseFont.getFontDescriptor(8, 1000.0f);
        }
        if (pdfObject != null && object != null && pdfObject2 != null) {
            n2 = ((PdfNumber)pdfObject).intValue();
            ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
            for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                this.widths[n2 + i4] = ((PdfNumber)arrayList.get(i4)).intValue();
            }
        }
        this.fillFontDesc();
    }

    void fillFontDesc() {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.font.get(PdfName.FONTDESCRIPTOR));
        if (pdfDictionary == null) {
            return;
        }
        PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ASCENT));
        if (pdfNumber != null) {
            this.Ascender = pdfNumber.floatValue();
        }
        if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CAPHEIGHT))) != null) {
            this.CapHeight = pdfNumber.floatValue();
        }
        if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DESCENT))) != null) {
            this.Descender = pdfNumber.floatValue();
        }
        if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ITALICANGLE))) != null) {
            this.ItalicAngle = pdfNumber.floatValue();
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONTBBOX))) != null) {
            float f2;
            ArrayList arrayList = pdfArray.getArrayList();
            this.llx = ((PdfNumber)arrayList.get(0)).floatValue();
            this.lly = ((PdfNumber)arrayList.get(1)).floatValue();
            this.urx = ((PdfNumber)arrayList.get(2)).floatValue();
            this.ury = ((PdfNumber)arrayList.get(3)).floatValue();
            if (this.llx > this.urx) {
                f2 = this.llx;
                this.llx = this.urx;
                this.urx = f2;
            }
            if (this.lly > this.ury) {
                f2 = this.lly;
                this.lly = this.ury;
                this.ury = f2;
            }
        }
    }

    void fillEncoding(PdfName pdfName) {
        if (PdfName.MAC_ROMAN_ENCODING.equals(pdfName) || PdfName.WIN_ANSI_ENCODING.equals(pdfName)) {
            byte[] byArray = new byte[256];
            for (int i2 = 0; i2 < 256; ++i2) {
                byArray[i2] = (byte)i2;
            }
            String string = "Cp1252";
            if (PdfName.MAC_ROMAN_ENCODING.equals(pdfName)) {
                string = "MacRoman";
            }
            String string2 = PdfEncodings.convertToString(byArray, string);
            char[] cArray = string2.toCharArray();
            for (int i3 = 0; i3 < 256; ++i3) {
                this.uni2byte.put(cArray[i3], i3);
            }
        } else {
            for (int i4 = 0; i4 < 256; ++i4) {
                this.uni2byte.put(stdEnc[i4], i4);
            }
        }
    }

    public String[][] getFamilyFontName() {
        return null;
    }

    public float getFontDescriptor(int n2, float f2) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getFontDescriptor(n2, f2);
        }
        switch (n2) {
            case 1: 
            case 9: {
                return this.Ascender * f2 / 1000.0f;
            }
            case 2: {
                return this.CapHeight * f2 / 1000.0f;
            }
            case 3: 
            case 10: {
                return this.Descender * f2 / 1000.0f;
            }
            case 4: {
                return this.ItalicAngle;
            }
            case 5: {
                return this.llx * f2 / 1000.0f;
            }
            case 6: {
                return this.lly * f2 / 1000.0f;
            }
            case 7: {
                return this.urx * f2 / 1000.0f;
            }
            case 8: {
                return this.ury * f2 / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (this.urx - this.llx) * f2 / 1000.0f;
            }
        }
        return 0.0f;
    }

    public String[][] getFullFontName() {
        return null;
    }

    public int getKerning(char c2, char c3) {
        return 0;
    }

    public String getPostscriptFontName() {
        return this.fontName;
    }

    int getRawWidth(int n2, String string) {
        return 0;
    }

    public boolean hasKernPairs() {
        return false;
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
    }

    public int getWidth(String string) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getWidth(string);
        }
        return super.getWidth(string);
    }

    byte[] convertToBytes(String string) {
        if (this.cjkMirror != null) {
            return PdfEncodings.convertToBytes(string, "UnicodeBigUnmarked");
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            byArray[i2] = (byte)this.uni2byte.get(cArray[i2]);
        }
        return byArray;
    }

    PdfIndirectReference getIndirectReference() {
        return this.refFont;
    }

    public boolean charExists(char c2) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.charExists(c2);
        }
        return super.charExists(c2);
    }

    public void setPostscriptFontName(String string) {
    }

    public boolean setKerning(char c2, char c3, int n2) {
        return false;
    }

    public int[] getCharBBox(char c2) {
        return null;
    }

    protected int[] getRawCharBBox(int n2, String string) {
        return null;
    }
}

