/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Graphic;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BidiLine;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfLine;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class ColumnText {
    public static final int AR_NOVOWEL = 1;
    public static final int AR_COMPOSEDTASHKEEL = 4;
    public static final int AR_LIG = 8;
    public static final int DIGITS_EN2AN = 32;
    public static final int DIGITS_AN2EN = 64;
    public static final int DIGITS_EN2AN_INIT_LR = 96;
    public static final int DIGITS_EN2AN_INIT_AL = 128;
    public static final int DIGIT_TYPE_AN = 0;
    public static final int DIGIT_TYPE_AN_EXTENDED = 256;
    protected int runDirection = 0;
    public static final float GLOBAL_SPACE_CHAR_RATIO = 0.0f;
    public static final int NO_MORE_TEXT = 1;
    public static final int NO_MORE_COLUMN = 2;
    protected static final int LINE_STATUS_OK = 0;
    protected static final int LINE_STATUS_OFFLIMITS = 1;
    protected static final int LINE_STATUS_NOLINE = 2;
    protected float maxY;
    protected float minY;
    protected float leftX;
    protected float rightX;
    protected int alignment = 0;
    protected ArrayList leftWall;
    protected ArrayList rightWall;
    protected BidiLine bidiLine;
    protected float yLine;
    protected float currentLeading = 16.0f;
    protected float fixedLeading = 16.0f;
    protected float multipliedLeading = 0.0f;
    protected PdfContentByte canvas;
    protected int lineStatus;
    protected float indent = 0.0f;
    protected float followingIndent = 0.0f;
    protected float rightIndent = 0.0f;
    protected float extraParagraphSpace = 0.0f;
    protected float rectangularWidth = -1.0f;
    private float spaceCharRatio = 0.0f;
    private boolean lastWasNewline = true;
    private int linesWritten;
    private float firstLineY;
    private boolean firstLineYDone = false;
    private int arabicOptions = 0;
    protected float descender;
    protected boolean composite = false;
    protected ColumnText compositeColumn;
    protected LinkedList compositeElements;
    protected int listIdx = 0;
    private boolean splittedRow;
    protected Phrase waitPhrase;
    private boolean useAscender = false;

    public ColumnText(PdfContentByte pdfContentByte) {
        this.canvas = pdfContentByte;
    }

    public static ColumnText duplicate(ColumnText columnText) {
        ColumnText columnText2 = new ColumnText(null);
        columnText2.setACopy(columnText);
        return columnText2;
    }

    public ColumnText setACopy(ColumnText columnText) {
        this.setSimpleVars(columnText);
        if (columnText.bidiLine != null) {
            this.bidiLine = new BidiLine(columnText.bidiLine);
        }
        return this;
    }

    protected void setSimpleVars(ColumnText columnText) {
        this.maxY = columnText.maxY;
        this.minY = columnText.minY;
        this.alignment = columnText.alignment;
        this.leftWall = null;
        if (columnText.leftWall != null) {
            this.leftWall = new ArrayList(columnText.leftWall);
        }
        this.rightWall = null;
        if (columnText.rightWall != null) {
            this.rightWall = new ArrayList(columnText.rightWall);
        }
        this.yLine = columnText.yLine;
        this.currentLeading = columnText.currentLeading;
        this.fixedLeading = columnText.fixedLeading;
        this.multipliedLeading = columnText.multipliedLeading;
        this.canvas = columnText.canvas;
        this.lineStatus = columnText.lineStatus;
        this.indent = columnText.indent;
        this.followingIndent = columnText.followingIndent;
        this.rightIndent = columnText.rightIndent;
        this.extraParagraphSpace = columnText.extraParagraphSpace;
        this.rectangularWidth = columnText.rectangularWidth;
        this.spaceCharRatio = columnText.spaceCharRatio;
        this.lastWasNewline = columnText.lastWasNewline;
        this.linesWritten = columnText.linesWritten;
        this.arabicOptions = columnText.arabicOptions;
        this.runDirection = columnText.runDirection;
        this.descender = columnText.descender;
        this.composite = columnText.composite;
        this.splittedRow = columnText.splittedRow;
        if (columnText.composite) {
            this.compositeElements = new LinkedList(columnText.compositeElements);
            if (this.splittedRow) {
                PdfPTable pdfPTable = (PdfPTable)this.compositeElements.getFirst();
                this.compositeElements.set(0, new PdfPTable(pdfPTable));
            }
            if (columnText.compositeColumn != null) {
                this.compositeColumn = ColumnText.duplicate(columnText.compositeColumn);
            }
        }
        this.listIdx = columnText.listIdx;
        this.firstLineY = columnText.firstLineY;
        this.leftX = columnText.leftX;
        this.rightX = columnText.rightX;
        this.firstLineYDone = columnText.firstLineYDone;
        this.waitPhrase = columnText.waitPhrase;
        this.useAscender = columnText.useAscender;
    }

    private void addWaitingPhrase() {
        if (this.bidiLine == null && this.waitPhrase != null) {
            this.bidiLine = new BidiLine();
            Iterator iterator = this.waitPhrase.getChunks().iterator();
            while (iterator.hasNext()) {
                this.bidiLine.addChunk(new PdfChunk((Chunk)iterator.next(), null));
            }
            this.waitPhrase = null;
        }
    }

    public void addText(Phrase phrase) {
        if (phrase == null || this.composite) {
            return;
        }
        this.addWaitingPhrase();
        if (this.bidiLine == null) {
            this.waitPhrase = phrase;
            return;
        }
        Iterator iterator = phrase.getChunks().iterator();
        while (iterator.hasNext()) {
            this.bidiLine.addChunk(new PdfChunk((Chunk)iterator.next(), null));
        }
    }

    public void setText(Phrase phrase) {
        this.bidiLine = null;
        this.composite = false;
        this.compositeColumn = null;
        this.compositeElements = null;
        this.listIdx = 0;
        this.splittedRow = false;
        this.waitPhrase = phrase;
    }

    public void addText(Chunk chunk) {
        if (chunk == null || this.composite) {
            return;
        }
        this.addText(new Phrase(chunk));
    }

    public void addElement(Element element) {
        if (element == null) {
            return;
        }
        if (element instanceof Image) {
            Image image = (Image)element;
            PdfPTable pdfPTable = new PdfPTable(1);
            float f2 = image.getWidthPercentage();
            if (f2 == 0.0f) {
                pdfPTable.setTotalWidth(image.scaledWidth());
                pdfPTable.setLockedWidth(true);
            } else {
                pdfPTable.setWidthPercentage(f2);
            }
            pdfPTable.setSpacingAfter(image.spacingAfter());
            pdfPTable.setSpacingBefore(image.spacingBefore());
            PdfPCell pdfPCell = new PdfPCell(image, true);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setBorder(image.border());
            pdfPCell.setBorderColor(image.borderColor());
            pdfPCell.setBorderWidth(image.borderWidth());
            pdfPCell.setBackgroundColor(image.backgroundColor());
            pdfPCell.setGrayFill(image.grayFill());
            pdfPTable.addCell(pdfPCell);
            element = pdfPTable;
        }
        if (element.type() == 10) {
            element = new Paragraph((Chunk)element);
        }
        if (element.type() == 11) {
            element = new Paragraph((Phrase)element);
        }
        if (element.type() != 12 && element.type() != 14 && element.type() != 23 && element.type() != 39) {
            throw new IllegalArgumentException("Element not allowed.");
        }
        if (!this.composite) {
            this.composite = true;
            this.compositeElements = new LinkedList();
            this.bidiLine = null;
            this.waitPhrase = null;
        }
        this.compositeElements.add(element);
    }

    protected ArrayList convertColumn(float[] fArray) {
        if (fArray.length < 4) {
            throw new RuntimeException("No valid column line found.");
        }
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        for (int i2 = 0; i2 < fArray.length - 2; i2 += 2) {
            float f2 = fArray[i2];
            float f3 = fArray[i2 + 1];
            float f4 = fArray[i2 + 2];
            float f5 = fArray[i2 + 3];
            if (f3 == f5) continue;
            float f6 = (f2 - f4) / (f3 - f5);
            float f7 = f2 - f6 * f3;
            float[] fArray2 = new float[]{Math.min(f3, f5), Math.max(f3, f5), f6, f7};
            arrayList.add(fArray2);
            this.maxY = Math.max(this.maxY, fArray2[1]);
            this.minY = Math.min(this.minY, fArray2[0]);
        }
        if (arrayList.size() == 0) {
            throw new RuntimeException("No valid column line found.");
        }
        return arrayList;
    }

    protected float findLimitsPoint(ArrayList arrayList) {
        this.lineStatus = 0;
        if (this.yLine < this.minY || this.yLine > this.maxY) {
            this.lineStatus = 1;
            return 0.0f;
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            float[] fArray = (float[])arrayList.get(i2);
            if (this.yLine < fArray[0] || this.yLine > fArray[1]) continue;
            return fArray[2] * this.yLine + fArray[3];
        }
        this.lineStatus = 2;
        return 0.0f;
    }

    protected float[] findLimitsOneLine() {
        float f2 = this.findLimitsPoint(this.leftWall);
        if (this.lineStatus == 1 || this.lineStatus == 2) {
            return null;
        }
        float f3 = this.findLimitsPoint(this.rightWall);
        if (this.lineStatus == 2) {
            return null;
        }
        return new float[]{f2, f3};
    }

    protected float[] findLimitsTwoLines() {
        float[] fArray;
        float[] fArray2;
        boolean bl = false;
        while (true) {
            if (bl && this.currentLeading == 0.0f) {
                return null;
            }
            bl = true;
            fArray2 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            this.yLine -= this.currentLeading;
            if (this.lineStatus == 2) continue;
            fArray = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            if (this.lineStatus == 2) {
                this.yLine -= this.currentLeading;
                continue;
            }
            if (!(fArray2[0] >= fArray[1]) && !(fArray[0] >= fArray2[1])) break;
        }
        return new float[]{fArray2[0], fArray2[1], fArray[0], fArray[1]};
    }

    public void setColumns(float[] fArray, float[] fArray2) {
        this.maxY = -1.0E21f;
        this.minY = 1.0E21f;
        this.rightWall = this.convertColumn(fArray2);
        this.leftWall = this.convertColumn(fArray);
        this.rectangularWidth = -1.0f;
    }

    public void setSimpleColumn(Phrase phrase, float f2, float f3, float f4, float f5, float f6, int n2) {
        this.addText(phrase);
        this.setSimpleColumn(f2, f3, f4, f5, f6, n2);
    }

    public void setSimpleColumn(float f2, float f3, float f4, float f5, float f6, int n2) {
        this.setLeading(f6);
        this.alignment = n2;
        this.setSimpleColumn(f2, f3, f4, f5);
    }

    public void setSimpleColumn(float f2, float f3, float f4, float f5) {
        this.leftX = Math.min(f2, f4);
        this.maxY = Math.max(f3, f5);
        this.minY = Math.min(f3, f5);
        this.rightX = Math.max(f2, f4);
        this.yLine = this.maxY;
        this.rectangularWidth = this.rightX - this.leftX;
    }

    public void setLeading(float f2) {
        this.fixedLeading = f2;
        this.multipliedLeading = 0.0f;
    }

    public void setLeading(float f2, float f3) {
        this.fixedLeading = f2;
        this.multipliedLeading = f3;
    }

    public float getLeading() {
        return this.fixedLeading;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public void setYLine(float f2) {
        this.yLine = f2;
    }

    public float getYLine() {
        return this.yLine;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setIndent(float f2) {
        this.indent = f2;
        this.lastWasNewline = true;
    }

    public float getIndent() {
        return this.indent;
    }

    public void setFollowingIndent(float f2) {
        this.followingIndent = f2;
        this.lastWasNewline = true;
    }

    public float getFollowingIndent() {
        return this.followingIndent;
    }

    public void setRightIndent(float f2) {
        this.rightIndent = f2;
        this.lastWasNewline = true;
    }

    public float getRightIndent() {
        return this.rightIndent;
    }

    public int go() throws DocumentException {
        return this.go(false);
    }

    public int go(boolean bl) throws DocumentException {
        int n2;
        PdfContentByte pdfContentByte;
        boolean bl2;
        block28: {
            if (this.composite) {
                return this.goComposite(bl);
            }
            this.addWaitingPhrase();
            if (this.bidiLine == null) {
                return 1;
            }
            this.descender = 0.0f;
            this.linesWritten = 0;
            bl2 = false;
            float f2 = this.spaceCharRatio;
            Object[] objectArray = new Object[2];
            PdfFont pdfFont = null;
            Float f3 = new Float(0.0f);
            objectArray[1] = f3;
            PdfDocument pdfDocument = null;
            PdfContentByte pdfContentByte2 = null;
            pdfContentByte = null;
            this.firstLineY = Float.NaN;
            int n3 = 1;
            if (this.runDirection != 0) {
                n3 = this.runDirection;
            }
            if (this.canvas != null) {
                pdfContentByte2 = this.canvas;
                pdfDocument = this.canvas.getPdfDocument();
                pdfContentByte = this.canvas.getDuplicate();
            } else if (!bl) {
                throw new NullPointerException("ColumnText.go with simulate==false and text==null.");
            }
            if (!bl) {
                if (f2 == 0.0f) {
                    f2 = pdfContentByte.getPdfWriter().getSpaceCharRatio();
                } else if (f2 < 0.001f) {
                    f2 = 0.001f;
                }
            }
            float f4 = 0.0f;
            n2 = 0;
            if (this.rectangularWidth > 0.0f) {
                while (true) {
                    float f5 = f4 = this.lastWasNewline ? this.indent : this.followingIndent;
                    if (this.rectangularWidth <= f4 + this.rightIndent) {
                        n2 = 2;
                        if (this.bidiLine.isEmpty()) {
                            n2 |= 1;
                        }
                        break block28;
                    }
                    if (this.bidiLine.isEmpty()) {
                        n2 = 1;
                        break block28;
                    }
                    PdfLine pdfLine = this.bidiLine.processLine(this.rectangularWidth - f4 - this.rightIndent, this.alignment, n3, this.arabicOptions);
                    if (pdfLine == null) {
                        n2 = 1;
                        break block28;
                    }
                    float f6 = pdfLine.getMaxSizeSimple();
                    this.currentLeading = this.isUseAscender() && Float.isNaN(this.firstLineY) ? pdfLine.getAscender() : this.fixedLeading + f6 * this.multipliedLeading;
                    if (this.yLine > this.maxY || this.yLine - this.currentLeading < this.minY) {
                        n2 = 2;
                        this.bidiLine.restore();
                        break block28;
                    }
                    this.yLine -= this.currentLeading;
                    if (!bl && !bl2) {
                        pdfContentByte.beginText();
                        bl2 = true;
                    }
                    if (Float.isNaN(this.firstLineY)) {
                        this.firstLineY = this.yLine;
                    }
                    if (!bl) {
                        objectArray[0] = pdfFont;
                        pdfContentByte.setTextMatrix(this.leftX + (pdfLine.isRTL() ? this.rightIndent : f4) + pdfLine.indentLeft(), this.yLine);
                        pdfDocument.writeLineToContent(pdfLine, pdfContentByte, pdfContentByte2, objectArray, f2);
                        pdfFont = (PdfFont)objectArray[0];
                    }
                    this.lastWasNewline = pdfLine.isNewlineSplit();
                    this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                    ++this.linesWritten;
                    this.descender = pdfLine.getDescender();
                }
            }
            this.currentLeading = this.fixedLeading;
            while (true) {
                PdfLine pdfLine;
                f4 = this.lastWasNewline ? this.indent : this.followingIndent;
                float f7 = this.yLine;
                float[] fArray = this.findLimitsTwoLines();
                if (fArray == null) {
                    n2 = 2;
                    if (this.bidiLine.isEmpty()) {
                        n2 |= 1;
                    }
                    this.yLine = f7;
                    break;
                }
                if (this.bidiLine.isEmpty()) {
                    n2 = 1;
                    this.yLine = f7;
                    break;
                }
                float f8 = Math.max(fArray[0], fArray[2]);
                float f9 = Math.min(fArray[1], fArray[3]);
                if (f9 - f8 <= f4 + this.rightIndent) continue;
                if (!bl && !bl2) {
                    pdfContentByte.beginText();
                    bl2 = true;
                }
                if ((pdfLine = this.bidiLine.processLine(f9 - f8 - f4 - this.rightIndent, this.alignment, n3, this.arabicOptions)) == null) {
                    n2 = 1;
                    this.yLine = f7;
                    break;
                }
                if (!bl) {
                    objectArray[0] = pdfFont;
                    pdfContentByte.setTextMatrix(f8 + (pdfLine.isRTL() ? this.rightIndent : f4) + pdfLine.indentLeft(), this.yLine);
                    pdfDocument.writeLineToContent(pdfLine, pdfContentByte, pdfContentByte2, objectArray, f2);
                    pdfFont = (PdfFont)objectArray[0];
                }
                this.lastWasNewline = pdfLine.isNewlineSplit();
                this.yLine -= pdfLine.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                ++this.linesWritten;
                this.descender = pdfLine.getDescender();
            }
        }
        if (bl2) {
            pdfContentByte.endText();
            this.canvas.add(pdfContentByte);
        }
        return n2;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float f2) {
        this.extraParagraphSpace = f2;
    }

    public void clearChunks() {
        if (this.bidiLine != null) {
            this.bidiLine.clearChunks();
        }
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float f2) {
        this.spaceCharRatio = f2;
    }

    public void setRunDirection(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new RuntimeException("Invalid run direction: " + n2);
        }
        this.runDirection = n2;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public int getLinesWritten() {
        return this.linesWritten;
    }

    public int getArabicOptions() {
        return this.arabicOptions;
    }

    public void setArabicOptions(int n2) {
        this.arabicOptions = n2;
    }

    public float getDescender() {
        return this.descender;
    }

    public static float getWidth(Phrase phrase, int n2, int n3) {
        ColumnText columnText = new ColumnText(null);
        columnText.addText(phrase);
        columnText.addWaitingPhrase();
        PdfLine pdfLine = columnText.bidiLine.processLine(20000.0f, 0, n2, n3);
        if (pdfLine == null) {
            return 0.0f;
        }
        return 20000.0f - pdfLine.widthLeft();
    }

    public static float getWidth(Phrase phrase) {
        return ColumnText.getWidth(phrase, 1, 0);
    }

    public static void showTextAligned(PdfContentByte pdfContentByte, int n2, Phrase phrase, float f2, float f3, float f4, int n3, int n4) {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            n2 = 0;
        }
        pdfContentByte.saveState();
        ColumnText columnText = new ColumnText(pdfContentByte);
        if (f4 == 0.0f) {
            if (n2 == 0) {
                columnText.setSimpleColumn(phrase, f2, f3 - 1.0f, 20000.0f + f2, f3 + 2.0f, 2.0f, n2);
            } else if (n2 == 2) {
                columnText.setSimpleColumn(phrase, f2 - 20000.0f, f3 - 1.0f, f2, f3 + 2.0f, 2.0f, n2);
            } else {
                columnText.setSimpleColumn(phrase, f2 - 20000.0f, f3 - 1.0f, f2 + 20000.0f, f3 + 2.0f, 2.0f, n2);
            }
        } else {
            double d2 = (double)f4 * Math.PI / 180.0;
            float f5 = (float)Math.cos(d2);
            float f6 = (float)Math.sin(d2);
            pdfContentByte.concatCTM(f5, f6, -f6, f5, f2, f3);
            if (n2 == 0) {
                columnText.setSimpleColumn(phrase, 0.0f, -1.0f, 20000.0f, 2.0f, 2.0f, n2);
            } else if (n2 == 2) {
                columnText.setSimpleColumn(phrase, -20000.0f, -1.0f, 0.0f, 2.0f, 2.0f, n2);
            } else {
                columnText.setSimpleColumn(phrase, -20000.0f, -1.0f, 20000.0f, 2.0f, 2.0f, n2);
            }
        }
        if (n3 == 3) {
            if (n2 == 0) {
                n2 = 2;
            } else if (n2 == 2) {
                n2 = 0;
            }
        }
        columnText.setAlignment(n2);
        columnText.setArabicOptions(n4);
        columnText.setRunDirection(n3);
        try {
            columnText.go();
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
        pdfContentByte.restoreState();
    }

    public static void showTextAligned(PdfContentByte pdfContentByte, int n2, Phrase phrase, float f2, float f3, float f4) {
        ColumnText.showTextAligned(pdfContentByte, n2, phrase, f2, f3, f4, 1, 0);
    }

    protected int goComposite(boolean bl) throws DocumentException {
        if (this.rectangularWidth <= 0.0f) {
            throw new DocumentException("Irregular columns are not supported in composite mode.");
        }
        this.linesWritten = 0;
        this.descender = 0.0f;
        boolean bl2 = true;
        block4: while (!this.compositeElements.isEmpty()) {
            int n2;
            int n3;
            int n4;
            float f2;
            Element element;
            Element element2 = (Element)this.compositeElements.getFirst();
            if (element2.type() == 12) {
                element = (Paragraph)element2;
                int n5 = 0;
                for (int i2 = 0; i2 < 2; ++i2) {
                    f2 = this.yLine;
                    boolean bl3 = false;
                    if (this.compositeColumn == null) {
                        this.compositeColumn = new ColumnText(this.canvas);
                        this.compositeColumn.setUseAscender(bl2 ? this.useAscender : false);
                        this.compositeColumn.setAlignment(((Paragraph)element).alignment());
                        this.compositeColumn.setIndent(((Paragraph)element).indentationLeft() + ((Paragraph)element).getFirstLineIndent());
                        this.compositeColumn.setExtraParagraphSpace(((Paragraph)element).getExtraParagraphSpace());
                        this.compositeColumn.setFollowingIndent(((Paragraph)element).indentationLeft());
                        this.compositeColumn.setRightIndent(((Paragraph)element).indentationRight());
                        this.compositeColumn.setLeading(((Phrase)element).leading(), ((Paragraph)element).getMultipliedLeading());
                        this.compositeColumn.setRunDirection(this.runDirection);
                        this.compositeColumn.setArabicOptions(this.arabicOptions);
                        this.compositeColumn.setSpaceCharRatio(this.spaceCharRatio);
                        this.compositeColumn.addText((Phrase)element);
                        if (!bl2) {
                            this.yLine -= ((Paragraph)element).spacingBefore();
                        }
                        bl3 = true;
                    }
                    this.compositeColumn.leftX = this.leftX;
                    this.compositeColumn.rightX = this.rightX;
                    this.compositeColumn.yLine = this.yLine;
                    this.compositeColumn.rectangularWidth = this.rectangularWidth;
                    this.compositeColumn.minY = this.minY;
                    this.compositeColumn.maxY = this.maxY;
                    n4 = ((Paragraph)element).getKeepTogether() && bl3 && !bl2 ? 1 : 0;
                    n5 = this.compositeColumn.go(bl || n4 != 0 && i2 == 0);
                    if ((n5 & 1) == 0 && n4 != 0) {
                        this.compositeColumn = null;
                        this.yLine = f2;
                        return 2;
                    }
                    if (bl || n4 == 0) break;
                    if (i2 != 0) continue;
                    this.compositeColumn = null;
                    this.yLine = f2;
                }
                bl2 = false;
                this.yLine = this.compositeColumn.yLine;
                this.linesWritten += this.compositeColumn.linesWritten;
                this.descender = this.compositeColumn.descender;
                if (n5 & true) {
                    this.compositeColumn = null;
                    this.compositeElements.removeFirst();
                    this.yLine -= ((Paragraph)element).spacingAfter();
                }
                if ((n5 & 2) == 0) continue;
                return 2;
            }
            if (element2.type() == 14) {
                element = (List)element2;
                ArrayList arrayList = ((List)element).getItems();
                ListItem listItem = null;
                f2 = ((List)element).indentationLeft();
                int n6 = 0;
                Stack<Object[]> stack = new Stack<Object[]>();
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    Object e2 = arrayList.get(n3);
                    if (e2 instanceof ListItem) {
                        if (n6 == this.listIdx) {
                            listItem = (ListItem)e2;
                            break;
                        }
                        ++n6;
                    } else if (e2 instanceof List) {
                        stack.push(new Object[]{element, new Integer(n3), new Float(f2)});
                        element = (List)e2;
                        arrayList = ((List)element).getItems();
                        f2 += ((List)element).indentationLeft();
                        n3 = -1;
                        continue;
                    }
                    if (n3 != arrayList.size() - 1 || stack.isEmpty()) continue;
                    Object[] objectArray = (Object[])stack.pop();
                    element = (List)objectArray[0];
                    arrayList = ((List)element).getItems();
                    n3 = (Integer)objectArray[1];
                    f2 = ((Float)objectArray[2]).floatValue();
                }
                n3 = 0;
                for (int i3 = 0; i3 < 2; ++i3) {
                    float f3 = this.yLine;
                    boolean bl4 = false;
                    if (this.compositeColumn == null) {
                        if (listItem == null) {
                            this.listIdx = 0;
                            this.compositeElements.removeFirst();
                            continue block4;
                        }
                        this.compositeColumn = new ColumnText(this.canvas);
                        this.compositeColumn.setUseAscender(bl2 ? this.useAscender : false);
                        this.compositeColumn.setAlignment(listItem.alignment());
                        this.compositeColumn.setIndent(listItem.indentationLeft() + f2 + listItem.getFirstLineIndent());
                        this.compositeColumn.setExtraParagraphSpace(listItem.getExtraParagraphSpace());
                        this.compositeColumn.setFollowingIndent(this.compositeColumn.getIndent());
                        this.compositeColumn.setRightIndent(listItem.indentationRight() + ((List)element).indentationRight());
                        this.compositeColumn.setLeading(listItem.leading(), listItem.getMultipliedLeading());
                        this.compositeColumn.setRunDirection(this.runDirection);
                        this.compositeColumn.setArabicOptions(this.arabicOptions);
                        this.compositeColumn.setSpaceCharRatio(this.spaceCharRatio);
                        this.compositeColumn.addText(listItem);
                        if (!bl2) {
                            this.yLine -= listItem.spacingBefore();
                        }
                        bl4 = true;
                    }
                    this.compositeColumn.leftX = this.leftX;
                    this.compositeColumn.rightX = this.rightX;
                    this.compositeColumn.yLine = this.yLine;
                    this.compositeColumn.rectangularWidth = this.rectangularWidth;
                    this.compositeColumn.minY = this.minY;
                    this.compositeColumn.maxY = this.maxY;
                    n2 = listItem.getKeepTogether() && bl4 && !bl2 ? 1 : 0;
                    n3 = this.compositeColumn.go(bl || n2 != 0 && i3 == 0);
                    if ((n3 & 1) == 0 && n2 != 0) {
                        this.compositeColumn = null;
                        this.yLine = f3;
                        return 2;
                    }
                    if (bl || n2 == 0) break;
                    if (i3 != 0) continue;
                    this.compositeColumn = null;
                    this.yLine = f3;
                }
                bl2 = false;
                this.yLine = this.compositeColumn.yLine;
                this.linesWritten += this.compositeColumn.linesWritten;
                this.descender = this.compositeColumn.descender;
                if (!Float.isNaN(this.compositeColumn.firstLineY) && !this.compositeColumn.firstLineYDone) {
                    if (!bl) {
                        ColumnText.showTextAligned(this.canvas, 0, new Phrase(listItem.listSymbol()), this.compositeColumn.leftX + f2, this.compositeColumn.firstLineY, 0.0f);
                    }
                    this.compositeColumn.firstLineYDone = true;
                }
                if ((n3 & 1) != 0) {
                    this.compositeColumn = null;
                    ++this.listIdx;
                    this.yLine -= listItem.spacingAfter();
                }
                if ((n3 & 2) == 0) continue;
                return 2;
            }
            if (element2.type() == 23) {
                float f4;
                float f5;
                if (this.yLine < this.minY || this.yLine > this.maxY) {
                    return 2;
                }
                element = (PdfPTable)element2;
                if (((PdfPTable)element).size() <= ((PdfPTable)element).getHeaderRows()) {
                    this.compositeElements.removeFirst();
                    continue;
                }
                float f6 = this.yLine;
                float f7 = this.yLine;
                if (!bl2 && this.listIdx == 0) {
                    f7 = f6 -= ((PdfPTable)element).spacingBefore();
                }
                this.currentLeading = 0.0f;
                if (f6 < this.minY || f6 > this.maxY) {
                    return 2;
                }
                f2 = this.leftX;
                if (((PdfPTable)element).isLockedWidth()) {
                    f5 = ((PdfPTable)element).getTotalWidth();
                } else {
                    f5 = this.rectangularWidth * ((PdfPTable)element).getWidthPercentage() / 100.0f;
                    ((PdfPTable)element).setTotalWidth(f5);
                }
                int n7 = n3 = !bl2 && ((PdfPTable)element).isSkipFirstHeader() && this.listIdx <= ((PdfPTable)element).getHeaderRows() ? 1 : 0;
                if (n3 == 0 && ((f6 -= ((PdfPTable)element).getHeaderHeight()) < this.minY || f6 > this.maxY)) {
                    if (bl2) {
                        this.compositeElements.removeFirst();
                        continue;
                    }
                    return 2;
                }
                if (this.listIdx < ((PdfPTable)element).getHeaderRows()) {
                    this.listIdx = ((PdfPTable)element).getHeaderRows();
                }
                for (n4 = this.listIdx; n4 < ((PdfPTable)element).size() && !(f6 - (f4 = ((PdfPTable)element).getRowHeight(n4)) < this.minY); ++n4) {
                    f6 -= f4;
                }
                if (n4 < ((PdfPTable)element).size()) {
                    if (((PdfPTable)element).isSplitRows() && (!((PdfPTable)element).isSplitLate() || n4 == this.listIdx && bl2)) {
                        if (!this.splittedRow) {
                            this.splittedRow = true;
                            element = new PdfPTable((PdfPTable)element);
                            this.compositeElements.set(0, element);
                            ArrayList arrayList = ((PdfPTable)element).getRows();
                            for (int i4 = ((PdfPTable)element).getHeaderRows(); i4 < this.listIdx; ++i4) {
                                arrayList.set(i4, null);
                            }
                        }
                        float f8 = f6 - this.minY;
                        PdfPRow pdfPRow = ((PdfPTable)element).getRow(n4).splitRow(f8);
                        if (pdfPRow == null) {
                            if (n4 == this.listIdx) {
                                return 2;
                            }
                        } else {
                            f6 = this.minY;
                            ((PdfPTable)element).getRows().add(++n4, pdfPRow);
                        }
                    } else {
                        if (!((PdfPTable)element).isSplitRows() && n4 == this.listIdx && bl2) {
                            this.compositeElements.removeFirst();
                            this.splittedRow = false;
                            continue;
                        }
                        if (!(n4 != this.listIdx || bl2 || ((PdfPTable)element).isSplitRows() && !((PdfPTable)element).isSplitLate())) {
                            return 2;
                        }
                    }
                }
                bl2 = false;
                if (!bl) {
                    PdfPRow pdfPRow;
                    switch (((PdfPTable)element).getHorizontalAlignment()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            f2 += this.rectangularWidth - f5;
                            break;
                        }
                        default: {
                            f2 += (this.rectangularWidth - f5) / 2.0f;
                        }
                    }
                    PdfPTable pdfPTable = PdfPTable.shallowCopy((PdfPTable)element);
                    ArrayList arrayList = ((PdfPTable)element).getRows();
                    ArrayList arrayList2 = pdfPTable.getRows();
                    if (n3 == 0) {
                        for (n2 = 0; n2 < ((PdfPTable)element).getHeaderRows(); ++n2) {
                            arrayList2.add(arrayList.get(n2));
                        }
                    } else {
                        pdfPTable.setHeaderRows(0);
                    }
                    for (n2 = this.listIdx; n2 < n4; ++n2) {
                        arrayList2.add(arrayList.get(n2));
                    }
                    float f9 = 0.0f;
                    if (((PdfPTable)element).isExtendLastRow()) {
                        pdfPRow = (PdfPRow)arrayList2.get(arrayList2.size() - 1);
                        f9 = pdfPRow.getMaxHeights();
                        pdfPRow.setMaxHeights(f6 - this.minY + f9);
                        f6 = this.minY;
                    }
                    pdfPTable.writeSelectedRows(0, -1, f2, f7, this.canvas);
                    if (((PdfPTable)element).isExtendLastRow()) {
                        pdfPRow = (PdfPRow)arrayList2.get(arrayList2.size() - 1);
                        pdfPRow.setMaxHeights(f9);
                    }
                } else if (((PdfPTable)element).isExtendLastRow() && this.minY > -1.0737418E9f) {
                    f6 = this.minY;
                }
                this.yLine = f6;
                if (n4 >= ((PdfPTable)element).size()) {
                    this.yLine -= ((PdfPTable)element).spacingAfter();
                    this.compositeElements.removeFirst();
                    this.splittedRow = false;
                    this.listIdx = 0;
                    continue;
                }
                if (this.splittedRow) {
                    ArrayList arrayList = ((PdfPTable)element).getRows();
                    for (int i5 = this.listIdx; i5 < n4; ++i5) {
                        arrayList.set(i5, null);
                    }
                }
                this.listIdx = n4;
                return 2;
            }
            if (element2.type() == 39) {
                if (!bl) {
                    element = (Graphic)element2;
                    ByteBuffer byteBuffer = ((PdfContentByte)((Object)element)).getInternalBuffer();
                    ByteBuffer byteBuffer2 = null;
                    if (byteBuffer.size() > 0) {
                        byteBuffer2 = new ByteBuffer();
                        byteBuffer2.append(byteBuffer);
                        byteBuffer.reset();
                    }
                    ((Graphic)element).processAttributes(this.leftX, this.minY, this.rightX, this.maxY, this.yLine);
                    this.canvas.add((PdfContentByte)((Object)element));
                    byteBuffer.reset();
                    if (byteBuffer2 != null) {
                        byteBuffer.append(byteBuffer2);
                    }
                }
                this.compositeElements.removeFirst();
                continue;
            }
            this.compositeElements.removeFirst();
        }
        return 1;
    }

    public PdfContentByte getCanvas() {
        return this.canvas;
    }

    public void setCanvas(PdfContentByte pdfContentByte) {
        this.canvas = pdfContentByte;
        if (this.compositeColumn != null) {
            this.compositeColumn.setCanvas(pdfContentByte);
        }
    }

    public boolean zeroHeightElement() {
        return this.composite && this.compositeElements.size() > 0 && ((Element)this.compositeElements.getFirst()).type() == 39;
    }

    public boolean isUseAscender() {
        return this.useAscender;
    }

    public void setUseAscender(boolean bl) {
        this.useAscender = bl;
    }
}

