/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.CFFFont;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class CFFFontSubset
extends CFFFont {
    static final String[] SubrsFunctions = new String[]{"RESERVED_0", "hstem", "RESERVED_2", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "RESERVED_9", "callsubr", "return", "escape", "RESERVED_13", "endchar", "RESERVED_15", "RESERVED_16", "RESERVED_17", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "shortint", "callgsubr", "vhcurveto", "hvcurveto"};
    static final String[] SubrsEscapeFuncs = new String[]{"RESERVED_0", "RESERVED_1", "RESERVED_2", "and", "or", "not", "RESERVED_6", "RESERVED_7", "RESERVED_8", "abs", "add", "sub", "div", "RESERVED_13", "neg", "eq", "RESERVED_16", "RESERVED_17", "drop", "RESERVED_19", "put", "get", "ifelse", "random", "mul", "RESERVED_25", "sqrt", "dup", "exch", "index", "roll", "RESERVED_31", "RESERVED_32", "RESERVED_33", "hflex", "flex", "hflex1", "flex1", "RESERVED_REST"};
    HashMap GlyphsUsed;
    ArrayList glyphsInList;
    HashMap FDArrayUsed = new HashMap();
    HashMap[] hSubrsUsed;
    ArrayList[] lSubrsUsed;
    HashMap hGSubrsUsed = new HashMap();
    ArrayList lGSubrsUsed = new ArrayList();
    HashMap hSubrsUsedNonCID = new HashMap();
    ArrayList lSubrsUsedNonCID = new ArrayList();
    byte[][] NewLSubrsIndex;
    byte[] NewSubrsIndexNonCID;
    byte[] NewGSubrsIndex;
    byte[] NewCharStringsIndex;
    int GBias = 0;
    LinkedList OutputList;
    int NumOfHints = 0;

    public CFFFontSubset(RandomAccessFileOrArray randomAccessFileOrArray, HashMap hashMap) {
        super(randomAccessFileOrArray);
        this.GlyphsUsed = hashMap;
        this.glyphsInList = new ArrayList(hashMap.keySet());
        for (int i2 = 0; i2 < this.fonts.length; ++i2) {
            this.seek(this.fonts[i2].charstringsOffset);
            this.fonts[i2].nglyphs = this.getCard16();
            this.seek(this.stringIndexOffset);
            this.fonts[i2].nstrings = this.getCard16() + standardStrings.length;
            this.fonts[i2].charstringsOffsets = this.getIndex(this.fonts[i2].charstringsOffset);
            if (this.fonts[i2].fdselectOffset >= 0) {
                this.readFDSelect(i2);
                this.BuildFDArrayUsed(i2);
            }
            if (this.fonts[i2].isCID) {
                this.ReadFDArray(i2);
            }
            this.fonts[i2].CharsetLength = this.CountCharset(this.fonts[i2].charsetOffset, this.fonts[i2].nglyphs);
        }
    }

    int CountCharset(int n2, int n3) {
        int n4 = 0;
        this.seek(n2);
        char c2 = this.getCard8();
        switch (c2) {
            case '\u0000': {
                n4 = 1 + 2 * n3;
                break;
            }
            case '\u0001': {
                n4 = 1 + 3 * this.CountRange(n3, 1);
                break;
            }
            case '\u0002': {
                n4 = 1 + 4 * this.CountRange(n3, 2);
                break;
            }
        }
        return n4;
    }

    int CountRange(int n2, int n3) {
        char c2;
        int n4 = 0;
        for (int i2 = 1; i2 < n2; i2 += c2 + '\u0001') {
            ++n4;
            char c3 = this.getCard16();
            c2 = n3 == 1 ? this.getCard8() : this.getCard16();
        }
        return n4;
    }

    protected void readFDSelect(int n2) {
        int n3 = this.fonts[n2].nglyphs;
        int[] nArray = new int[n3];
        this.seek(this.fonts[n2].fdselectOffset);
        this.fonts[n2].FDSelectFormat = this.getCard8();
        switch (this.fonts[n2].FDSelectFormat) {
            case 0: {
                for (int i2 = 0; i2 < n3; ++i2) {
                    nArray[i2] = this.getCard8();
                }
                this.fonts[n2].FDSelectLength = this.fonts[n2].nglyphs + 1;
                break;
            }
            case 3: {
                int n4 = this.getCard16();
                int n5 = 0;
                char c2 = this.getCard16();
                for (int i3 = 0; i3 < n4; ++i3) {
                    char c3 = this.getCard8();
                    char c4 = this.getCard16();
                    int n6 = c4 - c2;
                    for (int i4 = 0; i4 < n6; ++i4) {
                        nArray[n5] = c3;
                        ++n5;
                    }
                    c2 = c4;
                }
                this.fonts[n2].FDSelectLength = 3 + n4 * 3 + 2;
                break;
            }
        }
        this.fonts[n2].FDSelect = nArray;
    }

    protected void BuildFDArrayUsed(int n2) {
        int[] nArray = this.fonts[n2].FDSelect;
        for (int i2 = 0; i2 < this.glyphsInList.size(); ++i2) {
            int n3 = (Integer)this.glyphsInList.get(i2);
            int n4 = nArray[n3];
            this.FDArrayUsed.put(new Integer(n4), null);
        }
    }

    protected void ReadFDArray(int n2) {
        this.seek(this.fonts[n2].fdarrayOffset);
        this.fonts[n2].FDArrayCount = this.getCard16();
        this.fonts[n2].FDArrayOffsize = this.getCard8();
        if (this.fonts[n2].FDArrayOffsize < 4) {
            ++this.fonts[n2].FDArrayOffsize;
        }
        this.fonts[n2].FDArrayOffsets = this.getIndex(this.fonts[n2].fdarrayOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] Process(String string) throws IOException {
        try {
            byte[] byArray;
            int n2;
            this.buf.reOpen();
            for (n2 = 0; n2 < this.fonts.length && !string.equals(this.fonts[n2].name); ++n2) {
            }
            if (n2 == this.fonts.length) {
                byte[] byArray2 = null;
                return byArray2;
            }
            if (this.gsubrIndexOffset >= 0) {
                this.GBias = this.CalcBias(this.gsubrIndexOffset, n2);
            }
            this.BuildNewCharString(n2);
            this.BuildNewLGSubrs(n2);
            byte[] byArray3 = byArray = this.BuildNewFile(n2);
            return byArray3;
        }
        finally {
            try {
                this.buf.close();
            }
            catch (Exception exception) {}
        }
    }

    protected int CalcBias(int n2, int n3) {
        this.seek(n2);
        char c2 = this.getCard16();
        if (this.fonts[n3].CharstringType == 1) {
            return 0;
        }
        if (c2 < '\u04d8') {
            return 107;
        }
        if (c2 < '\u846c') {
            return 1131;
        }
        return 32768;
    }

    protected void BuildNewCharString(int n2) throws IOException {
        this.NewCharStringsIndex = this.BuildNewIndex(this.fonts[n2].charstringsOffsets, this.GlyphsUsed);
    }

    protected void BuildNewLGSubrs(int n2) throws IOException {
        if (this.fonts[n2].isCID) {
            this.hSubrsUsed = new HashMap[this.fonts[n2].fdprivateOffsets.length];
            this.lSubrsUsed = new ArrayList[this.fonts[n2].fdprivateOffsets.length];
            this.NewLSubrsIndex = new byte[this.fonts[n2].fdprivateOffsets.length][];
            this.fonts[n2].PrivateSubrsOffset = new int[this.fonts[n2].fdprivateOffsets.length];
            this.fonts[n2].PrivateSubrsOffsetsArray = new int[this.fonts[n2].fdprivateOffsets.length][];
            ArrayList arrayList = new ArrayList(this.FDArrayUsed.keySet());
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n3 = (Integer)arrayList.get(i2);
                this.hSubrsUsed[n3] = new HashMap();
                this.lSubrsUsed[n3] = new ArrayList();
                this.BuildFDSubrsOffsets(n2, n3);
                if (this.fonts[n2].PrivateSubrsOffset[n3] < 0) continue;
                this.BuildSubrUsed(n2, n3, this.fonts[n2].PrivateSubrsOffset[n3], this.fonts[n2].PrivateSubrsOffsetsArray[n3], this.hSubrsUsed[n3], this.lSubrsUsed[n3]);
                this.NewLSubrsIndex[n3] = this.BuildNewIndex(this.fonts[n2].PrivateSubrsOffsetsArray[n3], this.hSubrsUsed[n3]);
            }
        } else if (this.fonts[n2].privateSubrs >= 0) {
            this.fonts[n2].SubrsOffsets = this.getIndex(this.fonts[n2].privateSubrs);
            this.BuildSubrUsed(n2, -1, this.fonts[n2].privateSubrs, this.fonts[n2].SubrsOffsets, this.hSubrsUsedNonCID, this.lSubrsUsedNonCID);
        }
        this.BuildGSubrsUsed(n2);
        if (this.fonts[n2].privateSubrs >= 0) {
            this.NewSubrsIndexNonCID = this.BuildNewIndex(this.fonts[n2].SubrsOffsets, this.hSubrsUsedNonCID);
        }
        this.NewGSubrsIndex = this.BuildNewIndex(this.gsubrOffsets, this.hGSubrsUsed);
    }

    protected void BuildFDSubrsOffsets(int n2, int n3) {
        this.fonts[n2].PrivateSubrsOffset[n3] = -1;
        this.seek(this.fonts[n2].fdprivateOffsets[n3]);
        while (this.getPosition() < this.fonts[n2].fdprivateOffsets[n3] + this.fonts[n2].fdprivateLengths[n3]) {
            this.getDictItem();
            if (this.key != "Subrs") continue;
            this.fonts[n2].PrivateSubrsOffset[n3] = (Integer)this.args[0] + this.fonts[n2].fdprivateOffsets[n3];
        }
        if (this.fonts[n2].PrivateSubrsOffset[n3] >= 0) {
            this.fonts[n2].PrivateSubrsOffsetsArray[n3] = this.getIndex(this.fonts[n2].PrivateSubrsOffset[n3]);
        }
    }

    protected void BuildSubrUsed(int n2, int n3, int n4, int[] nArray, HashMap hashMap, ArrayList arrayList) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.CalcBias(n4, n2);
        for (n8 = 0; n8 < this.glyphsInList.size(); ++n8) {
            n7 = (Integer)this.glyphsInList.get(n8);
            n6 = this.fonts[n2].charstringsOffsets[n7];
            n5 = this.fonts[n2].charstringsOffsets[n7 + 1];
            if (n3 >= 0) {
                this.EmptyStack();
                this.NumOfHints = 0;
                int n10 = this.fonts[n2].FDSelect[n7];
                if (n10 != n3) continue;
                this.ReadASubr(n6, n5, this.GBias, n9, hashMap, arrayList, nArray);
                continue;
            }
            this.ReadASubr(n6, n5, this.GBias, n9, hashMap, arrayList, nArray);
        }
        for (n8 = 0; n8 < arrayList.size(); ++n8) {
            n7 = (Integer)arrayList.get(n8);
            if (n7 >= nArray.length - 1 || n7 < 0) continue;
            n6 = nArray[n7];
            n5 = nArray[n7 + 1];
            this.ReadASubr(n6, n5, this.GBias, n9, hashMap, arrayList, nArray);
        }
    }

    protected void BuildGSubrsUsed(int n2) {
        int n3 = 0;
        int n4 = 0;
        if (this.fonts[n2].privateSubrs >= 0) {
            n3 = this.CalcBias(this.fonts[n2].privateSubrs, n2);
            n4 = this.lSubrsUsedNonCID.size();
        }
        for (int i2 = 0; i2 < this.lGSubrsUsed.size(); ++i2) {
            int n5 = (Integer)this.lGSubrsUsed.get(i2);
            if (n5 >= this.gsubrOffsets.length - 1 || n5 < 0) continue;
            int n6 = this.gsubrOffsets[n5];
            int n7 = this.gsubrOffsets[n5 + 1];
            if (this.fonts[n2].isCID) {
                this.ReadASubr(n6, n7, this.GBias, 0, this.hGSubrsUsed, this.lGSubrsUsed, null);
                continue;
            }
            this.ReadASubr(n6, n7, this.GBias, n3, this.hSubrsUsedNonCID, this.lSubrsUsedNonCID, this.fonts[n2].SubrsOffsets);
            if (n4 >= this.lSubrsUsedNonCID.size()) continue;
            for (int i3 = n4; i3 < this.lSubrsUsedNonCID.size(); ++i3) {
                int n8 = (Integer)this.lSubrsUsedNonCID.get(i3);
                if (n8 >= this.fonts[n2].SubrsOffsets.length - 1 || n8 < 0) continue;
                int n9 = this.fonts[n2].SubrsOffsets[n8];
                int n10 = this.fonts[n2].SubrsOffsets[n8 + 1];
                this.ReadASubr(n9, n10, this.GBias, n3, this.hSubrsUsedNonCID, this.lSubrsUsedNonCID, this.fonts[n2].SubrsOffsets);
            }
            n4 = this.lSubrsUsedNonCID.size();
        }
    }

    protected void ReadASubr(int n2, int n3, int n4, int n5, HashMap hashMap, ArrayList arrayList, int[] nArray) {
        this.EmptyStack();
        this.NumOfHints = 0;
        this.seek(n2);
        while (this.getPosition() < n3) {
            int n6;
            this.ReadCommand();
            int n7 = this.getPosition();
            Object object = null;
            if (this.arg_count > 0) {
                object = this.args[this.arg_count - 1];
            }
            int n8 = this.arg_count;
            this.HandelStack();
            if (this.key == "callsubr") {
                if (n8 <= 0) continue;
                n6 = (Integer)object + n5;
                if (!hashMap.containsKey(new Integer(n6))) {
                    hashMap.put(new Integer(n6), null);
                    arrayList.add(new Integer(n6));
                }
                this.CalcHints(nArray[n6], nArray[n6 + 1], n5, n4, nArray);
                this.seek(n7);
                continue;
            }
            if (this.key == "callgsubr") {
                if (n8 <= 0) continue;
                n6 = (Integer)object + n4;
                if (!this.hGSubrsUsed.containsKey(new Integer(n6))) {
                    this.hGSubrsUsed.put(new Integer(n6), null);
                    this.lGSubrsUsed.add(new Integer(n6));
                }
                this.CalcHints(this.gsubrOffsets[n6], this.gsubrOffsets[n6 + 1], n5, n4, nArray);
                this.seek(n7);
                continue;
            }
            if (this.key == "hstem" || this.key == "vstem" || this.key == "hstemhm" || this.key == "vstemhm") {
                this.NumOfHints += n8 / 2;
                continue;
            }
            if (this.key != "hintmask" && this.key != "cntrmask") continue;
            n6 = this.NumOfHints / 8;
            if (this.NumOfHints % 8 != 0 || n6 == 0) {
                ++n6;
            }
            for (int i2 = 0; i2 < n6; ++i2) {
                this.getCard8();
            }
        }
    }

    protected void HandelStack() {
        int n2 = this.StackOpp();
        if (n2 < 2) {
            if (n2 == 1) {
                this.PushStack();
            } else {
                n2 *= -1;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.PopStack();
                }
            }
        } else {
            this.EmptyStack();
        }
    }

    protected int StackOpp() {
        if (this.key == "ifelse") {
            return -3;
        }
        if (this.key == "roll" || this.key == "put") {
            return -2;
        }
        if (this.key == "callsubr" || this.key == "callgsubr" || this.key == "add" || this.key == "sub" || this.key == "div" || this.key == "mul" || this.key == "drop" || this.key == "and" || this.key == "or" || this.key == "eq") {
            return -1;
        }
        if (this.key == "abs" || this.key == "neg" || this.key == "sqrt" || this.key == "exch" || this.key == "index" || this.key == "get" || this.key == "not" || this.key == "return") {
            return 0;
        }
        if (this.key == "random" || this.key == "dup") {
            return 1;
        }
        return 2;
    }

    protected void EmptyStack() {
        for (int i2 = 0; i2 < this.arg_count; ++i2) {
            this.args[i2] = null;
        }
        this.arg_count = 0;
    }

    protected void PopStack() {
        if (this.arg_count > 0) {
            this.args[this.arg_count - 1] = null;
            --this.arg_count;
        }
    }

    protected void PushStack() {
        ++this.arg_count;
    }

    protected void ReadCommand() {
        this.key = null;
        boolean bl = false;
        while (!bl) {
            char c2;
            int n2;
            char c3 = this.getCard8();
            if (c3 == '\u001c') {
                n2 = this.getCard8();
                c2 = this.getCard8();
                this.args[this.arg_count] = new Integer(n2 << 8 | c2);
                ++this.arg_count;
                continue;
            }
            if (c3 >= ' ' && c3 <= '\u00f6') {
                this.args[this.arg_count] = new Integer(c3 - 139);
                ++this.arg_count;
                continue;
            }
            if (c3 >= '\u00f7' && c3 <= '\u00fa') {
                n2 = this.getCard8();
                this.args[this.arg_count] = new Integer((c3 - 247) * 256 + n2 + 108);
                ++this.arg_count;
                continue;
            }
            if (c3 >= '\u00fb' && c3 <= '\u00fe') {
                n2 = this.getCard8();
                this.args[this.arg_count] = new Integer(-(c3 - 251) * 256 - n2 - 108);
                ++this.arg_count;
                continue;
            }
            if (c3 == '\u00ff') {
                n2 = this.getCard8();
                c2 = this.getCard8();
                char c4 = this.getCard8();
                char c5 = this.getCard8();
                this.args[this.arg_count] = new Integer(n2 << 24 | c2 << 16 | c4 << 8 | c5);
                ++this.arg_count;
                continue;
            }
            if (c3 > '\u001f' || c3 == '\u001c') continue;
            bl = true;
            if (c3 == '\f') {
                n2 = this.getCard8();
                if (n2 > SubrsEscapeFuncs.length - 1) {
                    n2 = SubrsEscapeFuncs.length - 1;
                }
                this.key = SubrsEscapeFuncs[n2];
                continue;
            }
            this.key = SubrsFunctions[c3];
        }
    }

    protected int CalcHints(int n2, int n3, int n4, int n5, int[] nArray) {
        this.seek(n2);
        while (this.getPosition() < n3) {
            int n6;
            this.ReadCommand();
            int n7 = this.getPosition();
            Object object = null;
            if (this.arg_count > 0) {
                object = this.args[this.arg_count - 1];
            }
            int n8 = this.arg_count;
            this.HandelStack();
            if (this.key == "callsubr") {
                if (n8 <= 0) continue;
                n6 = (Integer)object + n4;
                this.CalcHints(nArray[n6], nArray[n6 + 1], n4, n5, nArray);
                this.seek(n7);
                continue;
            }
            if (this.key == "callgsubr") {
                if (n8 <= 0) continue;
                n6 = (Integer)object + n5;
                this.CalcHints(this.gsubrOffsets[n6], this.gsubrOffsets[n6 + 1], n4, n5, nArray);
                this.seek(n7);
                continue;
            }
            if (this.key == "hstem" || this.key == "vstem" || this.key == "hstemhm" || this.key == "vstemhm") {
                this.NumOfHints += n8 / 2;
                continue;
            }
            if (this.key != "hintmask" && this.key != "cntrmask") continue;
            n6 = this.NumOfHints / 8;
            if (this.NumOfHints % 8 != 0 || n6 == 0) {
                ++n6;
            }
            for (int i2 = 0; i2 < n6; ++i2) {
                this.getCard8();
            }
        }
        return this.NumOfHints;
    }

    protected byte[] BuildNewIndex(int[] nArray, HashMap hashMap) throws IOException {
        int n2 = 0;
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = n2;
            if (!hashMap.containsKey(new Integer(i2))) continue;
            n2 += nArray[i2 + 1] - nArray[i2];
        }
        byte[] byArray = new byte[n2];
        for (int i3 = 0; i3 < nArray.length - 1; ++i3) {
            int n3 = nArray2[i3];
            int n4 = nArray2[i3 + 1];
            if (n3 == n4) continue;
            this.buf.seek(nArray[i3]);
            this.buf.readFully(byArray, n3, n4 - n3);
        }
        return this.AssembleIndex(nArray2, byArray);
    }

    protected byte[] AssembleIndex(int[] nArray, byte[] byArray) {
        int n2;
        char c2 = (char)(nArray.length - 1);
        int n3 = nArray[nArray.length - 1];
        int n4 = n3 <= 255 ? 1 : (n3 <= 65535 ? 2 : (n3 <= 0xFFFFFF ? 3 : 4));
        byte[] byArray2 = new byte[3 + n4 * (c2 + '\u0001') + byArray.length];
        int n5 = 0;
        byArray2[n5++] = (byte)(c2 >>> 8 & 0xFF);
        byArray2[n5++] = (byte)(c2 >>> 0 & 0xFF);
        byArray2[n5++] = n4;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n6 = nArray[n2] - nArray[0] + 1;
            switch (n4) {
                case 4: {
                    byArray2[n5++] = (byte)(n6 >>> 24 & 0xFF);
                }
                case 3: {
                    byArray2[n5++] = (byte)(n6 >>> 16 & 0xFF);
                }
                case 2: {
                    byArray2[n5++] = (byte)(n6 >>> 8 & 0xFF);
                }
                case 1: {
                    byArray2[n5++] = (byte)(n6 >>> 0 & 0xFF);
                }
            }
        }
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray2[n5++] = byArray[n2];
        }
        return byArray2;
    }

    protected byte[] BuildNewFile(int n2) throws IOException {
        CFFFont.Item item;
        this.OutputList = new LinkedList();
        this.CopyHeader();
        this.BuildIndexHeader(1, 1, 1);
        this.OutputList.addLast(new CFFFont.UInt8Item((char)(1 + this.fonts[n2].name.length())));
        this.OutputList.addLast(new CFFFont.StringItem(this.fonts[n2].name));
        this.BuildIndexHeader(1, 2, 1);
        CFFFont.IndexOffsetItem indexOffsetItem = new CFFFont.IndexOffsetItem(2);
        this.OutputList.addLast(indexOffsetItem);
        CFFFont.IndexBaseItem indexBaseItem = new CFFFont.IndexBaseItem();
        this.OutputList.addLast(indexBaseItem);
        CFFFont.DictOffsetItem dictOffsetItem = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem dictOffsetItem2 = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem dictOffsetItem3 = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem dictOffsetItem4 = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem dictOffsetItem5 = new CFFFont.DictOffsetItem();
        if (!this.fonts[n2].isCID) {
            this.OutputList.addLast(new CFFFont.DictNumberItem(this.fonts[n2].nstrings));
            this.OutputList.addLast(new CFFFont.DictNumberItem(this.fonts[n2].nstrings + 1));
            this.OutputList.addLast(new CFFFont.DictNumberItem(0));
            this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
            this.OutputList.addLast(new CFFFont.UInt8Item('\u001e'));
            this.OutputList.addLast(new CFFFont.DictNumberItem(this.fonts[n2].nglyphs));
            this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
            this.OutputList.addLast(new CFFFont.UInt8Item('\"'));
        }
        this.seek(this.topdictOffsets[n2]);
        while (this.getPosition() < this.topdictOffsets[n2 + 1]) {
            int n3 = this.getPosition();
            this.getDictItem();
            int n4 = this.getPosition();
            if (this.key == "Encoding" || this.key == "Private" || this.key == "FDSelect" || this.key == "FDArray" || this.key == "charset" || this.key == "CharStrings") continue;
            this.OutputList.add(new CFFFont.RangeItem(this.buf, n3, n4 - n3));
        }
        this.CreateKeys(dictOffsetItem3, dictOffsetItem4, dictOffsetItem, dictOffsetItem2);
        this.OutputList.addLast(new CFFFont.IndexMarkerItem(indexOffsetItem, indexBaseItem));
        if (this.fonts[n2].isCID) {
            this.OutputList.addLast(this.getEntireIndexRange(this.stringIndexOffset));
        } else {
            this.CreateNewStringIndex(n2);
        }
        this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewGSubrsIndex), 0, this.NewGSubrsIndex.length));
        if (this.fonts[n2].isCID) {
            this.OutputList.addLast(new CFFFont.MarkerItem(dictOffsetItem4));
            if (this.fonts[n2].fdselectOffset >= 0) {
                this.OutputList.addLast(new CFFFont.RangeItem(this.buf, this.fonts[n2].fdselectOffset, this.fonts[n2].FDSelectLength));
            } else {
                this.CreateFDSelect(dictOffsetItem4, this.fonts[n2].nglyphs);
            }
            this.OutputList.addLast(new CFFFont.MarkerItem(dictOffsetItem));
            this.OutputList.addLast(new CFFFont.RangeItem(this.buf, this.fonts[n2].charsetOffset, this.fonts[n2].CharsetLength));
            if (this.fonts[n2].fdarrayOffset >= 0) {
                this.OutputList.addLast(new CFFFont.MarkerItem(dictOffsetItem3));
                this.Reconstruct(n2);
            } else {
                this.CreateFDArray(dictOffsetItem3, dictOffsetItem5, n2);
            }
        } else {
            this.CreateFDSelect(dictOffsetItem4, this.fonts[n2].nglyphs);
            this.CreateCharset(dictOffsetItem, this.fonts[n2].nglyphs);
            this.CreateFDArray(dictOffsetItem3, dictOffsetItem5, n2);
        }
        if (this.fonts[n2].privateOffset >= 0) {
            CFFFont.IndexBaseItem indexBaseItem2 = new CFFFont.IndexBaseItem();
            this.OutputList.addLast(indexBaseItem2);
            this.OutputList.addLast(new CFFFont.MarkerItem(dictOffsetItem5));
            CFFFont.DictOffsetItem dictOffsetItem6 = new CFFFont.DictOffsetItem();
            this.CreateNonCIDPrivate(n2, dictOffsetItem6);
            this.CreateNonCIDSubrs(n2, indexBaseItem2, dictOffsetItem6);
        }
        this.OutputList.addLast(new CFFFont.MarkerItem(dictOffsetItem2));
        this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewCharStringsIndex), 0, this.NewCharStringsIndex.length));
        int[] nArray = new int[]{0};
        Iterator iterator = this.OutputList.iterator();
        while (iterator.hasNext()) {
            item = (CFFFont.Item)iterator.next();
            item.increment(nArray);
        }
        iterator = this.OutputList.iterator();
        while (iterator.hasNext()) {
            item = (CFFFont.Item)iterator.next();
            item.xref();
        }
        int n5 = nArray[0];
        byte[] byArray = new byte[n5];
        iterator = this.OutputList.iterator();
        while (iterator.hasNext()) {
            CFFFont.Item item2 = (CFFFont.Item)iterator.next();
            item2.emit(byArray);
        }
        return byArray;
    }

    protected void CopyHeader() {
        this.seek(0);
        char c2 = this.getCard8();
        char c3 = this.getCard8();
        char c4 = this.getCard8();
        char c5 = this.getCard8();
        this.nextIndexOffset = c4;
        this.OutputList.addLast(new CFFFont.RangeItem(this.buf, 0, c4));
    }

    protected void BuildIndexHeader(int n2, int n3, int n4) {
        this.OutputList.addLast(new CFFFont.UInt16Item((char)n2));
        this.OutputList.addLast(new CFFFont.UInt8Item((char)n3));
        switch (n3) {
            case 1: {
                this.OutputList.addLast(new CFFFont.UInt8Item((char)n4));
                break;
            }
            case 2: {
                this.OutputList.addLast(new CFFFont.UInt16Item((char)n4));
                break;
            }
            case 3: {
                this.OutputList.addLast(new CFFFont.UInt24Item((char)n4));
                break;
            }
            case 4: {
                this.OutputList.addLast(new CFFFont.UInt32Item((char)n4));
                break;
            }
        }
    }

    protected void CreateKeys(CFFFont.OffsetItem offsetItem, CFFFont.OffsetItem offsetItem2, CFFFont.OffsetItem offsetItem3, CFFFont.OffsetItem offsetItem4) {
        this.OutputList.addLast(offsetItem);
        this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
        this.OutputList.addLast(new CFFFont.UInt8Item('$'));
        this.OutputList.addLast(offsetItem2);
        this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
        this.OutputList.addLast(new CFFFont.UInt8Item('%'));
        this.OutputList.addLast(offsetItem3);
        this.OutputList.addLast(new CFFFont.UInt8Item('\u000f'));
        this.OutputList.addLast(offsetItem4);
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0011'));
    }

    protected void CreateNewStringIndex(int n2) {
        int n3;
        String string = this.fonts[n2].name + "-OneRange";
        if (string.length() > 127) {
            string = string.substring(0, 127);
        }
        String string2 = "AdobeIdentity" + string;
        int n4 = this.stringOffsets[this.stringOffsets.length - 1] - this.stringOffsets[0];
        int n5 = this.stringOffsets[0] - 1;
        int n6 = n4 + string2.length() <= 255 ? 1 : (n4 + string2.length() <= 65535 ? 2 : (n4 + string2.length() <= 0xFFFFFF ? 3 : 4));
        this.OutputList.addLast(new CFFFont.UInt16Item((char)(this.stringOffsets.length - 1 + 3)));
        this.OutputList.addLast(new CFFFont.UInt8Item((char)n6));
        for (n3 = 0; n3 < this.stringOffsets.length; ++n3) {
            this.OutputList.addLast(new CFFFont.IndexOffsetItem(n6, this.stringOffsets[n3] - n5));
        }
        n3 = this.stringOffsets[this.stringOffsets.length - 1] - n5;
        this.OutputList.addLast(new CFFFont.IndexOffsetItem(n6, n3 += "Adobe".length()));
        this.OutputList.addLast(new CFFFont.IndexOffsetItem(n6, n3 += "Identity".length()));
        this.OutputList.addLast(new CFFFont.IndexOffsetItem(n6, n3 += string.length()));
        this.OutputList.addLast(new CFFFont.RangeItem(this.buf, this.stringOffsets[0], n4));
        this.OutputList.addLast(new CFFFont.StringItem(string2));
    }

    protected void CreateFDSelect(CFFFont.OffsetItem offsetItem, int n2) {
        this.OutputList.addLast(new CFFFont.MarkerItem(offsetItem));
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0003'));
        this.OutputList.addLast(new CFFFont.UInt16Item('\u0001'));
        this.OutputList.addLast(new CFFFont.UInt16Item('\u0000'));
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0000'));
        this.OutputList.addLast(new CFFFont.UInt16Item((char)n2));
    }

    protected void CreateCharset(CFFFont.OffsetItem offsetItem, int n2) {
        this.OutputList.addLast(new CFFFont.MarkerItem(offsetItem));
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0002'));
        this.OutputList.addLast(new CFFFont.UInt16Item('\u0001'));
        this.OutputList.addLast(new CFFFont.UInt16Item((char)(n2 - 1)));
    }

    protected void CreateFDArray(CFFFont.OffsetItem offsetItem, CFFFont.OffsetItem offsetItem2, int n2) {
        this.OutputList.addLast(new CFFFont.MarkerItem(offsetItem));
        this.BuildIndexHeader(1, 1, 1);
        CFFFont.IndexOffsetItem indexOffsetItem = new CFFFont.IndexOffsetItem(1);
        this.OutputList.addLast(indexOffsetItem);
        CFFFont.IndexBaseItem indexBaseItem = new CFFFont.IndexBaseItem();
        this.OutputList.addLast(indexBaseItem);
        int n3 = this.fonts[n2].privateLength;
        int n4 = this.CalcSubrOffsetSize(this.fonts[n2].privateOffset, this.fonts[n2].privateLength);
        if (n4 != 0) {
            n3 += 5 - n4;
        }
        this.OutputList.addLast(new CFFFont.DictNumberItem(n3));
        this.OutputList.addLast(offsetItem2);
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0012'));
        this.OutputList.addLast(new CFFFont.IndexMarkerItem(indexOffsetItem, indexBaseItem));
    }

    void Reconstruct(int n2) throws IOException {
        CFFFont.OffsetItem[] offsetItemArray = new CFFFont.DictOffsetItem[this.fonts[n2].FDArrayOffsets.length - 1];
        CFFFont.IndexBaseItem[] indexBaseItemArray = new CFFFont.IndexBaseItem[this.fonts[n2].fdprivateOffsets.length];
        CFFFont.OffsetItem[] offsetItemArray2 = new CFFFont.DictOffsetItem[this.fonts[n2].fdprivateOffsets.length];
        this.ReconstructFDArray(n2, offsetItemArray);
        this.ReconstructPrivateDict(n2, offsetItemArray, indexBaseItemArray, offsetItemArray2);
        this.ReconstructPrivateSubrs(n2, indexBaseItemArray, offsetItemArray2);
    }

    void ReconstructFDArray(int n2, CFFFont.OffsetItem[] offsetItemArray) throws IOException {
        this.BuildIndexHeader(this.fonts[n2].FDArrayCount, this.fonts[n2].FDArrayOffsize, 1);
        CFFFont.IndexOffsetItem[] indexOffsetItemArray = new CFFFont.IndexOffsetItem[this.fonts[n2].FDArrayOffsets.length - 1];
        for (int i2 = 0; i2 < this.fonts[n2].FDArrayOffsets.length - 1; ++i2) {
            indexOffsetItemArray[i2] = new CFFFont.IndexOffsetItem(this.fonts[n2].FDArrayOffsize);
            this.OutputList.addLast(indexOffsetItemArray[i2]);
        }
        CFFFont.IndexBaseItem indexBaseItem = new CFFFont.IndexBaseItem();
        this.OutputList.addLast(indexBaseItem);
        for (int i3 = 0; i3 < this.fonts[n2].FDArrayOffsets.length - 1; ++i3) {
            if (this.FDArrayUsed.containsKey(new Integer(i3))) {
                this.seek(this.fonts[n2].FDArrayOffsets[i3]);
                while (this.getPosition() < this.fonts[n2].FDArrayOffsets[i3 + 1]) {
                    int n3 = this.getPosition();
                    this.getDictItem();
                    int n4 = this.getPosition();
                    if (this.key == "Private") {
                        int n5 = (Integer)this.args[0];
                        int n6 = this.CalcSubrOffsetSize(this.fonts[n2].fdprivateOffsets[i3], this.fonts[n2].fdprivateLengths[i3]);
                        if (n6 != 0) {
                            n5 += 5 - n6;
                        }
                        this.OutputList.addLast(new CFFFont.DictNumberItem(n5));
                        offsetItemArray[i3] = new CFFFont.DictOffsetItem();
                        this.OutputList.addLast(offsetItemArray[i3]);
                        this.OutputList.addLast(new CFFFont.UInt8Item('\u0012'));
                        this.seek(n4);
                        continue;
                    }
                    this.OutputList.addLast(new CFFFont.RangeItem(this.buf, n3, n4 - n3));
                }
            }
            this.OutputList.addLast(new CFFFont.IndexMarkerItem(indexOffsetItemArray[i3], indexBaseItem));
        }
    }

    void ReconstructPrivateDict(int n2, CFFFont.OffsetItem[] offsetItemArray, CFFFont.IndexBaseItem[] indexBaseItemArray, CFFFont.OffsetItem[] offsetItemArray2) throws IOException {
        for (int i2 = 0; i2 < this.fonts[n2].fdprivateOffsets.length; ++i2) {
            if (!this.FDArrayUsed.containsKey(new Integer(i2))) continue;
            this.OutputList.addLast(new CFFFont.MarkerItem(offsetItemArray[i2]));
            indexBaseItemArray[i2] = new CFFFont.IndexBaseItem();
            this.OutputList.addLast(indexBaseItemArray[i2]);
            this.seek(this.fonts[n2].fdprivateOffsets[i2]);
            while (this.getPosition() < this.fonts[n2].fdprivateOffsets[i2] + this.fonts[n2].fdprivateLengths[i2]) {
                int n3 = this.getPosition();
                this.getDictItem();
                int n4 = this.getPosition();
                if (this.key == "Subrs") {
                    offsetItemArray2[i2] = new CFFFont.DictOffsetItem();
                    this.OutputList.addLast(offsetItemArray2[i2]);
                    this.OutputList.addLast(new CFFFont.UInt8Item('\u0013'));
                    continue;
                }
                this.OutputList.addLast(new CFFFont.RangeItem(this.buf, n3, n4 - n3));
            }
        }
    }

    void ReconstructPrivateSubrs(int n2, CFFFont.IndexBaseItem[] indexBaseItemArray, CFFFont.OffsetItem[] offsetItemArray) throws IOException {
        for (int i2 = 0; i2 < this.fonts[n2].fdprivateLengths.length; ++i2) {
            if (offsetItemArray[i2] == null || this.fonts[n2].PrivateSubrsOffset[i2] < 0) continue;
            this.OutputList.addLast(new CFFFont.SubrMarkerItem(offsetItemArray[i2], indexBaseItemArray[i2]));
            this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewLSubrsIndex[i2]), 0, this.NewLSubrsIndex[i2].length));
        }
    }

    int CalcSubrOffsetSize(int n2, int n3) {
        int n4 = 0;
        this.seek(n2);
        while (this.getPosition() < n2 + n3) {
            int n5 = this.getPosition();
            this.getDictItem();
            int n6 = this.getPosition();
            if (this.key != "Subrs") continue;
            n4 = n6 - n5 - 1;
        }
        return n4;
    }

    protected int countEntireIndexRange(int n2) {
        this.seek(n2);
        char c2 = this.getCard16();
        if (c2 == '\u0000') {
            return 2;
        }
        char c3 = this.getCard8();
        this.seek(n2 + 2 + 1 + c2 * c3);
        int n3 = this.getOffset(c3) - 1;
        return 3 + (c2 + '\u0001') * c3 + n3;
    }

    void CreateNonCIDPrivate(int n2, CFFFont.OffsetItem offsetItem) {
        this.seek(this.fonts[n2].privateOffset);
        while (this.getPosition() < this.fonts[n2].privateOffset + this.fonts[n2].privateLength) {
            int n3 = this.getPosition();
            this.getDictItem();
            int n4 = this.getPosition();
            if (this.key == "Subrs") {
                this.OutputList.addLast(offsetItem);
                this.OutputList.addLast(new CFFFont.UInt8Item('\u0013'));
                continue;
            }
            this.OutputList.addLast(new CFFFont.RangeItem(this.buf, n3, n4 - n3));
        }
    }

    void CreateNonCIDSubrs(int n2, CFFFont.IndexBaseItem indexBaseItem, CFFFont.OffsetItem offsetItem) throws IOException {
        this.OutputList.addLast(new CFFFont.SubrMarkerItem(offsetItem, indexBaseItem));
        this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewSubrsIndexNonCID), 0, this.NewSubrsIndexNonCID.length));
    }
}

