/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfCopyFieldsImp;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class BaseField {
    public static final float BORDER_WIDTH_THIN = 1.0f;
    public static final float BORDER_WIDTH_MEDIUM = 2.0f;
    public static final float BORDER_WIDTH_THICK = 3.0f;
    public static final int VISIBLE = 0;
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int READ_ONLY = 1;
    public static final int REQUIRED = 2;
    public static final int MULTILINE = 4;
    public static final int DO_NOT_SCROLL = 8;
    public static final int PASSWORD = 16;
    public static final int FILE_SELECTION = 32;
    public static final int DO_NOT_SPELL_CHECK = 64;
    public static final int EDIT = 128;
    public static final int COMB = 256;
    protected float borderWidth = 1.0f;
    protected int borderStyle = 0;
    protected Color borderColor;
    protected Color backgroundColor;
    protected Color textColor;
    protected BaseFont font;
    protected float fontSize = 0.0f;
    protected int alignment = 0;
    protected PdfWriter writer;
    protected String text;
    protected Rectangle box;
    protected int rotation = 0;
    protected int visibility;
    protected String fieldName;
    protected int options;
    protected int maxCharacterLength;
    private static final HashMap fieldKeys = new HashMap();

    public BaseField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        this.writer = pdfWriter;
        this.box = rectangle;
        this.fieldName = string;
    }

    protected BaseFont getRealFont() throws IOException, DocumentException {
        if (this.font == null) {
            return BaseFont.createFont("Helvetica", "Cp1252", false);
        }
        return this.font;
    }

    protected PdfAppearance getBorderAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.writer.getDirectContent().createAppearance(this.box.width(), this.box.height());
        switch (this.rotation) {
            case 90: {
                pdfAppearance.setMatrix(0.0f, 1.0f, -1.0f, 0.0f, this.box.height(), 0.0f);
                break;
            }
            case 180: {
                pdfAppearance.setMatrix(-1.0f, 0.0f, 0.0f, -1.0f, this.box.width(), this.box.height());
                break;
            }
            case 270: {
                pdfAppearance.setMatrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.box.width());
            }
        }
        if (this.backgroundColor != null) {
            pdfAppearance.setColorFill(this.backgroundColor);
            pdfAppearance.rectangle(0.0f, 0.0f, this.box.width(), this.box.height());
            pdfAppearance.fill();
        }
        if (this.borderStyle == 4) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                pdfAppearance.setColorStroke(this.borderColor);
                pdfAppearance.setLineWidth(this.borderWidth);
                pdfAppearance.moveTo(0.0f, this.borderWidth / 2.0f);
                pdfAppearance.lineTo(this.box.width(), this.borderWidth / 2.0f);
                pdfAppearance.stroke();
            }
        } else if (this.borderStyle == 2) {
            Color color;
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                pdfAppearance.setColorStroke(this.borderColor);
                pdfAppearance.setLineWidth(this.borderWidth);
                pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                pdfAppearance.stroke();
            }
            if ((color = this.backgroundColor) == null) {
                color = Color.white;
            }
            pdfAppearance.setGrayFill(1.0f);
            this.drawTopFrame(pdfAppearance);
            pdfAppearance.setColorFill(color.darker());
            this.drawBottomFrame(pdfAppearance);
        } else if (this.borderStyle == 3) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                pdfAppearance.setColorStroke(this.borderColor);
                pdfAppearance.setLineWidth(this.borderWidth);
                pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                pdfAppearance.stroke();
            }
            pdfAppearance.setGrayFill(0.5f);
            this.drawTopFrame(pdfAppearance);
            pdfAppearance.setGrayFill(0.75f);
            this.drawBottomFrame(pdfAppearance);
        } else if (this.borderWidth != 0.0f && this.borderColor != null) {
            if (this.borderStyle == 1) {
                pdfAppearance.setLineDash(3.0f, 0.0f);
            }
            pdfAppearance.setColorStroke(this.borderColor);
            pdfAppearance.setLineWidth(this.borderWidth);
            pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
            pdfAppearance.stroke();
            if ((this.options & 0x100) != 0 && this.maxCharacterLength > 1) {
                float f2 = this.box.width() / (float)this.maxCharacterLength;
                float f3 = this.borderWidth / 2.0f;
                float f4 = this.box.height() - this.borderWidth / 2.0f;
                for (int i2 = 1; i2 < this.maxCharacterLength; ++i2) {
                    float f5 = f2 * (float)i2;
                    pdfAppearance.moveTo(f5, f3);
                    pdfAppearance.lineTo(f5, f4);
                }
                pdfAppearance.stroke();
            }
        }
        return pdfAppearance;
    }

    protected static ArrayList getHardBreaks(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 == '\r') {
                if (i2 + 1 < n2 && cArray[i2 + 1] == '\n') {
                    ++i2;
                }
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c2 == '\n') {
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(c2);
        }
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }

    protected static void trimRight(StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        while (n2 != 0) {
            if (stringBuffer.charAt(--n2) != ' ') {
                return;
            }
            stringBuffer.setLength(n2);
        }
        return;
    }

    protected static ArrayList breakLines(ArrayList arrayList, BaseFont baseFont, float f2, float f3) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            stringBuffer.setLength(0);
            float f4 = 0.0f;
            char[] cArray = ((String)arrayList.get(i2)).toCharArray();
            int n2 = cArray.length;
            int n3 = 0;
            int n4 = -1;
            char c2 = '\u0000';
            int n5 = 0;
            block6: for (int i3 = 0; i3 < n2; ++i3) {
                c2 = cArray[i3];
                switch (n3) {
                    case 0: {
                        f4 += baseFont.getWidthPoint(c2, f2);
                        stringBuffer.append(c2);
                        if (f4 > f3) {
                            f4 = 0.0f;
                            if (stringBuffer.length() > 1) {
                                stringBuffer.setLength(stringBuffer.length() - 1);
                            }
                            arrayList2.add(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            n5 = --i3;
                            if (c2 == ' ') {
                                n3 = 2;
                                continue block6;
                            }
                            n3 = 1;
                            continue block6;
                        }
                        if (c2 == ' ') continue block6;
                        n3 = 1;
                        continue block6;
                    }
                    case 1: {
                        f4 += baseFont.getWidthPoint(c2, f2);
                        stringBuffer.append(c2);
                        if (c2 == ' ') {
                            n4 = i3;
                        }
                        if (!(f4 > f3)) continue block6;
                        f4 = 0.0f;
                        if (n4 >= 0) {
                            i3 = n4;
                            stringBuffer.setLength(n4 - n5);
                            BaseField.trimRight(stringBuffer);
                            arrayList2.add(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            n5 = i3;
                            n4 = -1;
                            n3 = 2;
                            continue block6;
                        }
                        if (stringBuffer.length() > 1) {
                            stringBuffer.setLength(stringBuffer.length() - 1);
                        }
                        arrayList2.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        n5 = --i3;
                        if (c2 != ' ') continue block6;
                        n3 = 2;
                        continue block6;
                    }
                    case 2: {
                        if (c2 == ' ') continue block6;
                        f4 = 0.0f;
                        --i3;
                        n3 = 1;
                    }
                }
            }
            BaseField.trimRight(stringBuffer);
            arrayList2.add(stringBuffer.toString());
        }
        return arrayList2;
    }

    private void drawTopFrame(PdfAppearance pdfAppearance) {
        pdfAppearance.moveTo(this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.box.height() - this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - 2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.borderWidth);
        pdfAppearance.fill();
    }

    private void drawBottomFrame(PdfAppearance pdfAppearance) {
        pdfAppearance.moveTo(this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - 2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - 2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.borderWidth);
        pdfAppearance.fill();
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float f2) {
        this.borderWidth = f2;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int n2) {
        this.borderStyle = n2;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public BaseFont getFont() {
        return this.font;
    }

    public void setFont(BaseFont baseFont) {
        this.font = baseFont;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float f2) {
        this.fontSize = f2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Rectangle getBox() {
        return this.box;
    }

    public void setBox(Rectangle rectangle) {
        this.box = rectangle;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n2) {
        if (n2 % 90 != 0) {
            throw new IllegalArgumentException("Rotation must be a multiple of 90.");
        }
        if ((n2 %= 360) < 0) {
            n2 += 360;
        }
        this.rotation = n2;
    }

    public void setRotationFromPage(Rectangle rectangle) {
        this.setRotation(rectangle.getRotation());
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void setVisibility(int n2) {
        this.visibility = n2;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int n2) {
        this.options = n2;
    }

    public int getMaxCharacterLength() {
        return this.maxCharacterLength;
    }

    public void setMaxCharacterLength(int n2) {
        this.maxCharacterLength = n2;
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PdfWriter pdfWriter) {
        this.writer = pdfWriter;
    }

    public static void moveFields(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2) {
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            if (!fieldKeys.containsKey(pdfName)) continue;
            if (pdfDictionary2 != null) {
                pdfDictionary2.put(pdfName, pdfDictionary.get(pdfName));
            }
            iterator.remove();
        }
    }

    static {
        fieldKeys.putAll(PdfCopyFieldsImp.fieldKeys);
        fieldKeys.put(PdfName.T, new Integer(1));
    }
}

