/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class Barcode128
extends Barcode {
    static byte[][] BARS;
    static byte[] BARS_STOP;
    public static final char CODE_AB_TO_C = 'c';
    public static final char CODE_AC_TO_B = 'd';
    public static final char CODE_BC_TO_A = 'e';
    public static final char FNC1_INDEX = 'f';
    public static final char START_A = 'g';
    public static final char START_B = 'h';
    public static final char START_C = 'i';
    public static final char FNC1 = '\u00ca';
    public static final char DEL = '\u00c3';
    public static final char FNC3 = '\u00c4';
    public static final char FNC2 = '\u00c5';
    public static final char SHIFT = '\u00c6';
    public static final char CODE_C = '\u00c7';
    public static final char CODE_A = '\u00c8';
    public static final char FNC4 = '\u00c8';
    public static final char STARTA = '\u00cb';
    public static final char STARTB = '\u00cc';
    public static final char STARTC = '\u00cd';
    private static final IntHashtable ais;

    public Barcode128() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.codeType = 9;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static String removeFNC1(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < ' ' || c2 > '~') continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String getHumanReadableUCCEAN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = String.valueOf('\u00ca');
        try {
            while (true) {
                int n2;
                if (string.startsWith(string2)) {
                    string = string.substring(1);
                    continue;
                }
                int n3 = 0;
                int n4 = 0;
                for (n2 = 2; n2 < 5 && string.length() >= n2; ++n2) {
                    n3 = ais.get(Integer.parseInt(string.substring(0, n2)));
                    if (n3 == 0) continue;
                    n4 = n2;
                    break;
                }
                if (n4 != 0) {
                    stringBuffer.append('(').append(string.substring(0, n4)).append(')');
                    string = string.substring(n4);
                    if (n3 > 0) {
                        if (string.length() > (n3 -= n4)) {
                            stringBuffer.append(Barcode128.removeFNC1(string.substring(0, n3)));
                            string = string.substring(n3);
                            continue;
                        }
                    } else {
                        n2 = string.indexOf(202);
                        if (n2 >= 0) {
                            stringBuffer.append(string.substring(0, n2));
                            string = string.substring(n2 + 1);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append(Barcode128.removeFNC1(string));
        return stringBuffer.toString();
    }

    static boolean isNextDigits(String string, int n2, int n3) {
        int n4 = string.length();
        while (n2 < n4 && n3 > 0) {
            if (string.charAt(n2) == '\u00ca') {
                ++n2;
                continue;
            }
            int n5 = Math.min(2, n3);
            if (n2 + n5 > n4) {
                return false;
            }
            while (n5-- > 0) {
                char c2;
                if ((c2 = string.charAt(n2++)) < '0' || c2 > '9') {
                    return false;
                }
                --n3;
            }
        }
        return n3 == 0;
    }

    static String getPackedRawDigits(String string, int n2, int n3) {
        String string2 = "";
        int n4 = n2;
        while (n3 > 0) {
            if (string.charAt(n2) == '\u00ca') {
                string2 = string2 + 'f';
                ++n2;
                continue;
            }
            n3 -= 2;
            int n5 = string.charAt(n2++) - 48;
            int n6 = string.charAt(n2++) - 48;
            string2 = string2 + (char)(n5 * 10 + n6);
        }
        return (char)(n2 - n4) + string2;
    }

    public static String getRawText(String string, boolean bl) {
        String string2;
        int n2;
        String string3 = "";
        int n3 = string.length();
        if (n3 == 0) {
            string3 = string3 + 'h';
            if (bl) {
                string3 = string3 + 'f';
            }
            return string3;
        }
        char c2 = '\u0000';
        for (n2 = 0; n2 < n3; ++n2) {
            c2 = string.charAt(n2);
            if (c2 <= '\u007f' || c2 == '\u00ca') continue;
            throw new RuntimeException("There are illegal characters for barcode 128 in '" + string + "'.");
        }
        c2 = string.charAt(0);
        n2 = 104;
        int n4 = 0;
        if (Barcode128.isNextDigits(string, n4, 2)) {
            n2 = 105;
            string3 = string3 + (char)n2;
            if (bl) {
                string3 = string3 + 'f';
            }
            string2 = Barcode128.getPackedRawDigits(string, n4, 2);
            n4 += string2.charAt(0);
            string3 = string3 + string2.substring(1);
        } else if (c2 < ' ') {
            n2 = 103;
            string3 = string3 + (char)n2;
            if (bl) {
                string3 = string3 + 'f';
            }
            string3 = string3 + (char)(c2 + 64);
            ++n4;
        } else {
            string3 = string3 + (char)n2;
            if (bl) {
                string3 = string3 + 'f';
            }
            string3 = c2 == '\u00ca' ? string3 + 'f' : string3 + (char)(c2 - 32);
            ++n4;
        }
        while (n4 < n3) {
            switch (n2) {
                case 103: {
                    if (Barcode128.isNextDigits(string, n4, 4)) {
                        n2 = 105;
                        string3 = string3 + 'c';
                        string2 = Barcode128.getPackedRawDigits(string, n4, 4);
                        n4 += string2.charAt(0);
                        string3 = string3 + string2.substring(1);
                        break;
                    }
                    if ((c2 = string.charAt(n4++)) == '\u00ca') {
                        string3 = string3 + 'f';
                        break;
                    }
                    if (c2 > '_') {
                        n2 = 104;
                        string3 = string3 + 'd';
                        string3 = string3 + (char)(c2 - 32);
                        break;
                    }
                    if (c2 < ' ') {
                        string3 = string3 + (char)(c2 + 64);
                        break;
                    }
                    string3 = string3 + (char)(c2 - 32);
                    break;
                }
                case 104: {
                    if (Barcode128.isNextDigits(string, n4, 4)) {
                        n2 = 105;
                        string3 = string3 + 'c';
                        string2 = Barcode128.getPackedRawDigits(string, n4, 4);
                        n4 += string2.charAt(0);
                        string3 = string3 + string2.substring(1);
                        break;
                    }
                    if ((c2 = string.charAt(n4++)) == '\u00ca') {
                        string3 = string3 + 'f';
                        break;
                    }
                    if (c2 < ' ') {
                        n2 = 103;
                        string3 = string3 + 'e';
                        string3 = string3 + (char)(c2 + 64);
                        break;
                    }
                    string3 = string3 + (char)(c2 - 32);
                    break;
                }
                case 105: {
                    if (Barcode128.isNextDigits(string, n4, 2)) {
                        string2 = Barcode128.getPackedRawDigits(string, n4, 2);
                        n4 += string2.charAt(0);
                        string3 = string3 + string2.substring(1);
                        break;
                    }
                    if ((c2 = string.charAt(n4++)) == '\u00ca') {
                        string3 = string3 + 'f';
                        break;
                    }
                    if (c2 < ' ') {
                        n2 = 103;
                        string3 = string3 + 'e';
                        string3 = string3 + (char)(c2 + 64);
                        break;
                    }
                    n2 = 104;
                    string3 = string3 + 'd';
                    string3 = string3 + (char)(c2 - 32);
                }
            }
        }
        return string3;
    }

    public static byte[] getBarsCode128Raw(String string) {
        int n2;
        int n3 = string.indexOf(65535);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        int n4 = string.charAt(0);
        for (int i2 = 1; i2 < string.length(); ++i2) {
            n4 += i2 * string.charAt(i2);
        }
        string = string + (char)(n4 %= 103);
        byte[] byArray = new byte[(string.length() + 1) * 6 + 7];
        for (n2 = 0; n2 < string.length(); ++n2) {
            System.arraycopy(BARS[string.charAt(n2)], 0, byArray, n2 * 6, 6);
        }
        System.arraycopy(BARS_STOP, 0, byArray, n2 * 6, 7);
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        String string;
        int n2;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.codeType == 11 ? ((n2 = this.code.indexOf(65535)) < 0 ? "" : this.code.substring(n2 + 1)) : (this.codeType == 10 ? Barcode128.getHumanReadableUCCEAN(this.code) : Barcode128.removeFNC1(this.code));
            f2 = this.font.getWidthPoint(string, this.size);
        }
        string = this.codeType == 11 ? ((n2 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n2) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n2 = string.length();
        float f4 = (float)((n2 + 2) * 11) * this.x + 2.0f * this.x;
        f4 = Math.max(f4, f2);
        float f5 = this.barHeight + f3;
        return new Rectangle(f4, f5);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        int n2;
        int n3;
        String string = this.codeType == 11 ? ((n3 = this.code.indexOf(65535)) < 0 ? "" : this.code.substring(n3 + 1)) : (this.codeType == 10 ? Barcode128.getHumanReadableUCCEAN(this.code) : Barcode128.removeFNC1(this.code));
        float f2 = 0.0f;
        if (this.font != null) {
            f2 = this.font.getWidthPoint(string, this.size);
        }
        String string2 = this.codeType == 11 ? ((n2 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n2) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n2 = string2.length();
        float f3 = (float)((n2 + 2) * 11) * this.x + 2.0f * this.x;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f7 = this.barHeight - this.baseline;
            } else {
                f7 = -this.font.getFontDescriptor(3, this.size);
                f6 = f7 + this.baseline;
            }
        }
        byte[] byArray = Barcode128.getBarsCode128Raw(string2);
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            float f8 = (float)byArray[i2] * this.x;
            if (bl) {
                pdfContentByte.rectangle(f4, f6, f8 - this.inkSpreading, this.barHeight);
            }
            bl = !bl;
            f4 += f8;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f7);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        int n2;
        int n3;
        int n4 = color.getRGB();
        int n5 = color2.getRGB();
        Canvas canvas = new Canvas();
        String string = this.codeType == 11 ? ((n3 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n3) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n3 = string.length();
        int n6 = (n3 + 2) * 11 + 2;
        byte[] byArray = Barcode128.getBarsCode128Raw(string);
        boolean bl = true;
        int n7 = 0;
        int n8 = (int)this.barHeight;
        int[] nArray = new int[n6 * n8];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n9 = byArray[n2];
            int n10 = n5;
            if (bl) {
                n10 = n4;
            }
            bl = !bl;
            for (int i2 = 0; i2 < n9; ++i2) {
                nArray[n7++] = n10;
            }
        }
        for (n2 = n6; n2 < nArray.length; n2 += n6) {
            System.arraycopy(nArray, 0, nArray, n2, n6);
        }
        Image image = canvas.createImage(new MemoryImageSource(n6, n8, nArray, 0, n6));
        return image;
    }

    public void setCode(String string) {
        if (this.getCodeType() == 10 && string.startsWith("(")) {
            int n2 = 0;
            String string2 = "";
            while (n2 >= 0) {
                int n3 = string.indexOf(41, n2);
                if (n3 < 0) {
                    throw new IllegalArgumentException("Badly formed UCC string: " + string);
                }
                String string3 = string.substring(n2 + 1, n3);
                if (string3.length() < 2) {
                    throw new IllegalArgumentException("AI too short: (" + string3 + ")");
                }
                int n4 = Integer.parseInt(string3);
                int n5 = ais.get(n4);
                if (n5 == 0) {
                    throw new IllegalArgumentException("AI not found: (" + string3 + ")");
                }
                string3 = String.valueOf(n4);
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                int n6 = (n2 = string.indexOf(40, n3)) < 0 ? string.length() : n2;
                string2 = string2 + string3 + string.substring(n3 + 1, n6);
                if (n5 < 0) {
                    if (n2 < 0) continue;
                    string2 = string2 + '\u00ca';
                    continue;
                }
                if (n6 - n3 - 1 + string3.length() == n5) continue;
                throw new IllegalArgumentException("Invalid AI length: (" + string3 + ")");
            }
            super.setCode(string2);
        } else {
            super.setCode(string);
        }
    }

    static {
        int n2;
        BARS = new byte[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}};
        BARS_STOP = new byte[]{2, 3, 3, 1, 1, 1, 2};
        ais = new IntHashtable();
        ais.put(0, 20);
        ais.put(1, 16);
        ais.put(2, 16);
        ais.put(10, -1);
        ais.put(11, 9);
        ais.put(12, 8);
        ais.put(13, 8);
        ais.put(15, 8);
        ais.put(17, 8);
        ais.put(20, 4);
        ais.put(21, -1);
        ais.put(22, -1);
        ais.put(23, -1);
        ais.put(240, -1);
        ais.put(241, -1);
        ais.put(250, -1);
        ais.put(251, -1);
        ais.put(252, -1);
        ais.put(30, -1);
        for (n2 = 3100; n2 < 3700; ++n2) {
            ais.put(n2, 10);
        }
        ais.put(37, -1);
        for (n2 = 3900; n2 < 3940; ++n2) {
            ais.put(n2, -1);
        }
        ais.put(400, -1);
        ais.put(401, -1);
        ais.put(402, 20);
        ais.put(403, -1);
        for (n2 = 410; n2 < 416; ++n2) {
            ais.put(n2, 16);
        }
        ais.put(420, -1);
        ais.put(421, -1);
        ais.put(422, 6);
        ais.put(423, -1);
        ais.put(424, 6);
        ais.put(425, 6);
        ais.put(426, 6);
        ais.put(7001, 17);
        ais.put(7002, -1);
        for (n2 = 7030; n2 < 704; ++n2) {
            ais.put(n2, -1);
        }
        ais.put(8001, 18);
        ais.put(8002, -1);
        ais.put(8003, -1);
        ais.put(8004, -1);
        ais.put(8005, 10);
        ais.put(8006, 22);
        ais.put(8007, -1);
        ais.put(8008, -1);
        ais.put(8018, 22);
        ais.put(8020, -1);
        ais.put(8100, 10);
        ais.put(8101, 14);
        ais.put(8102, 6);
        for (n2 = 90; n2 < 100; ++n2) {
            ais.put(n2, -1);
        }
    }
}

