/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.markup.MarkupParser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class Table
extends Rectangle
implements Element,
MarkupAttributes {
    private int columns;
    private Point curPosition = new Point(0, 0);
    private ArrayList rows = new ArrayList();
    private Cell defaultLayout = new Cell(true);
    private int lastHeaderRow = -1;
    private int alignment = 1;
    private float cellpadding;
    private float cellspacing;
    private float widthPercentage = 80.0f;
    private String absWidth = "";
    private float[] widths;
    boolean mDebug = false;
    boolean mTableInserted = false;
    boolean mAutoFillEmptyCells = false;
    boolean tableFitsPage = false;
    boolean cellsFitPage = false;
    float offset = Float.NaN;
    protected Hashtable alternatingRowAttributes = null;
    private static DecimalFormat widthFormat = new DecimalFormat("0.00");
    static /* synthetic */ Class class$com$lowagie$text$Table;
    static /* synthetic */ Class class$com$lowagie$text$Cell;

    public Table(int n2) throws BadElementException {
        this(n2, 1);
    }

    public Table(int n2, int n3) throws BadElementException {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        this.defaultLayout.setBorder(15);
        if (n2 <= 0) {
            throw new BadElementException("A table should have at least 1 column.");
        }
        this.columns = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.rows.add(new Row(n2));
        }
        this.curPosition = new Point(0, 0);
        this.widths = new float[n2];
        float f2 = 100.0f / (float)n2;
        for (int i3 = 0; i3 < n2; ++i3) {
            this.widths[i3] = f2;
        }
    }

    public Table(Properties properties) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        int n2;
        int n3;
        int n4;
        int n5;
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        this.defaultLayout.setBorder(15);
        String string = (String)properties.remove("columns");
        if (string == null) {
            this.columns = 1;
        } else {
            this.columns = Integer.parseInt(string);
            if (this.columns <= 0) {
                this.columns = 1;
            }
        }
        this.rows.add(new Row(this.columns));
        this.curPosition.setLocation(0, this.curPosition.y);
        string = (String)properties.remove("lastHeaderRow");
        if (string != null) {
            this.setLastHeaderRow(Integer.parseInt(string));
        }
        if ((string = (String)properties.remove("align")) != null) {
            this.setAlignment(string);
        }
        if ((string = (String)properties.remove("cellspacing")) != null) {
            this.setSpacing(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("cellpadding")) != null) {
            this.setPadding(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("offset")) != null) {
            this.setOffset(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("width")) != null) {
            if (string.endsWith("%")) {
                this.setWidth(Float.valueOf(string.substring(0, string.length() - 1) + "f").floatValue());
            } else {
                this.setAbsWidth(string);
            }
        }
        this.widths = new float[this.columns];
        for (n5 = 0; n5 < this.columns; ++n5) {
            this.widths[n5] = 0.0f;
        }
        string = (String)properties.remove("widths");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n6 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                this.widths[n6] = Float.valueOf(string + "f").floatValue();
                ++n6;
            }
            this.columns = n6;
        }
        if ((string = (String)properties.remove("tablefitspage")) != null) {
            this.tableFitsPage = new Boolean(string);
        }
        if ((string = (String)properties.remove("cellsfitpage")) != null) {
            this.cellsFitPage = new Boolean(string);
        }
        if ((string = (String)properties.remove("borderwidth")) != null) {
            this.setBorderWidth(Float.valueOf(string + "f").floatValue());
        }
        n5 = 0;
        string = (String)properties.remove("left");
        if (string != null && new Boolean(string).booleanValue()) {
            n5 |= 4;
        }
        if ((string = (String)properties.remove("right")) != null && new Boolean(string).booleanValue()) {
            n5 |= 8;
        }
        if ((string = (String)properties.remove("top")) != null && new Boolean(string).booleanValue()) {
            n5 |= 1;
        }
        if ((string = (String)properties.remove("bottom")) != null && new Boolean(string).booleanValue()) {
            n5 |= 2;
        }
        this.setBorder(n5);
        String string2 = (String)properties.remove("red");
        String string3 = (String)properties.remove("green");
        String string4 = (String)properties.remove("blue");
        if (string2 != null || string3 != null || string4 != null) {
            n4 = 0;
            n3 = 0;
            n2 = 0;
            if (string2 != null) {
                n4 = Integer.parseInt(string2);
            }
            if (string3 != null) {
                n3 = Integer.parseInt(string3);
            }
            if (string4 != null) {
                n2 = Integer.parseInt(string4);
            }
            this.setBorderColor(new Color(n4, n3, n2));
        } else {
            string = properties.getProperty("bordercolor");
            if (string != null) {
                this.setBorderColor(MarkupParser.decodeColor(string));
            }
        }
        string2 = (String)properties.remove("bgred");
        string3 = (String)properties.remove("bggreen");
        string4 = (String)properties.remove("bgblue");
        if (string2 != null || string3 != null || string4 != null) {
            n4 = 0;
            n3 = 0;
            n2 = 0;
            if (string2 != null) {
                n4 = Integer.parseInt(string2);
            }
            if (string3 != null) {
                n3 = Integer.parseInt(string3);
            }
            if (string4 != null) {
                n2 = Integer.parseInt(string4);
            }
            this.setBackgroundColor(new Color(n4, n3, n2));
        } else {
            string = (String)properties.remove("backgroundcolor");
            if (string != null) {
                this.setBackgroundColor(MarkupParser.decodeColor(string));
            }
        }
        string = (String)properties.remove("grayfill");
        if (string != null) {
            this.setGrayFill(Float.valueOf(string + "f").floatValue());
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public void setDebug(boolean bl) {
        this.mDebug = bl;
    }

    public void setDefaultLayout(Cell cell) {
        this.defaultLayout = cell;
    }

    public void setAutoFillEmptyCells(boolean bl) {
        this.mAutoFillEmptyCells = bl;
    }

    public void setTableFitsPage(boolean bl) {
        this.tableFitsPage = bl;
        if (bl) {
            this.setCellsFitPage(true);
        }
    }

    public void setCellsFitPage(boolean bl) {
        this.cellsFitPage = bl;
    }

    public boolean hasToFitPageTable() {
        return this.tableFitsPage;
    }

    public boolean hasToFitPageCells() {
        return this.cellsFitPage;
    }

    public void setOffset(float f2) {
        this.offset = f2;
    }

    public float getOffset() {
        return this.offset;
    }

    public int type() {
        return 22;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public void addCell(Cell cell, int n2, int n3) throws BadElementException {
        this.addCell(cell, new Point(n2, n3));
    }

    public void addCell(Cell cell, Point point) throws BadElementException {
        if (cell == null) {
            throw new NullPointerException("addCell - cell has null-value");
        }
        if (point == null) {
            throw new NullPointerException("addCell - point has null-value");
        }
        if (cell.isTable()) {
            this.insertTable((Table)cell.getElements().next(), point);
        }
        if (this.mDebug) {
            if (point.x < 0) {
                throw new BadElementException("row coordinate of location must be >= 0");
            }
            if (point.y <= 0 && point.y > this.columns) {
                throw new BadElementException("column coordinate of location must be >= 0 and < nr of columns");
            }
            if (!this.isValidLocation(cell, point)) {
                throw new BadElementException("Adding a cell at the location (" + point.x + "," + point.y + ") with a colspan of " + cell.colspan() + " and a rowspan of " + cell.rowspan() + " is illegal (beyond boundaries/overlapping).");
            }
        }
        if (cell.border() == -1) {
            cell.setBorder(this.defaultLayout.border());
        }
        cell.fill();
        this.placeCell(this.rows, cell, point);
        this.setCurrentLocationToNextValidPosition(point);
    }

    public void addCell(Cell cell) {
        try {
            this.addCell(cell, this.curPosition);
        }
        catch (BadElementException badElementException) {
            // empty catch block
        }
    }

    public void addCell(Phrase phrase) throws BadElementException {
        this.addCell(phrase, this.curPosition);
    }

    public void addCell(Phrase phrase, Point point) throws BadElementException {
        Cell cell = new Cell(phrase);
        cell.setBorder(this.defaultLayout.border());
        cell.setBorderWidth(this.defaultLayout.borderWidth());
        cell.setBorderColor(this.defaultLayout.borderColor());
        cell.setBackgroundColor(this.defaultLayout.backgroundColor());
        cell.setGrayFill(this.defaultLayout.grayFill());
        cell.setHorizontalAlignment(this.defaultLayout.horizontalAlignment());
        cell.setVerticalAlignment(this.defaultLayout.verticalAlignment());
        cell.setColspan(this.defaultLayout.colspan());
        cell.setRowspan(this.defaultLayout.rowspan());
        this.addCell(cell, point);
    }

    public void addCell(String string) throws BadElementException {
        this.addCell(new Phrase(string), this.curPosition);
    }

    public void addCell(String string, Point point) throws BadElementException {
        this.addCell(new Phrase(string), point);
    }

    public void insertTable(Table table) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        this.insertTable(table, this.curPosition);
    }

    public void insertTable(Table table, int n2, int n3) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        this.insertTable(table, new Point(n2, n3));
    }

    public void insertTable(Table table, Point point) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        if (point == null) {
            throw new NullPointerException("insertTable - point has null-value");
        }
        this.mTableInserted = true;
        table.complete();
        if (this.mDebug && point.y > this.columns) {
            System.err.println("insertTable -- wrong columnposition(" + point.y + ") of location; max =" + this.columns);
        }
        int n2 = point.x + 1 - this.rows.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.rows.add(new Row(this.columns));
            }
        }
        ((Row)this.rows.get(point.x)).setElement(table, point.y);
        this.setCurrentLocationToNextValidPosition(point);
    }

    public void complete() {
        if (this.mTableInserted) {
            this.mergeInsertedTables();
            this.mTableInserted = false;
        }
        if (this.mAutoFillEmptyCells) {
            this.fillEmptyMatrixCells();
        }
        if (this.alternatingRowAttributes != null) {
            Properties properties = new Properties();
            Properties properties2 = new Properties();
            Object object = this.alternatingRowAttributes.keySet().iterator();
            while (object.hasNext()) {
                String string = String.valueOf(object.next());
                String[] stringArray = (String[])this.alternatingRowAttributes.get(string);
                properties.setProperty(string, stringArray[0]);
                properties2.setProperty(string, stringArray[1]);
            }
            for (int i2 = this.lastHeaderRow + 1; i2 < this.rows.size(); ++i2) {
                object = (Row)this.rows.get(i2);
                ((Row)object).setMarkupAttributes(i2 % 2 == 0 ? properties : properties2);
            }
        }
    }

    public void setDefaultCellBorder(int n2) {
        this.defaultLayout.setBorder(n2);
    }

    public void setDefaultCellBorderWidth(float f2) {
        this.defaultLayout.setBorderWidth(f2);
    }

    public void setDefaultCellBorderColor(Color color) {
        this.defaultLayout.setBorderColor(color);
    }

    public void setDefaultCellBackgroundColor(Color color) {
        this.defaultLayout.setBackgroundColor(color);
    }

    public void setDefaultCellGrayFill(float f2) {
        if (f2 >= 0.0f && f2 <= 1.0f) {
            this.defaultLayout.setGrayFill(f2);
        }
    }

    public void setDefaultHorizontalAlignment(int n2) {
        this.defaultLayout.setHorizontalAlignment(n2);
    }

    public void setDefaultVerticalAlignment(int n2) {
        this.defaultLayout.setVerticalAlignment(n2);
    }

    public void setDefaultRowspan(int n2) {
        this.defaultLayout.setRowspan(n2);
    }

    public void setDefaultColspan(int n2) {
        this.defaultLayout.setColspan(n2);
    }

    private void assumeTableDefaults(Cell cell) {
        if (cell.border() == -1) {
            cell.setBorder(this.defaultLayout.border());
        }
        if (cell.borderWidth() == -1.0f) {
            cell.setBorderWidth(this.defaultLayout.borderWidth());
        }
        if (cell.borderColor() == null) {
            cell.setBorderColor(this.defaultLayout.borderColor());
        }
        if (cell.backgroundColor() == null) {
            cell.setBackgroundColor(this.defaultLayout.backgroundColor());
        }
        if (cell.grayFill() == -1.0f) {
            cell.setGrayFill(this.defaultLayout.grayFill());
        }
        if (cell.horizontalAlignment() == -1) {
            cell.setHorizontalAlignment(this.defaultLayout.horizontalAlignment());
        }
        if (cell.verticalAlignment() == -1) {
            cell.setVerticalAlignment(this.defaultLayout.verticalAlignment());
        }
    }

    public void deleteColumn(int n2) throws BadElementException {
        int n3;
        float[] fArray = new float[--this.columns];
        for (n3 = 0; n3 < n2; ++n3) {
            fArray[n3] = this.widths[n3];
        }
        for (n3 = n2; n3 < this.columns; ++n3) {
            fArray[n3] = this.widths[n3 + 1];
        }
        this.setWidths(fArray);
        for (n3 = 0; n3 < this.columns; ++n3) {
            fArray[n3] = this.widths[n3];
        }
        this.widths = fArray;
        int n4 = this.rows.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            Row row = (Row)this.rows.get(i2);
            row.deleteColumn(n2);
            this.rows.set(i2, row);
        }
        if (n2 == this.columns) {
            this.curPosition.setLocation(this.curPosition.x + 1, 0);
        }
    }

    public boolean deleteRow(int n2) {
        if (n2 < 0 || n2 >= this.rows.size()) {
            return false;
        }
        this.rows.remove(n2);
        this.curPosition.setLocation(this.curPosition.x - 1, this.curPosition.y);
        return true;
    }

    public void deleteAllRows() {
        this.rows.clear();
        this.rows.add(new Row(this.columns));
        this.curPosition.setLocation(0, 0);
        this.lastHeaderRow = -1;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public int endHeaders() {
        this.lastHeaderRow = this.curPosition.x - 1;
        return this.lastHeaderRow;
    }

    public void setLastHeaderRow(int n2) {
        this.lastHeaderRow = n2;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public void setAlignment(String string) {
        if ("Left".equalsIgnoreCase(string)) {
            this.alignment = 0;
            return;
        }
        if ("right".equalsIgnoreCase(string)) {
            this.alignment = 2;
            return;
        }
        this.alignment = 1;
    }

    public void setSpaceInsideCell(float f2) {
        this.cellpadding = f2;
    }

    public void setSpaceBetweenCells(float f2) {
        this.cellspacing = f2;
    }

    public void setPadding(float f2) {
        this.cellpadding = f2;
    }

    public void setSpacing(float f2) {
        this.cellspacing = f2;
    }

    public void setCellpadding(float f2) {
        this.cellspacing = f2;
    }

    public void setCellspacing(float f2) {
        this.cellpadding = f2;
    }

    public void setWidth(float f2) {
        this.widthPercentage = f2;
    }

    public void setAbsWidth(String string) {
        this.absWidth = string;
    }

    public void setWidths(float[] fArray) throws BadElementException {
        if (fArray.length != this.columns) {
            throw new BadElementException("Wrong number of columns.");
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.columns; ++i2) {
            f2 += fArray[i2];
        }
        this.widths[this.columns - 1] = 100.0f;
        for (int i3 = 0; i3 < this.columns - 1; ++i3) {
            float f3;
            this.widths[i3] = f3 = 100.0f * fArray[i3] / f2;
            int n2 = this.columns - 1;
            this.widths[n2] = this.widths[n2] - f3;
        }
    }

    public void setWidths(int[] nArray) throws DocumentException {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        this.setWidths(fArray);
    }

    public int columns() {
        return this.columns;
    }

    public int size() {
        return this.rows.size();
    }

    public float[] getProportionalWidths() {
        return this.widths;
    }

    public Iterator iterator() {
        return this.rows.iterator();
    }

    public int alignment() {
        return this.alignment;
    }

    public float cellpadding() {
        return this.cellpadding;
    }

    public float cellspacing() {
        return this.cellspacing;
    }

    public float widthPercentage() {
        return this.widthPercentage;
    }

    public String absWidth() {
        return this.absWidth;
    }

    public int firstDataRow() {
        return this.lastHeaderRow + 1;
    }

    public int lastHeaderRow() {
        return this.lastHeaderRow;
    }

    public Dimension getDimension() {
        return new Dimension(this.columns, this.rows.size());
    }

    public Object getElement(int n2, int n3) {
        return ((Row)this.rows.get(n2)).getCell(n3);
    }

    private void mergeInsertedTables() {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        float[] fArray = null;
        int[] nArray = new int[this.columns];
        float[][] fArrayArray = new float[this.columns][];
        int[] nArray2 = new int[this.rows.size()];
        ArrayList<Row> arrayList = null;
        boolean bl = false;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        Table table = null;
        for (n6 = 0; n6 < this.columns; ++n6) {
            n10 = 1;
            float[] fArray2 = null;
            for (n5 = 0; n5 < this.rows.size(); ++n5) {
                if (!(class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n5)).getCell(n6))) continue;
                bl = true;
                table = (Table)((Row)this.rows.get(n5)).getCell(n6);
                if (fArray2 == null) {
                    fArray2 = table.widths;
                    n10 = fArray2.length;
                    continue;
                }
                n4 = table.getDimension().width;
                float[] fArray3 = new float[n4 * fArray2.length];
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                n3 = 0;
                n2 = 0;
                int n11 = 0;
                f2 += fArray2[0];
                f3 += table.widths[0];
                while (n3 < fArray2.length && n2 < n4) {
                    if (f3 > f2) {
                        fArray3[n11] = f2 - f4;
                        if (++n3 < fArray2.length) {
                            f2 += fArray2[n3];
                        }
                    } else {
                        fArray3[n11] = f3 - f4;
                        ++n2;
                        if (f3 == f2 && ++n3 < fArray2.length) {
                            f2 += fArray2[n3];
                        }
                        if (n2 < n4) {
                            f3 += table.widths[n2];
                        }
                    }
                    f4 += fArray3[n11];
                    ++n11;
                }
                fArray2 = new float[n11];
                System.arraycopy(fArray3, 0, fArray2, 0, n11);
                n10 = n11;
            }
            fArrayArray[n6] = fArray2;
            n8 += n10;
            nArray[n6] = n10;
        }
        for (n5 = 0; n5 < this.rows.size(); ++n5) {
            n9 = 1;
            for (n6 = 0; n6 < this.columns; ++n6) {
                if (!(class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n5)).getCell(n6))) continue;
                bl = true;
                table = (Table)((Row)this.rows.get(n5)).getCell(n6);
                if (table.getDimension().height <= n9) continue;
                n9 = table.getDimension().height;
            }
            n7 += n9;
            nArray2[n5] = n9;
        }
        if (n8 != this.columns || n7 != this.rows.size() || bl) {
            fArray = new float[n8];
            int n12 = 0;
            for (n4 = 0; n4 < this.widths.length; ++n4) {
                if (nArray[n4] != 1) {
                    for (int i2 = 0; i2 < nArray[n4]; ++i2) {
                        fArray[n12] = this.widths[n4] * fArrayArray[n4][i2] / 100.0f;
                        ++n12;
                    }
                    continue;
                }
                fArray[n12] = this.widths[n4];
                ++n12;
            }
            arrayList = new ArrayList<Row>(n7);
            for (n5 = 0; n5 < n7; ++n5) {
                arrayList.add(new Row(n8));
            }
            n4 = 0;
            int n13 = 0;
            Object object = null;
            for (n5 = 0; n5 < this.rows.size(); ++n5) {
                n13 = 0;
                n9 = 1;
                for (n6 = 0; n6 < this.columns; ++n6) {
                    Object object2;
                    if ((class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n5)).getCell(n6))) {
                        table = (Table)((Row)this.rows.get(n5)).getCell(n6);
                        object2 = new int[table.widths.length + 1];
                        n3 = 0;
                        for (int i3 = 0; i3 < table.widths.length; ++i3) {
                            object2[i3] = n13 + n3;
                            float f5 = table.widths[i3];
                            float f6 = 0.0f;
                            while (n3 < nArray[n6] && Table.convertWidth(f5) != Table.convertWidth(f6 += fArrayArray[n6][n3++])) {
                            }
                        }
                        object2[i3] = n13 + n3;
                        for (n2 = 0; n2 < table.getDimension().height; ++n2) {
                            for (int i4 = 0; i4 < table.getDimension().width; ++i4) {
                                int n14 = i4;
                                object = table.getElement(n2, i4);
                                if (object == null) continue;
                                Object object3 = n13 + i4;
                                if ((class$com$lowagie$text$Cell == null ? Table.class$("com.lowagie.text.Cell") : class$com$lowagie$text$Cell).isInstance(object)) {
                                    Cell cell = (Cell)object;
                                    object3 = object2[i4];
                                    Object object4 = object2[i4 + cell.colspan()];
                                    cell.setColspan((int)(object4 - object3));
                                }
                                ((Row)arrayList.get(n2 + n4)).addElement(object, (int)object3);
                            }
                        }
                    } else if ((class$com$lowagie$text$Cell == null ? Table.class$("com.lowagie.text.Cell") : class$com$lowagie$text$Cell).isInstance(object2 = this.getElement(n5, n6))) {
                        ((Cell)object2).setRowspan(((Cell)((Row)this.rows.get(n5)).getCell(n6)).rowspan() + nArray2[n5] - 1);
                        ((Cell)object2).setColspan(((Cell)((Row)this.rows.get(n5)).getCell(n6)).colspan() + nArray[n6] - 1);
                        this.placeCell(arrayList, (Cell)object2, new Point(n4, n13));
                    }
                    n13 += nArray[n6];
                }
                n4 += nArray2[n5];
            }
            this.columns = n8;
            this.rows = arrayList;
            this.widths = fArray;
        }
    }

    private void fillEmptyMatrixCells() {
        try {
            for (int i2 = 0; i2 < this.rows.size(); ++i2) {
                for (int i3 = 0; i3 < this.columns; ++i3) {
                    if (((Row)this.rows.get(i2)).isReserved(i3)) continue;
                    this.addCell(this.defaultLayout, new Point(i2, i3));
                }
            }
        }
        catch (BadElementException badElementException) {
            throw new ExceptionConverter(badElementException);
        }
    }

    private boolean isValidLocation(Cell cell, Point point) {
        if (point.x < this.rows.size()) {
            if (point.y + cell.colspan() > this.columns) {
                return false;
            }
            int n2 = this.rows.size() - point.x > cell.rowspan() ? cell.rowspan() : this.rows.size() - point.x;
            int n3 = this.columns - point.y > cell.colspan() ? cell.colspan() : this.columns - point.y;
            for (int i2 = point.x; i2 < point.x + n2; ++i2) {
                for (int i3 = point.y; i3 < point.y + n3; ++i3) {
                    if (!((Row)this.rows.get(i2)).isReserved(i3)) continue;
                    return false;
                }
            }
        } else if (point.y + cell.colspan() > this.columns) {
            return false;
        }
        return true;
    }

    private void placeCell(ArrayList arrayList, Cell cell, Point point) {
        int n2;
        Row row = null;
        int n3 = ((Row)arrayList.get(0)).columns();
        int n4 = point.x + cell.rowspan() - arrayList.size();
        this.assumeTableDefaults(cell);
        if (point.x + cell.rowspan() > arrayList.size()) {
            for (n2 = 0; n2 < n4; ++n2) {
                row = new Row(n3);
                arrayList.add(row);
            }
        }
        for (n2 = point.x + 1; n2 < point.x + cell.rowspan(); ++n2) {
            if (((Row)arrayList.get(n2)).reserve(point.y, cell.colspan())) continue;
            throw new RuntimeException("addCell - error in reserve");
        }
        row = (Row)arrayList.get(point.x);
        row.addElement(cell, point.y);
    }

    public void addColumns(int n2) {
        int n3;
        ArrayList<Row> arrayList = new ArrayList<Row>(this.rows.size());
        int n4 = this.columns + n2;
        for (int i2 = 0; i2 < this.rows.size(); ++i2) {
            Row row = new Row(n4);
            for (n3 = 0; n3 < this.columns; ++n3) {
                row.setElement(((Row)this.rows.get(i2)).getCell(n3), n3);
            }
            for (n3 = this.columns; n3 < n4 && i2 < this.curPosition.x; ++n3) {
                row.setElement(this.defaultLayout, n3);
            }
            arrayList.add(row);
        }
        float[] fArray = new float[n4];
        for (n3 = 0; n3 < this.columns; ++n3) {
            fArray[n3] = this.widths[n3];
        }
        for (n3 = this.columns; n3 < n4; ++n3) {
            fArray[n3] = 0.0f;
        }
        this.columns = n4;
        this.widths = fArray;
        this.rows = arrayList;
    }

    public float[] getWidths(float f2, float f3) {
        float[] fArray = new float[this.columns + 1];
        switch (this.alignment) {
            case 0: {
                fArray[0] = f2;
                break;
            }
            case 2: {
                fArray[0] = f2 + f3 * (100.0f - this.widthPercentage) / 100.0f;
                break;
            }
            default: {
                fArray[0] = f2 + f3 * (100.0f - this.widthPercentage) / 200.0f;
            }
        }
        f3 = f3 * this.widthPercentage / 100.0f;
        for (int i2 = 1; i2 < this.columns; ++i2) {
            fArray[i2] = fArray[i2 - 1] + this.widths[i2 - 1] * f3 / 100.0f;
        }
        fArray[this.columns] = fArray[0] + f3;
        return fArray;
    }

    private void setCurrentLocationToNextValidPosition(Point point) {
        int n2 = point.x;
        int n3 = point.y;
        do {
            if (n3 + 1 == this.columns) {
                ++n2;
                n3 = 0;
                continue;
            }
            ++n3;
        } while (n2 < this.rows.size() && n3 < this.columns && ((Row)this.rows.get(n2)).isReserved(n3));
        this.curPosition = new Point(n2, n3);
    }

    public static boolean isTag(String string) {
        return "table".equals(string);
    }

    public void setAlternatingRowAttribute(String string, String string2, String string3) {
        if (string2 == null || string3 == null) {
            throw new NullPointerException("MarkupTable#setAlternatingRowAttribute(): null values are not permitted.");
        }
        this.alternatingRowAttributes = this.alternatingRowAttributes == null ? new Hashtable() : this.alternatingRowAttributes;
        String[] stringArray = (String[])this.alternatingRowAttributes.get(string);
        stringArray = stringArray == null ? new String[2] : stringArray;
        stringArray[0] = string2;
        stringArray[1] = string3;
        this.alternatingRowAttributes.put(string, stringArray);
    }

    public float top() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float bottom() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float left() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float right() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float top(int n2) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float bottom(int n2) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float left(int n2) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float right(int n2) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public void setTop(int n2) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setBottom(int n2) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setLeft(int n2) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setRight(int n2) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public int getNextRow() {
        return this.curPosition.x;
    }

    public int getNextColumn() {
        return this.curPosition.y;
    }

    private static final double convertWidth(double d2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        try {
            String string = widthFormat.format(d2);
            Number number = widthFormat.parse(string);
            return number.doubleValue();
        }
        catch (ParseException parseException) {
            throw new RuntimeException("Could not convert double to width for val:" + d2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

