/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;

public class RomanList
extends List {
    protected boolean romanlower;
    private static final RomanDigit[] roman = new RomanDigit[]{new RomanDigit('m', 1000, false), new RomanDigit('d', 500, false), new RomanDigit('c', 100, true), new RomanDigit('l', 50, false), new RomanDigit('x', 10, true), new RomanDigit('v', 5, false), new RomanDigit('i', 1, true)};

    public RomanList(int n2) {
        super(true, n2);
    }

    public RomanList(boolean bl, int n2) {
        super(true, n2);
        this.romanlower = bl;
    }

    public void setRomanLower(boolean bl) {
        this.romanlower = bl;
    }

    public boolean isRomanLower() {
        return this.romanlower;
    }

    public boolean add(Object object) {
        if (object instanceof ListItem) {
            ListItem listItem = (ListItem)object;
            Chunk chunk = this.romanlower ? new Chunk(RomanList.toRomanLowerCase(this.first + this.list.size()), this.symbol.font()) : new Chunk(RomanList.toRomanUppercase(this.first + this.list.size()), this.symbol.font());
            chunk.append(".");
            listItem.setListSymbol(chunk);
            listItem.setIndentationLeft(this.symbolIndent);
            listItem.setIndentationRight(0.0f);
            this.list.add(listItem);
        } else {
            if (object instanceof List) {
                List list = (List)object;
                list.setIndentationLeft(list.indentationLeft() + this.symbolIndent);
                --this.first;
                return this.list.add(list);
            }
            if (object instanceof String) {
                return this.add(new ListItem((String)object));
            }
        }
        return false;
    }

    public static String toRoman(int n2) {
        return RomanList.toRomanLowerCase(n2);
    }

    public static String toRomanUppercase(int n2) {
        return RomanList.toRomanLowerCase(n2).toUpperCase();
    }

    public static String toRomanLowerCase(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 < 0) {
            stringBuffer.append('-');
            n2 = -n2;
        }
        if (n2 > 3000) {
            stringBuffer.append('|');
            stringBuffer.append(RomanList.toRomanLowerCase(n2 / 1000));
            stringBuffer.append('|');
            n2 -= n2 / 1000 * 1000;
        }
        int n3 = 0;
        while (true) {
            RomanDigit romanDigit = roman[n3];
            while (n2 >= romanDigit.value) {
                stringBuffer.append(romanDigit.digit);
                n2 -= romanDigit.value;
            }
            if (n2 <= 0) break;
            int n4 = n3;
            while (!RomanList.roman[++n4].pre) {
            }
            if (n2 + RomanList.roman[n4].value >= romanDigit.value) {
                stringBuffer.append(RomanList.roman[n4].digit).append(romanDigit.digit);
                n2 -= romanDigit.value - RomanList.roman[n4].value;
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static class RomanDigit {
        public char digit;
        public int value;
        public boolean pre;

        RomanDigit(char c2, int n2, boolean bl) {
            this.digit = c2;
            this.value = n2;
            this.pre = bl;
        }
    }
}

