/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Graphic
extends PdfContentByte
implements Element {
    public static final String HORIZONTAL_LINE = "HORIZONTAL";
    public static final String BORDER = "BORDER";
    private HashMap attributes;

    public Graphic() {
        super(null);
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 39;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public void setHorizontalLine(float f2, float f3) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(HORIZONTAL_LINE, new Object[]{new Float(f2), new Float(f3), Color.black, new Integer(1)});
    }

    public void setHorizontalLine(float f2, float f3, int n2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(HORIZONTAL_LINE, new Object[]{new Float(f2), new Float(f3), Color.black, new Integer(n2)});
    }

    public void setHorizontalLine(float f2, float f3, Color color) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(HORIZONTAL_LINE, new Object[]{new Float(f2), new Float(f3), color, new Integer(1)});
    }

    public void setHorizontalLine(float f2, float f3, Color color, int n2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(HORIZONTAL_LINE, new Object[]{new Float(f2), new Float(f3), color, new Integer(n2)});
    }

    public void drawHorizontalLine(float f2, Color color, float f3, float f4, float f5) {
        this.setLineWidth(f2);
        this.setColorStroke(color);
        this.moveTo(f3, f5);
        this.lineTo(f4, f5);
        this.stroke();
        this.resetRGBColorStroke();
    }

    public void setBorder(float f2, float f3) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(BORDER, new Object[]{new Float(f2), new Float(f3), new Color(0, 0, 0)});
    }

    public void setBorder(float f2, float f3, Color color) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(BORDER, new Object[]{new Float(f2), new Float(f3), color});
    }

    public void drawBorder(float f2, Color color, float f3, float f4, float f5, float f6) {
        this.setLineWidth(f2);
        this.setColorStroke(color);
        this.rectangle(f3, f4, f5 - f3, f6 - f4);
        this.stroke();
        this.resetRGBColorStroke();
    }

    public void processAttributes(float f2, float f3, float f4, float f5, float f6) {
        if (this.attributes == null) {
            return;
        }
        Iterator iterator = this.attributes.keySet().iterator();
        while (iterator.hasNext()) {
            float f7;
            String string = (String)iterator.next();
            Object[] objectArray = (Object[])this.attributes.get(string);
            if (HORIZONTAL_LINE.equals(string)) {
                float f8;
                f7 = ((Float)objectArray[1]).floatValue();
                float f9 = f7 < 0.0f ? -f7 : (f4 - f2) * f7 / 100.0f;
                int n2 = (Integer)objectArray[3];
                switch (n2) {
                    case 0: {
                        f8 = 0.0f;
                        break;
                    }
                    case 2: {
                        f8 = f4 - f2 - f9;
                        break;
                    }
                    default: {
                        f8 = (f4 - f2 - f9) / 2.0f;
                    }
                }
                this.drawHorizontalLine(((Float)objectArray[0]).floatValue(), (Color)objectArray[2], f8 + f2, f8 + f9 + f2, f6);
            }
            if (!BORDER.equals(string)) continue;
            f7 = ((Float)objectArray[1]).floatValue();
            this.drawBorder(((Float)objectArray[0]).floatValue(), (Color)objectArray[2], f2 - f7, f3 - f7, f4 + f7, f5 + f7);
        }
    }
}

