/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.DERString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERUTF8String
extends DERObject
implements DERString {
    String string;

    public static DERUTF8String getInstance(Object object) {
        if (object == null || object instanceof DERUTF8String) {
            return (DERUTF8String)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERUTF8String(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERUTF8String.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUTF8String getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERUTF8String.getInstance(aSN1TaggedObject.getObject());
    }

    DERUTF8String(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            ++n3;
            if ((byArray[n2] & 0xE0) == 224) {
                n2 += 3;
                continue;
            }
            if ((byArray[n2] & 0xC0) == 192) {
                n2 += 2;
                continue;
            }
            ++n2;
        }
        char[] cArray = new char[n3];
        n2 = 0;
        n3 = 0;
        while (n2 < byArray.length) {
            char c2;
            if ((byArray[n2] & 0xE0) == 224) {
                c2 = (char)((byArray[n2] & 0x1F) << 12 | (byArray[n2 + 1] & 0x3F) << 6 | byArray[n2 + 2] & 0x3F);
                n2 += 3;
            } else if ((byArray[n2] & 0xC0) == 192) {
                c2 = (char)((byArray[n2] & 0x3F) << 6 | byArray[n2 + 1] & 0x3F);
                n2 += 2;
            } else {
                c2 = (char)(byArray[n2] & 0xFF);
                ++n2;
            }
            cArray[n3++] = c2;
        }
        this.string = new String(cArray);
    }

    public DERUTF8String(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERUTF8String)) {
            return false;
        }
        DERUTF8String dERUTF8String = (DERUTF8String)object;
        return this.getString().equals(dERUTF8String.getString());
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        char[] cArray = this.string.toCharArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 != cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (c2 < '\u0080') {
                byteArrayOutputStream.write(c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteArrayOutputStream.write(0xC0 | c2 >> 6);
                byteArrayOutputStream.write(0x80 | c2 & 0x3F);
                continue;
            }
            byteArrayOutputStream.write(0xE0 | c2 >> 12);
            byteArrayOutputStream.write(0x80 | c2 >> 6 & 0x3F);
            byteArrayOutputStream.write(0x80 | c2 & 0x3F);
        }
        dEROutputStream.writeEncoded(12, byteArrayOutputStream.toByteArray());
    }
}

