/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.DEREncodable;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DERTags;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DEROutputStream
extends FilterOutputStream
implements DERTags {
    public DEROutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void writeLength(int n2) throws IOException {
        if (n2 > 127) {
            int n3 = 1;
            int n4 = n2;
            while ((n4 >>>= 8) != 0) {
                ++n3;
            }
            this.write((byte)(n3 | 0x80));
            for (int i2 = (n3 - 1) * 8; i2 >= 0; i2 -= 8) {
                this.write((byte)(n2 >> i2));
            }
        } else {
            this.write((byte)n2);
        }
    }

    void writeEncoded(int n2, byte[] byArray) throws IOException {
        this.write(n2);
        this.writeLength(byArray.length);
        this.write(byArray);
    }

    protected void writeNull() throws IOException {
        this.write(5);
        this.write(0);
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof DERObject) {
            ((DERObject)object).encode(this);
        } else if (object instanceof DEREncodable) {
            ((DEREncodable)object).getDERObject().encode(this);
        } else {
            throw new IOException("object not DEREncodable");
        }
    }
}

