/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1EncodableVector;
import com.lowagie.bc.asn1.BERInputStream;
import com.lowagie.bc.asn1.DERBMPString;
import com.lowagie.bc.asn1.DERBitString;
import com.lowagie.bc.asn1.DERBoolean;
import com.lowagie.bc.asn1.DERConstructedSequence;
import com.lowagie.bc.asn1.DERConstructedSet;
import com.lowagie.bc.asn1.DEREnumerated;
import com.lowagie.bc.asn1.DERGeneralString;
import com.lowagie.bc.asn1.DERGeneralizedTime;
import com.lowagie.bc.asn1.DERIA5String;
import com.lowagie.bc.asn1.DERInteger;
import com.lowagie.bc.asn1.DERNull;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DERObjectIdentifier;
import com.lowagie.bc.asn1.DEROctetString;
import com.lowagie.bc.asn1.DERPrintableString;
import com.lowagie.bc.asn1.DERT61String;
import com.lowagie.bc.asn1.DERTaggedObject;
import com.lowagie.bc.asn1.DERTags;
import com.lowagie.bc.asn1.DERUTCTime;
import com.lowagie.bc.asn1.DERUTF8String;
import com.lowagie.bc.asn1.DERUniversalString;
import com.lowagie.bc.asn1.DERUnknownTag;
import com.lowagie.bc.asn1.DERVisibleString;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DERInputStream
extends FilterInputStream
implements DERTags {
    public DERInputStream(InputStream inputStream) {
        super(inputStream);
    }

    protected int readLength() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (n2 == 128) {
            return -1;
        }
        if (n2 > 127) {
            int n3 = n2 & 0x7F;
            n2 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = this.read();
                if (n4 < 0) {
                    throw new IOException("EOF found reading length");
                }
                n2 = (n2 << 8) + n4;
            }
        }
        return n2;
    }

    protected void readFully(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        if (n2 == 0) {
            return;
        }
        while (n2 > 0) {
            int n3 = this.read(byArray, byArray.length - n2, n2);
            if (n3 < 0) {
                throw new EOFException("unexpected end of stream");
            }
            n2 -= n3;
        }
    }

    protected DERObject buildObject(int n2, byte[] byArray) throws IOException {
        switch (n2) {
            case 5: {
                return null;
            }
            case 48: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                BERInputStream bERInputStream = new BERInputStream(byteArrayInputStream);
                DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
                try {
                    while (true) {
                        DERObject dERObject = bERInputStream.readObject();
                        dERConstructedSequence.addObject(dERObject);
                    }
                }
                catch (EOFException eOFException) {
                    return dERConstructedSequence;
                }
            }
            case 49: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                BERInputStream bERInputStream = new BERInputStream(byteArrayInputStream);
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                try {
                    while (true) {
                        DERObject dERObject = bERInputStream.readObject();
                        aSN1EncodableVector.add(dERObject);
                    }
                }
                catch (EOFException eOFException) {
                    return new DERConstructedSet(aSN1EncodableVector);
                }
            }
            case 1: {
                return new DERBoolean(byArray);
            }
            case 2: {
                return new DERInteger(byArray);
            }
            case 10: {
                return new DEREnumerated(byArray);
            }
            case 6: {
                return new DERObjectIdentifier(byArray);
            }
            case 3: {
                byte by = byArray[0];
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
                return new DERBitString(byArray2, (int)by);
            }
            case 12: {
                return new DERUTF8String(byArray);
            }
            case 19: {
                return new DERPrintableString(byArray);
            }
            case 22: {
                return new DERIA5String(byArray);
            }
            case 20: {
                return new DERT61String(byArray);
            }
            case 26: {
                return new DERVisibleString(byArray);
            }
            case 28: {
                return new DERUniversalString(byArray);
            }
            case 27: {
                return new DERGeneralString(byArray);
            }
            case 30: {
                return new DERBMPString(byArray);
            }
            case 4: {
                return new DEROctetString(byArray);
            }
            case 23: {
                return new DERUTCTime(byArray);
            }
            case 24: {
                return new DERGeneralizedTime(byArray);
            }
        }
        if ((n2 & 0x80) != 0) {
            if ((n2 & 0x1F) == 31) {
                throw new IOException("unsupported high tag encountered");
            }
            if (byArray.length == 0) {
                if ((n2 & 0x20) == 0) {
                    return new DERTaggedObject(false, n2 & 0x1F, new DERNull());
                }
                return new DERTaggedObject(false, n2 & 0x1F, new DERConstructedSequence());
            }
            if ((n2 & 0x20) == 0) {
                return new DERTaggedObject(false, n2 & 0x1F, new DEROctetString(byArray));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BERInputStream bERInputStream = new BERInputStream(byteArrayInputStream);
            DERObject dERObject = bERInputStream.readObject();
            if (bERInputStream.available() == 0) {
                return new DERTaggedObject(n2 & 0x1F, dERObject);
            }
            DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
            dERConstructedSequence.addObject(dERObject);
            try {
                while (true) {
                    dERObject = bERInputStream.readObject();
                    dERConstructedSequence.addObject(dERObject);
                }
            }
            catch (EOFException eOFException) {
                return new DERTaggedObject(false, n2 & 0x1F, dERConstructedSequence);
            }
        }
        return new DERUnknownTag(n2, byArray);
    }

    public DERObject readObject() throws IOException {
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        int n3 = this.readLength();
        byte[] byArray = new byte[n3];
        this.readFully(byArray);
        return this.buildObject(n2, byArray);
    }
}

