/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import java.sql.SQLException;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;

public final class DataTypes {
    public static final byte BOOLEAN = 1;
    public static final byte BYTE = 2;
    public static final byte INT = 3;
    public static final byte LONG = 4;
    public static final byte MONEY = 5;
    public static final byte FLOAT = 6;
    public static final byte DOUBLE = 7;
    public static final byte SHORT_DATE_TIME = 8;
    public static final byte BINARY = 9;
    public static final byte TEXT = 10;
    public static final byte OLE = 11;
    public static final byte MEMO = 12;
    public static final byte UNKNOWN_0D = 13;
    public static final byte GUID = 15;
    public static final byte NUMERIC = 16;
    private static BidiMap SQL_TYPES = new DualHashBidiMap();

    private DataTypes() {
    }

    public static int toSQLType(byte dataType) throws SQLException {
        Integer i2 = (Integer)SQL_TYPES.get(new Byte(dataType));
        if (i2 != null) {
            return i2;
        }
        throw new SQLException("Unsupported data type: " + dataType);
    }

    public static byte fromSQLType(int sqlType) throws SQLException {
        Byte b2 = (Byte)SQL_TYPES.getKey(new Integer(sqlType));
        if (b2 != null) {
            return b2;
        }
        throw new SQLException("Unsupported SQL type: " + sqlType);
    }

    static {
        SQL_TYPES.put(new Byte(1), new Integer(16));
        SQL_TYPES.put(new Byte(2), new Integer(-6));
        SQL_TYPES.put(new Byte(3), new Integer(5));
        SQL_TYPES.put(new Byte(4), new Integer(4));
        SQL_TYPES.put(new Byte(5), new Integer(3));
        SQL_TYPES.put(new Byte(6), new Integer(6));
        SQL_TYPES.put(new Byte(7), new Integer(8));
        SQL_TYPES.put(new Byte(8), new Integer(93));
        SQL_TYPES.put(new Byte(9), new Integer(-2));
        SQL_TYPES.put(new Byte(10), new Integer(12));
        SQL_TYPES.put(new Byte(11), new Integer(-4));
        SQL_TYPES.put(new Byte(12), new Integer(-1));
    }
}

