/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.xml.filtri;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import biz.elabor.prebilling.web.common.AbstractRequestHandler;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import biz.elabor.prebilling.web.xml.filtri.FiltriXmlDefault;
import biz.elabor.prebilling.web.xml.filtri.XmlFilterStrategiesHandler;
import java.util.LinkedHashMap;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class XmlJsonFilterHandler
extends AbstractRequestHandler
implements JsonRequestHandler {
    private final String reseller;
    private final String[] flussi;
    private final String raccolta;
    private final String stato;
    private final String statoEsportazione;
    private final String dataInizio;
    private final String dataFine;
    private final String pod;

    public XmlJsonFilterHandler(String reseller, String[] flussi, String raccolta, String stato, String statoEsportazione, String dataInizio, String dataFine, String pod, TalkManager talkManager) {
        super("xmldel65", talkManager);
        this.reseller = reseller;
        this.flussi = flussi;
        this.raccolta = raccolta;
        this.stato = stato;
        this.statoEsportazione = statoEsportazione;
        this.dataInizio = dataInizio;
        this.dataFine = dataFine;
        this.pod = pod;
    }

    @Override
    public String handleRequest(ConfigurationInstance configurationInstance) throws InvalidParameterValue {
        FiltriXmlDefault filtri = new FiltriXmlDefault(this.flussi, this.raccolta, this.stato, this.statoEsportazione, this.dataInizio, this.dataFine, this.pod);
        PrebillingConfiguration configuration = configurationInstance.getConfiguration();
        XmlFilterStrategiesHandler handler = new XmlFilterStrategiesHandler(this.reseller, filtri, configurationInstance, this.talkManager);
        PrebillingDao prebillingDao = configurationInstance.getPrebillingDao();
        Results results = this.handleRequest(handler, configuration, prebillingDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected String getReseller() {
        return this.reseller;
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("data_inizio", this.dataInizio);
        params.put("data_fine", this.dataFine);
        params.put("stato", this.stato);
        params.put("stato_esportazione", this.statoEsportazione);
        params.put("raccolta", this.raccolta);
        params.put("pod", this.pod);
        params.put("cod_flusso", this.flussi);
        return params;
    }
}

