/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.xml.filtri;

import biz.elabor.prebilling.web.PrebillingControllerHelper;
import biz.elabor.prebilling.web.xml.filtri.FiltriXml;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;

public class FiltriXmlDefault
implements FiltriXml {
    private final Set<String> flussi;
    private final String raccolta;
    private final int stato;
    private final String statoEsportazione;
    private final String pod;
    private final Date dataInizio;
    private final Date dataFine;

    public FiltriXmlDefault(String[] flussi, String raccolta, String stato, String statoEsportazione, String dataInizio, String dataFine, String pod) throws InvalidParameterValue {
        this.flussi = flussi == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(flussi));
        this.raccolta = raccolta == null ? "" : raccolta;
        this.stato = FiltriXmlDefault.checkStato(stato);
        this.statoEsportazione = statoEsportazione == null ? "" : statoEsportazione;
        this.dataInizio = PrebillingControllerHelper.checkData("data inizio", dataInizio, new Date(0L));
        this.dataFine = PrebillingControllerHelper.checkData("data fine", dataFine, CalendarTools.getEndOfTime());
        this.pod = pod == null ? "" : pod;
    }

    private static int checkStato(String stato) throws InvalidParameterValue {
        int value;
        try {
            value = stato == null || stato.isEmpty() ? 0 : Integer.parseInt(stato);
        }
        catch (NumberFormatException e2) {
            throw new InvalidParameterValue("stato", stato);
        }
        return value;
    }

    @Override
    public Set<String> getFlussi() {
        return this.flussi;
    }

    @Override
    public String getRaccolta() {
        return this.raccolta;
    }

    @Override
    public int getStato() {
        return this.stato;
    }

    @Override
    public String getStatoEsportazione() {
        return this.statoEsportazione;
    }

    @Override
    public Date getDataInizio() {
        return this.dataInizio;
    }

    @Override
    public Date getDataFine() {
        return this.dataFine;
    }

    @Override
    public String getPod() {
        return this.pod;
    }
}

