/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.volture;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.ExportLettureTecnicheStrategy;
import biz.elabor.prebilling.services.common.ExportVolturaPodTardivaStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.GetPivStrategy;
import biz.elabor.prebilling.services.common.GetPrestazioniStrategy;
import biz.elabor.prebilling.services.common.GetResellersStrategy;
import biz.elabor.prebilling.services.common.GetSmartPodStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.letture.CheckLateProcessingStrategy;
import biz.elabor.prebilling.services.letture.GetDispatchingFlussiStrategy;
import biz.elabor.prebilling.services.letture.GetPdoLettureStrategy;
import biz.elabor.prebilling.services.letture.RecordLettureStrategy;
import biz.elabor.prebilling.services.volture.ExportVnoCrmStrategy;
import biz.elabor.prebilling.services.volture.ExportVnoNoCrmStrategy;
import biz.elabor.prebilling.services.volture.ExportVoltureIVStrategy;
import biz.elabor.prebilling.services.volture.GetVnoStrategy;
import biz.elabor.prebilling.services.volture.GetVoltureIVStrategy;
import biz.elabor.prebilling.services.volture.RecordStatoVoltureStrategy;
import biz.elabor.prebilling.services.volture.RecordVoltureIVStrategy;
import biz.elabor.prebilling.services.volture.SelectVoltureNonOrarieStrategy;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import biz.elabor.prebilling.web.letture.SpecificaPrestazione;
import java.util.Date;
import java.util.HashMap;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class VoltureStrategiesHandler
extends AbstractStrategiesHandler {
    private final String onlyPod;

    public VoltureStrategiesHandler(String onlyPod, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.onlyPod = onlyPod;
    }

    @Override
    public StrategiesManager buildStrategiesManager() {
        Date toDay = this.configuration.getToDay();
        ElaborCalendar calendar = new ElaborCalendar(toDay);
        int anno = calendar.getAnno();
        Month mese = calendar.getMese();
        Reseller reseller = this.prebillingDao.getReseller("");
        HashMap<String, SpecificaPrestazione> prestazioni = new HashMap<String, SpecificaPrestazione>();
        prestazioni.put("VT3", new SpecificaPrestazione("VT3", 0, 0));
        StrategiesManager service = new StrategiesManager(this.configuration);
        service.addStrategy(new CheckStatusStrategy(Funzionalita.VOLTURE, "*", "volture.check", this.configuration, this.prebillingDao, this.talkManager));
        service.addStrategy(new RecordVoltureIVStrategy(anno, mese, this.onlyPod, this.misureDao, this.giadaDao));
        service.addStrategy(new GetVoltureIVStrategy(this.onlyPod, this.misureDao));
        service.addStrategy(new GetDispatchingFlussiStrategy(this.prebillingDao));
        service.addStrategy(new GetSmartPodStrategy(anno, mese, this.onlyPod, this.configuration, this.giadaDao));
        service.addStrategy(new GetPdoLettureStrategy(anno, mese, "", this.onlyPod, this.misureDao));
        service.addStrategy(new GetVnoStrategy(this.onlyPod, this.misureDao));
        service.addStrategy(new GetResellersStrategy(this.prebillingDao));
        service.addStrategy(new GetPivStrategy(anno, mese, "", this.onlyPod, this.giadaDao, StrategyHelper.VOLTURE_CDUNIPRE_LIST));
        service.addStrategy(new GetPrestazioniStrategy(this.misureDao));
        service.addStrategy(new ExportVoltureIVStrategy(this.misureDao, this.configuration, this.talkManager));
        service.addStrategy(new SelectVoltureNonOrarieStrategy(this.misureDao, this.configuration, this.talkManager));
        service.addStrategy(new ExportLettureTecnicheStrategy(Funzionalita.VOLTURE, anno, mese, this.onlyPod, this.configuration, this.misureDao, this.talkManager));
        service.addStrategy(new ExportVnoCrmStrategy(Funzionalita.VOLTURE, this.configuration, this.misureDao, this.talkManager));
        service.addStrategy(new ExportVnoNoCrmStrategy(Funzionalita.VOLTURE, this.misureDao, this.configuration, this.talkManager));
        service.addStrategy(new CheckLateProcessingStrategy(Funzionalita.VOLTURE, reseller, anno, mese, this.onlyPod, prestazioni, this.configuration, this.misureDao, this.giadaDao, this.talkManager));
        service.addStrategy(new ExportVolturaPodTardivaStrategy(Funzionalita.VOLTURE, this.configuration, this.talkManager));
        service.addStrategy(new RecordStatoVoltureStrategy(this.misureDao, this.talkManager));
        service.addStrategy(new RecordLettureStrategy(this.misureDao, this.talkManager));
        service.addStrategy(new UpdateStatusStrategy(Funzionalita.VOLTURE, "*", TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        service.addStrategy(new FileCopyStrategy(Funzionalita.VOLTURE, this.configuration, this.talkManager));
        service.addStrategy(new UpdateStatusStrategy(Funzionalita.VOLTURE, "*", TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return service;
    }
}

