/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.volture;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import biz.elabor.prebilling.web.common.AbstractRequestHandler;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import biz.elabor.prebilling.web.volture.VoltureStrategiesHandler;
import java.util.LinkedHashMap;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class VoltureJsonPostHandler
extends AbstractRequestHandler
implements JsonRequestHandler {
    private final String filtroPod;

    public VoltureJsonPostHandler(String filtroPod, TalkManager talkManager) {
        super("export.volture", talkManager);
        this.filtroPod = filtroPod;
    }

    @Override
    public String handleRequest(ConfigurationInstance configurationInstance) {
        PrebillingConfiguration configuration = configurationInstance.getConfiguration();
        VoltureStrategiesHandler handler = new VoltureStrategiesHandler(this.filtroPod, configurationInstance, this.talkManager);
        PrebillingDao prebillingDao = configurationInstance.getPrebillingDao();
        Results results = this.handleRequest(handler, configuration, prebillingDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected String getReseller() {
        return null;
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("pod", this.filtroPod);
        return params;
    }
}

