/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.tariffe;

import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import biz.elabor.prebilling.web.common.AbstractRequestHandler;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import biz.elabor.prebilling.web.tariffe.TariffeStrategiesHandler;
import java.util.LinkedHashMap;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class TariffeJsonPostHandler
extends AbstractRequestHandler
implements JsonRequestHandler {
    private String anno;
    private String mese;
    private TipoCalcolo tipo;
    private Destinatari destinatari;
    private String codicePod;
    private boolean scivoloEnabled;
    private boolean scivoloForced;
    private final TipoTrattamento tipoTrattamento;
    private String reseller;
    private final boolean bloccoIndice;

    public TariffeJsonPostHandler(String anno, String mese, TipoCalcolo tipo, Destinatari destinatari, String codicePod, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento tipoTrattamento, String reseller, boolean bloccoIndice, TalkManager talkManager) {
        super("tariffe", talkManager);
        this.anno = anno;
        this.mese = mese;
        this.tipo = tipo;
        this.destinatari = destinatari;
        this.codicePod = codicePod;
        this.scivoloEnabled = scivoloEnabled;
        this.scivoloForced = scivoloForced;
        this.tipoTrattamento = tipoTrattamento == null ? TipoTrattamento.BOTH : tipoTrattamento;
        this.reseller = reseller;
        this.bloccoIndice = bloccoIndice;
    }

    @Override
    public String handleRequest(ConfigurationInstance configurationInstance) {
        PrebillingConfiguration configuration = configurationInstance.getConfiguration();
        TariffeStrategiesHandler handler = new TariffeStrategiesHandler(this.anno, this.mese, this.tipo, this.destinatari, this.codicePod, this.scivoloEnabled, this.scivoloForced, this.tipoTrattamento, this.reseller, this.bloccoIndice, configurationInstance, this.talkManager);
        PrebillingDao prebillingDao = configurationInstance.getPrebillingDao();
        Results results = this.handleRequest(handler, configuration, prebillingDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected String getReseller() {
        return this.reseller;
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("anno", this.anno);
        params.put("mese", this.mese);
        params.put("tipo", (Object)this.tipo);
        params.put("destinatari", (Object)this.destinatari);
        params.put("pod", this.codicePod);
        params.put("scivolo", this.scivoloEnabled);
        params.put("forzato", this.scivoloForced);
        params.put("trattamento", (Object)this.tipoTrattamento);
        params.put("blocco_indice", this.bloccoIndice);
        return params;
    }
}

