/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.tariffe;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ExportErroriTariffeLog
implements ServiceStrategy {
    private PrebillingConfiguration configuration;
    private TalkManager talkManager;
    private final DateFormat timestampFormat;

    public ExportErroriTariffeLog(PrebillingConfiguration configuration, TalkManager talkManager) {
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        Set<String> errori = status.getErroriTariffe();
        String idEsecuzione = status.getIdEsecuzione();
        return this.printErrorLog(errori, idEsecuzione);
    }

    private boolean printErrorLog(Set<String> errori, String idEsecuzione) {
        boolean ok;
        if (errori.isEmpty()) {
            ok = true;
        } else {
            File logFolder = ConfigurationHelper.getDispatcherTmpImportFolder(this.configuration, idEsecuzione, Funzionalita.TARIFFE);
            String timestamp = this.timestampFormat.format(new Date());
            String fileName = "errori-tariffe-" + timestamp + ".csv";
            File logFile = new File(logFolder, fileName);
            try {
                try (PrintWriter log = new PrintWriter(logFile);){
                    for (String errore : errori) {
                        log.println(errore);
                    }
                }
                ok = true;
            }
            catch (FileNotFoundException exc) {
                Message sentence = new Message("export.tariffe.log.strategy", "file.createFailed");
                sentence.addParam(fileName);
                sentence.setCss("alert-danger");
                this.talkManager.addSentence(sentence);
                ok = false;
            }
        }
        return ok;
    }
}

