/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.switched;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.GetCalendarStrategy;
import biz.elabor.prebilling.services.common.GetPivStrategy;
import biz.elabor.prebilling.services.common.GetPrestazioniStrategy;
import biz.elabor.prebilling.services.common.GetResellersStrategy;
import biz.elabor.prebilling.services.common.GetSmartPodStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.letture.GetDispatchingFlussiStrategy;
import biz.elabor.prebilling.services.letture.RecordLettureStrategy;
import biz.elabor.prebilling.services.switched.ExportSnfCrmStrategy;
import biz.elabor.prebilling.services.switched.ExportSnfNoCrmStrategy;
import biz.elabor.prebilling.services.switched.ExportSnmStrategy;
import biz.elabor.prebilling.services.switched.ExportSofCrmStrategy;
import biz.elabor.prebilling.services.switched.ExportSofNoCrmStrategy;
import biz.elabor.prebilling.services.switched.GetSnfStrategy;
import biz.elabor.prebilling.services.switched.GetSnmStrategy;
import biz.elabor.prebilling.services.switched.GetSofStrategy;
import biz.elabor.prebilling.services.switched.RecordStatoSwitchStrategy;
import biz.elabor.prebilling.services.switched.SelectSnfStrategy;
import biz.elabor.prebilling.services.switched.SelectSofStrategy;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class SwitchStrategiesHandler
extends AbstractStrategiesHandler {
    private final String onlyPod;

    public SwitchStrategiesHandler(String onlyPod, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.onlyPod = onlyPod;
    }

    @Override
    public StrategiesManager buildStrategiesManager() {
        StrategiesManager service = new StrategiesManager(this.configuration);
        ElaborCalendar calendar = new ElaborCalendar();
        int anno = calendar.getAnno();
        Month mese = calendar.getMese();
        service.addStrategy(new CheckStatusStrategy(Funzionalita.SWITCH, "*", "switch.check", this.configuration, this.prebillingDao, this.talkManager));
        service.addStrategy(new GetDispatchingFlussiStrategy(this.prebillingDao));
        service.addStrategy(new GetPrestazioniStrategy(this.misureDao));
        service.addStrategy(new GetCalendarStrategy(this.configuration, this.prebillingDao));
        service.addStrategy(new GetResellersStrategy(this.prebillingDao));
        service.addStrategy(new GetSmartPodStrategy(anno, mese, this.onlyPod, this.configuration, this.giadaDao));
        service.addStrategy(new GetSnmStrategy(this.onlyPod, this.misureDao, this.giadaDao, StrategyHelper.STATI));
        service.addStrategy(new GetSnfStrategy(this.onlyPod, this.misureDao, StrategyHelper.STATI));
        service.addStrategy(new GetSofStrategy(this.onlyPod, this.misureDao, StrategyHelper.STATI));
        service.addStrategy(new GetPivStrategy(anno, mese, "", this.onlyPod, this.giadaDao, StrategyHelper.SWITCH_CDUNIPRE_LIST));
        service.addStrategy(new SelectSnfStrategy(this.configuration, this.misureDao, this.talkManager));
        service.addStrategy(new SelectSofStrategy(this.configuration, this.misureDao, this.talkManager));
        service.addStrategy(new ExportSnfCrmStrategy(Funzionalita.SWITCH, this.configuration, this.talkManager));
        service.addStrategy(new ExportSnfNoCrmStrategy(Funzionalita.SWITCH, this.configuration, this.talkManager));
        service.addStrategy(new ExportSnmStrategy(Funzionalita.SWITCH, this.configuration, this.misureDao, this.talkManager));
        service.addStrategy(new ExportSofCrmStrategy(Funzionalita.SWITCH, this.configuration, this.talkManager));
        service.addStrategy(new ExportSofNoCrmStrategy(Funzionalita.SWITCH, this.configuration, this.talkManager));
        service.addStrategy(new RecordLettureStrategy(this.misureDao, this.talkManager));
        service.addStrategy(new RecordStatoSwitchStrategy(this.misureDao, this.talkManager));
        service.addStrategy(new UpdateStatusStrategy(Funzionalita.SWITCH, "*", TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        service.addStrategy(new FileCopyStrategy(Funzionalita.SWITCH, this.configuration, this.talkManager));
        service.addStrategy(new UpdateStatusStrategy(Funzionalita.SWITCH, "*", TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return service;
    }
}

