/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.ricalcolotariffe;

import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import biz.elabor.prebilling.web.common.AbstractRequestHandler;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import biz.elabor.prebilling.web.ricalcolotariffe.RicalcoloTariffeStrategiesHandler;
import java.util.LinkedHashMap;
import java.util.List;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class RicalcoloTariffeJsonPostHandler
extends AbstractRequestHandler
implements JsonRequestHandler {
    private String inizio;
    private String fine;
    private TipoCalcolo tipo;
    private Destinatari destinatari;
    private List<String> pods;
    private String reseller;
    private boolean scivoloEnabled;
    private boolean scivoloForced;
    private final TipoTrattamento tipoTrattamento;
    private final boolean bloccoIndice;

    public RicalcoloTariffeJsonPostHandler(String inizio, String fine, List<String> pods, String reseller, TipoCalcolo tipo, Destinatari destinatari, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento tipoTrattamento, boolean bloccoIndice, TalkManager talkManager) {
        super("ricalcolotariffe", talkManager);
        this.inizio = inizio;
        this.fine = fine;
        this.reseller = reseller;
        this.tipo = tipo;
        this.destinatari = destinatari;
        this.pods = pods;
        this.scivoloEnabled = scivoloEnabled;
        this.scivoloForced = scivoloForced;
        this.tipoTrattamento = tipoTrattamento == null ? TipoTrattamento.BOTH : tipoTrattamento;
        this.bloccoIndice = bloccoIndice;
    }

    @Override
    public String handleRequest(ConfigurationInstance configurationInstance) {
        PrebillingConfiguration configuration = configurationInstance.getConfiguration();
        RicalcoloTariffeStrategiesHandler handler = new RicalcoloTariffeStrategiesHandler(this.inizio, this.fine, this.pods, this.reseller, this.tipo, this.destinatari, this.scivoloEnabled, this.scivoloForced, this.tipoTrattamento, this.bloccoIndice, configurationInstance, this.talkManager);
        PrebillingDao prebillingDao = configurationInstance.getPrebillingDao();
        Results results = this.handleRequest(handler, configuration, prebillingDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected String getReseller() {
        return this.reseller;
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("inizio", this.inizio);
        params.put("fine", this.fine);
        params.put("tipo", (Object)this.tipo);
        params.put("pod", this.pods.subList(0, Math.min(10, this.pods.size())));
        params.put("destinatari", (Object)this.destinatari);
        params.put("scivolo", this.scivoloEnabled);
        params.put("forzato", this.scivoloForced);
        params.put("trattamento", (Object)this.tipoTrattamento);
        params.put("blocco_indice", this.bloccoIndice);
        return params;
    }
}

