/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.riallineamento;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.riallineamento.CheckPnoRiallineamentoStrategy;
import biz.elabor.prebilling.services.riallineamento.ExportRiallineamentoStrategy;
import biz.elabor.prebilling.services.riallineamento.GetAllPodStrategy;
import biz.elabor.prebilling.services.riallineamento.GetPnoRiallineamentoStrategy;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class RiallineamentoStrategiesHandler
extends AbstractStrategiesHandler {
    private String annoTxt;
    private String meseTxt;

    public RiallineamentoStrategiesHandler(String annoTxt, String meseTxt, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.annoTxt = annoTxt;
        this.meseTxt = meseTxt;
    }

    @Override
    public StrategiesManager buildStrategiesManager() throws InvalidParameterValue {
        StrategiesManager manager = new StrategiesManager(this.configuration);
        int anno = ControllerHelper.checkInt("anno", this.annoTxt);
        Month mese = ControllerHelper.checkEnum("mese", this.meseTxt, Month.class);
        manager.addStrategy(new CheckStatusStrategy(Funzionalita.RIALLINEAMENTO, "*", "letture.check", this.configuration, this.prebillingDao, this.talkManager));
        manager.addStrategy(new GetAllPodStrategy(anno, mese, this.configuration, this.giadaDao));
        manager.addStrategy(new GetPnoRiallineamentoStrategy(anno, mese, this.misureDao));
        manager.addStrategy(new ExportRiallineamentoStrategy(Funzionalita.RIALLINEAMENTO, anno, mese, this.configuration, this.talkManager));
        manager.addStrategy(new CheckPnoRiallineamentoStrategy(this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.RIALLINEAMENTO, "*", TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.RIALLINEAMENTO, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.RIALLINEAMENTO, "*", TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return manager;
    }
}

