/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.rettifiche;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.GetCalendarStrategy;
import biz.elabor.prebilling.services.common.GetPrestazioniStrategy;
import biz.elabor.prebilling.services.common.GetResellersStrategy;
import biz.elabor.prebilling.services.common.GetRnoStrategy;
import biz.elabor.prebilling.services.common.GetSmartPodStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.letture.GetDispatchingFlussiStrategy;
import biz.elabor.prebilling.services.letture.GetRfoLettureStrategy;
import biz.elabor.prebilling.services.letture.RecordStatoLettureStrategy;
import biz.elabor.prebilling.services.rettifiche.ExportLogRettifiche;
import biz.elabor.prebilling.services.rettifiche.ExportRfoStrategy;
import biz.elabor.prebilling.services.rettifiche.ExportRsnRnvStrategy;
import biz.elabor.prebilling.services.rettifiche.GetRsnRnvStrategy;
import biz.elabor.prebilling.services.rettifiche.InitialiseLetturePeriodoStrategy;
import biz.elabor.prebilling.web.PrebillingControllerHelper;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import biz.elabor.prebilling.web.letture.ExportLetturePeriodoNoPivStrategy;
import java.util.Date;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class RettificheStrategiesHandler
extends AbstractStrategiesHandler {
    private String azienda;
    private String annoTxt;
    private String meseTxt;
    private String tipoTxt;
    private String onlyPod;

    public RettificheStrategiesHandler(String azienda, String annoTxt, String meseTxt, String tipoTxt, String onlyPod, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.azienda = azienda;
        this.annoTxt = annoTxt;
        this.meseTxt = meseTxt;
        this.tipoTxt = tipoTxt;
        this.onlyPod = onlyPod;
    }

    @Override
    public StrategiesManager buildStrategiesManager() throws InvalidParameterValue {
        StrategiesManager manager = new StrategiesManager(this.configuration);
        int anno = ControllerHelper.checkInt("anno", this.annoTxt);
        Month mese = ControllerHelper.checkEnum("mese", this.meseTxt, Month.class);
        TipoEstrazione tipo = PrebillingControllerHelper.checkTipo(this.tipoTxt);
        Reseller reseller = this.prebillingDao.getReseller(this.azienda);
        Date timestamp = new Date();
        manager.addStrategy(new CheckStatusStrategy(Funzionalita.LETTURE, "*", "letture.check", this.configuration, this.prebillingDao, this.talkManager));
        manager.addStrategy(new GetDispatchingFlussiStrategy(this.prebillingDao));
        manager.addStrategy(new GetCalendarStrategy(this.configuration, this.prebillingDao));
        manager.addStrategy(new GetResellersStrategy(this.prebillingDao));
        manager.addStrategy(new GetPrestazioniStrategy(this.misureDao));
        manager.addStrategy(new GetSmartPodStrategy(anno, mese, this.onlyPod, this.configuration, this.giadaDao));
        manager.addStrategy(new GetRnoStrategy(reseller, this.onlyPod, this.misureDao));
        manager.addStrategy(new GetRfoLettureStrategy(this.onlyPod, this.misureDao, this.talkManager));
        manager.addStrategy(new GetRsnRnvStrategy(anno, mese, this.onlyPod, this.misureDao));
        manager.addStrategy(new InitialiseLetturePeriodoStrategy());
        manager.addStrategy(new ExportLogRettifiche(anno, mese, this.configuration, this.talkManager));
        manager.addStrategy(new ExportRsnRnvStrategy(anno, mese, this.configuration, this.misureDao, this.talkManager, timestamp));
        manager.addStrategy(new ExportRfoStrategy(anno, mese, reseller, tipo, this.onlyPod, this.configuration, this.giadaDao, this.misureDao, this.talkManager));
        manager.addStrategy(new ExportLetturePeriodoNoPivStrategy(anno, mese, this.configuration, this.misureDao, this.talkManager, timestamp));
        manager.addStrategy(new RecordStatoLettureStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.LETTURE, "*", TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.LETTURE, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.LETTURE, "*", TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return manager;
    }
}

