/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.rettifiche;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import biz.elabor.prebilling.web.common.AbstractRequestHandler;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import biz.elabor.prebilling.web.rettifiche.RettificheStrategiesHandler;
import java.util.LinkedHashMap;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class RettificheJsonPostHandler
extends AbstractRequestHandler
implements JsonRequestHandler {
    private final String reseller;
    private final String anno;
    private final String mese;
    private final String onlyPod;
    private final String tipo;

    public RettificheJsonPostHandler(String reseller, String anno, String mese, String tipo, String onlyPod, TalkManager talkManager) {
        super("rettifiche", talkManager);
        this.reseller = reseller;
        this.anno = anno;
        this.mese = mese;
        this.tipo = tipo;
        this.onlyPod = onlyPod;
    }

    @Override
    public String handleRequest(ConfigurationInstance configurationInstance) {
        PrebillingConfiguration configuration = configurationInstance.getConfiguration();
        RettificheStrategiesHandler handler = new RettificheStrategiesHandler(this.reseller, this.anno, this.mese, this.tipo, this.onlyPod, configurationInstance, this.talkManager);
        PrebillingDao prebillingDao = configurationInstance.getPrebillingDao();
        Results results = this.handleRequest(handler, configuration, prebillingDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected String getReseller() {
        return this.reseller;
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("anno", this.anno);
        params.put("mese", this.mese);
        params.put("pod", this.onlyPod);
        params.put("tipo", this.tipo);
        return params;
    }
}

