/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.regime;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.regime.RegimeEleStrategy;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class RegimeEleStrategiesHandler
extends AbstractStrategiesHandler {
    private final int ritardo;
    private final String target;

    public RegimeEleStrategiesHandler(int ritardo, String target, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.ritardo = ritardo;
        this.target = target;
    }

    @Override
    public StrategiesManager buildStrategiesManager() {
        StrategiesManager service = new StrategiesManager(this.configuration);
        service.addStrategy(new CheckStatusStrategy(Funzionalita.REGIME, "*", "check", this.configuration, this.prebillingDao, this.talkManager));
        service.addStrategy(new UpdateStatusStrategy(Funzionalita.REGIME, "*", TipoStato.IN_ESECUZIONE, this.configuration, this.prebillingDao));
        service.addStrategy(new RegimeEleStrategy(this.ritardo, this.target, this.giadaDao, this.configuration));
        service.addStrategy(new UpdateStatusStrategy(Funzionalita.REGIME, "*", TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        service.addStrategy(new FileCopyStrategy(Funzionalita.REGIME, this.configuration, this.talkManager));
        service.addStrategy(new UpdateStatusStrategy(Funzionalita.REGIME, "*", TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return service;
    }
}

