/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.regime;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import biz.elabor.prebilling.web.common.AbstractRequestHandler;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import biz.elabor.prebilling.web.regime.RegimeEleStrategiesHandler;
import java.util.LinkedHashMap;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.tools.StringUtils;

public class RegimeEleJsonHandler
extends AbstractRequestHandler
implements JsonRequestHandler {
    private final String ritardoTxt;
    private final String targetTxt;

    public RegimeEleJsonHandler(String ritardoTxt, String targetTxt, TalkManager talkManager) {
        super("regime", talkManager);
        this.ritardoTxt = ritardoTxt;
        this.targetTxt = targetTxt;
    }

    @Override
    public String handleRequest(ConfigurationInstance configurationInstance) throws InvalidParameterValue {
        int ritardo = ControllerHelper.checkInt("ritardo", this.ritardoTxt);
        String target = StringUtils.isEmpty(this.targetTxt) ? "file" : this.targetTxt;
        PrebillingConfiguration configuration = configurationInstance.getConfiguration();
        PrebillingDao prebillingDao = configurationInstance.getPrebillingDao();
        RegimeEleStrategiesHandler handler = new RegimeEleStrategiesHandler(ritardo, target, configurationInstance, this.talkManager);
        Results results = this.handleRequest(handler, configuration, prebillingDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected String getReseller() {
        return null;
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("ritardo", this.ritardoTxt);
        params.put("target", this.targetTxt);
        return params;
    }
}

