/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.letture;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.ExportLettureTecnicheStrategy;
import biz.elabor.prebilling.services.common.ExportVolturaPodTardivaStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.GetCalendarStrategy;
import biz.elabor.prebilling.services.common.GetPivStrategy;
import biz.elabor.prebilling.services.common.GetPrestazioniStrategy;
import biz.elabor.prebilling.services.common.GetResellersStrategy;
import biz.elabor.prebilling.services.common.GetSmartPodStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.letture.CheckLateProcessingStrategy;
import biz.elabor.prebilling.services.letture.ExportSwitchOutStrategy;
import biz.elabor.prebilling.services.letture.GetDispatchingFlussiStrategy;
import biz.elabor.prebilling.services.letture.RecordLettureStrategy;
import biz.elabor.prebilling.services.letture.RecordStatoLettureStrategy;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import biz.elabor.prebilling.web.letture.InitPnoStrategy;
import biz.elabor.prebilling.web.letture.SpecificaPrestazione;
import java.util.Date;
import java.util.Map;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class LateProcessingStrategiesHandler
extends AbstractStrategiesHandler {
    private Map<String, SpecificaPrestazione> prestazioni;
    private String azienda;
    private String onlyPod;

    public LateProcessingStrategiesHandler(Map<String, SpecificaPrestazione> prestazioni, String azienda, String onlyPod, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.prestazioni = prestazioni;
        this.azienda = azienda;
        this.onlyPod = onlyPod;
    }

    @Override
    public StrategiesManager buildStrategiesManager() {
        StrategiesManager manager = new StrategiesManager(this.configuration);
        Date today = this.configuration.getToDay();
        ElaborCalendar calendar = new ElaborCalendar(today);
        int anno = calendar.getAnno();
        Month mese = calendar.getMese();
        Reseller reseller = this.prebillingDao.getReseller(this.azienda);
        manager.addStrategy(new CheckStatusStrategy(Funzionalita.LATE_PROCESSING, "*", "lateprocessing.check", this.configuration, this.prebillingDao, this.talkManager));
        manager.addStrategy(new GetDispatchingFlussiStrategy(this.prebillingDao));
        manager.addStrategy(new GetCalendarStrategy(this.configuration, this.prebillingDao));
        manager.addStrategy(new GetResellersStrategy(this.prebillingDao));
        manager.addStrategy(new GetPrestazioniStrategy(this.misureDao));
        manager.addStrategy(new GetSmartPodStrategy(anno, mese, this.onlyPod, this.configuration, this.giadaDao));
        manager.addStrategy(new InitPnoStrategy(TipoEstrazione.TUTTI, reseller, this.misureDao, null));
        manager.addStrategy(new GetPivStrategy(anno, mese, this.azienda, this.onlyPod, this.giadaDao, this.prestazioni.keySet()));
        manager.addStrategy(new CheckLateProcessingStrategy(Funzionalita.LATE_PROCESSING, reseller, anno, mese, this.onlyPod, this.prestazioni, this.configuration, this.misureDao, this.giadaDao, this.talkManager));
        manager.addStrategy(new ExportVolturaPodTardivaStrategy(Funzionalita.LATE_PROCESSING, this.configuration, this.talkManager));
        manager.addStrategy(new ExportLettureTecnicheStrategy(Funzionalita.LATE_PROCESSING, anno, mese, this.onlyPod, this.configuration, this.misureDao, this.talkManager));
        manager.addStrategy(new ExportSwitchOutStrategy(Funzionalita.LATE_PROCESSING, anno, mese, this.configuration, this.talkManager));
        manager.addStrategy(new RecordLettureStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new RecordStatoLettureStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.LATE_PROCESSING, "*", TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.LATE_PROCESSING, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.LATE_PROCESSING, "*", TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return manager;
    }
}

