/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.letture;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.FileCopyStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.consolidamento.SplitConsolidamentoStrategy;
import biz.elabor.prebilling.web.common.AbstractStrategiesHandler;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ConsolidamentoStrategiesHandler
extends AbstractStrategiesHandler {
    private String annoTxt;
    private String meseTxt;
    private String onlyPod;

    public ConsolidamentoStrategiesHandler(String annoTxt, String meseTxt, String onlyPod, ConfigurationInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.annoTxt = annoTxt;
        this.meseTxt = meseTxt;
        this.onlyPod = onlyPod;
    }

    @Override
    public StrategiesManager buildStrategiesManager() throws InvalidParameterValue {
        StrategiesManager manager = new StrategiesManager(this.configuration);
        WorkingPeriod wp = StrategyHelper.checkWorkingPeriod(this.annoTxt, this.meseTxt, this.configuration);
        int anno = wp.getYear();
        Month mese = wp.getMonth();
        manager.addStrategy(new CheckStatusStrategy(Funzionalita.CONSOLIDAMENTO, "*", "consolidamento.check", this.configuration, this.prebillingDao, this.talkManager));
        manager.addStrategy(new SplitConsolidamentoStrategy(anno, mese, this.onlyPod, this.configuration, this.misureDao, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.CONSOLIDAMENTO, "*", TipoStato.COPIA_FILE, this.configuration, this.prebillingDao));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.CONSOLIDAMENTO, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.CONSOLIDAMENTO, "*", TipoStato.NO_ESECUZIONE, this.configuration, this.prebillingDao));
        return manager;
    }
}

