/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.letture;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraCompleta;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.letture.ConsumiService;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import biz.elabor.prebilling.web.letture.ConsumiResults;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public abstract class AbstractConsumiJsonHandler
implements JsonRequestHandler {
    protected final TalkManager talkManager;

    public AbstractConsumiJsonHandler(TalkManager talkManager) {
        this.talkManager = talkManager;
    }

    public String handleRequest(ConsumiService service, PrebillingConfiguration configuration) {
        ConsumiResults results = new ConsumiResults();
        try {
            List<Misura> misure = service.getMisure();
            if (!misure.isEmpty()) {
                LinkedHashSet<String> id = new LinkedHashSet<String>();
                results.put("id", id);
                FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
                int n2 = fasciaOrariaArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    FasciaOraria fascia = fasciaOrariaArray[n3];
                    MisuraCompleta attiva = new MisuraCompleta(0.0, 0.0);
                    MisuraCompleta reattiva = new MisuraCompleta(0.0, 0.0);
                    MisuraCompleta potenza = new MisuraCompleta(0.0, 0.0);
                    MisuraCompleta attivaCommerciale = new MisuraCompleta(0.0, 0.0);
                    for (Misura misura : misure) {
                        id.addAll(misura.getId());
                        attiva.add(misura.getAttiva(fascia));
                        reattiva.add(misura.getReattiva(fascia));
                        potenza.setMax(misura.getPotenza(fascia));
                        attivaCommerciale.add(misura.getCommerciale(fascia));
                    }
                    String name = fascia.name();
                    results.put(name, new MisuraCompleta[]{attiva, reattiva, potenza, attivaCommerciale});
                    ++n3;
                }
            }
        }
        catch (RuntimeException exc) {
            Logger logger = this.talkManager.getLogger();
            logger.log(Level.SEVERE, ExceptionUtils.getStackTrace(exc));
            String message = exc.toString();
            this.talkManager.addSentence("consumi", message);
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("consumi", message);
            String key = exc.getKey();
            sentence.addParam(key);
            this.talkManager.addSentence(sentence);
        }
        catch (CalendarNotFoundException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("consumi", message);
            String key = exc.getKey();
            sentence.addParam(key);
            String codicePod = service.getCodicePod();
            sentence.addParam(codicePod);
            this.talkManager.addSentence(sentence);
        }
        this.talkManager.addSentence("consumi", "procedure.successful");
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }
}

