/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.common;

import biz.elabor.prebilling.common.AbstractCommonRequestHandler;
import biz.elabor.prebilling.common.DefaultResults;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.util.Results;
import biz.elabor.prebilling.web.common.StrategiesHandler;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public abstract class AbstractRequestHandler
extends AbstractCommonRequestHandler {
    private final String servizio;

    protected abstract LinkedHashMap<String, Object> getParams();

    protected abstract String getReseller();

    public AbstractRequestHandler(String messageId, TalkManager talkManager) {
        super(messageId, talkManager);
        this.servizio = "E";
    }

    public Results handleRequest(StrategiesHandler handler, PrebillingConfiguration configuration, PrebillingDao prebillingDao) {
        DefaultResults results = null;
        Date inizio = configuration.getToDay();
        ServiceStatus status = new ServiceStatus(configuration, prebillingDao);
        Logger logger = status.getLogger();
        handler.setLogger(logger);
        String reseller = this.getReseller();
        LinkedHashMap<String, Object> params = this.getParams();
        String idEsecuzione = status.getIdEsecuzione();
        prebillingDao.insertRun(this.servizio, idEsecuzione, inizio, this.messageId, reseller, params);
        try {
            StrategiesManager service = handler.buildStrategiesManager();
            boolean ok = service.execute(status);
            this.handleResultMessage(ok);
            results = new DefaultResults(status, null);
        }
        catch (InvalidParameterValue exc) {
            Message sentence = new Message(this.messageId, exc.getMessage());
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
        }
        catch (RuntimeException exc) {
            logger.log(Level.SEVERE, ExceptionUtils.getStackTrace(exc));
            String message = exc.toString();
            Message sentence = new Message(this.messageId, "runtime.error");
            sentence.addParam(message);
            sentence.addParam(PrebillingContext.getPhase());
            sentence.addParam(PrebillingContext.getItem());
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
            results = new DefaultResults(status, null);
        }
        Date fine = configuration.getToDay();
        prebillingDao.updateRun(idEsecuzione, fine);
        return results;
    }
}

