/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web.common;

import biz.elabor.prebilling.common.AbstractController;
import biz.elabor.prebilling.common.config.InvalidConfigurationException;
import biz.elabor.prebilling.config.FileConfigurationsLoader;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.web.PrebillingControllerHelper;
import biz.elabor.prebilling.web.common.JspRequestHandler;
import java.io.IOException;
import javax.servlet.http.HttpSession;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;

public class AbstractPrebillingController
extends AbstractController<ConfigurationInstance> {
    @Autowired
    protected FileConfigurationsLoader configurationLoader;

    public AbstractPrebillingController(String messageId) {
        super(messageId);
    }

    public String handleJspRequest(String config, ModelMap model, HttpSession session, JspRequestHandler handler) {
        String jsp;
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance configuration = this.configurationLoader.loadConfigurationInstance(config);
            try {
                jsp = handler.handleRequest(model, session, configuration);
                PrebillingControllerHelper.handleSessionAndModel(model, session);
                PrebillingConfiguration prebConf = configuration.getConfiguration();
                AbstractPrebillingController.handleVersion(model, prebConf);
            }
            finally {
                configuration.closeConnections();
            }
            model.addAttribute("config", config);
        }
        catch (IOException exc) {
            Message sentence = new Message(this.messageId, "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Message sentence = new Message(this.messageId, message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Message sentence = new Message(this.messageId, message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message(this.messageId, message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    @Override
    protected ConfigurationInstance loadConfigurationInstance(String config) throws InvalidConfigurationException, IOException {
        return this.configurationLoader.loadConfigurationInstance(config);
    }
}

