/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web;

import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import biz.elabor.prebilling.web.common.AbstractPrebillingController;
import biz.elabor.prebilling.web.common.BasicJsonGetHandler;
import biz.elabor.prebilling.web.tariffe.TariffeGetHandler;
import biz.elabor.prebilling.web.tariffe.TariffeJsonPostHandler;
import javax.servlet.http.HttpSession;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TariffeController
extends AbstractPrebillingController {
    public static final String TARIFFE = "tariffe";
    public static final String TARIFFE_URL = "/tariffe.srvl";

    public TariffeController() {
        super("export.tariffe");
    }

    @RequestMapping(value={"/tariffe.srvl"}, method={RequestMethod.GET})
    public String tariffeGet(@RequestParam(value="config") String config, ModelMap model, HttpSession session) {
        TariffeGetHandler handler = new TariffeGetHandler();
        return this.handleJspRequest(config, model, session, handler);
    }

    @RequestMapping(value={"/tariffe.srvl"}, params={"app"}, method={RequestMethod.GET})
    @ResponseBody
    public String tariffeJsonGet(@RequestParam(value="config") String config) {
        TalkManager talkManager = this.getTalkManager();
        BasicJsonGetHandler handler = new BasicJsonGetHandler(talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }

    @RequestMapping(value={"/tariffe.srvl"}, params={"app", "anno"})
    @ResponseBody
    public String tariffeJsonPost(@RequestParam(value="anno") String anno, @RequestParam(value="mese") String mese, @RequestParam(value="tipo") TipoCalcolo tipo, @RequestParam(value="trattamento", required=false) TipoTrattamento trattamento, @RequestParam(value="destinatari") Destinatari destinatari, @RequestParam(value="pod", required=false, defaultValue="") String codicePod, @RequestParam(value="scivolo", required=false, defaultValue="false") boolean scivoloEnabled, @RequestParam(value="forzato", required=false, defaultValue="false") boolean scivoloForced, @RequestParam(value="blocco_indice", required=false, defaultValue="false") boolean bloccoIndice, @RequestParam(value="config") String config, @RequestParam(value="reseller", required=false, defaultValue="") String codiceReseller) {
        TalkManager talkManager = this.getTalkManager();
        TariffeJsonPostHandler handler = new TariffeJsonPostHandler(anno, mese, tipo, destinatari, codicePod, scivoloEnabled, scivoloForced, trattamento, codiceReseller, bloccoIndice, talkManager);
        return this.handleJsonRequest(config, handler, talkManager);
    }
}

