/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web;

import biz.elabor.prebilling.model.TipoEstrazione;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.springframework.ui.ModelMap;

public class PrebillingControllerHelper {
    private static final int ANNO_CORRENTE = CalendarTools.getCurrentYear();
    public static final int[] ANNI = new int[]{ANNO_CORRENTE - 1, ANNO_CORRENTE, ANNO_CORRENTE + 1};
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat USER_DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy");

    public static TipoEstrazione checkTipo(String value) throws InvalidParameterValue {
        TipoEstrazione tipo;
        try {
            tipo = TipoEstrazione.valueOf(value.toUpperCase());
        }
        catch (Exception e2) {
            throw new InvalidParameterValue("tipo", value);
        }
        return tipo;
    }

    public static Date checkData(String value) throws InvalidParameterValue {
        return PrebillingControllerHelper.checkData("data", value, USER_DATE_FORMAT);
    }

    public static Date checkData(String name, String value, DateFormat format) throws InvalidParameterValue {
        Date date;
        try {
            date = format.parse(value);
        }
        catch (ParseException exc) {
            throw new InvalidParameterValue(name, value);
        }
        return date;
    }

    public static Date checkData(String name, String value, Date defaultDate) throws InvalidParameterValue {
        Date data;
        try {
            data = value == null || value.trim().isEmpty() ? defaultDate : DATE_FORMAT.parse(value);
        }
        catch (ParseException exc) {
            throw new InvalidParameterValue(name, value);
        }
        return data;
    }

    public static void handleSessionAndModel(ModelMap model, HttpSession session) {
        model.addAttribute("mesi", CalendarTools.getMonthInfos(Locale.ITALIAN));
        model.addAttribute("anni", ANNI);
        Month mese = (Month)((Object)session.getAttribute("mese"));
        Integer anno = (Integer)session.getAttribute("anno");
        if (mese == null || anno == null) {
            ElaborCalendar calendar = new ElaborCalendar();
            calendar.addMesi(-1);
            session.setAttribute("mese", (Object)calendar.getMese());
            session.setAttribute("anno", calendar.getAnno());
        }
    }
}

