/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web;

import biz.elabor.prebilling.common.AbstractController;
import biz.elabor.prebilling.common.config.InvalidConfigurationException;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.prebilling.Offerta;
import biz.elabor.prebilling.web.common.AbstractPrebillingController;
import java.io.IOException;
import java.util.List;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.DuplicateKeyException;
import org.homelinux.elabor.db.NotDeletableException;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class OfferteController
extends AbstractPrebillingController {
    private static final String LIST = "offerte";
    private static final String ADD = "addofferta";
    private static final String DELETE = "deleteofferta";
    private static final String EDIT = "editofferta";
    private static final String LIST_URL = "/offerte.srvl";
    private static final String ADD_URL = "/addofferta.srvl";
    private static final String DELETE_URL = "/deleteofferta.srvl";
    private static final String EDIT_URL = "/editofferta.srvl";

    public OfferteController() {
        super("manage.offerte");
    }

    @RequestMapping(value={"/offerte.srvl"}, method={RequestMethod.GET})
    public String offerte(@RequestParam(value="config") String config, ModelMap model) {
        String jsp = LIST;
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            try {
                PrebillingConfiguration configuration = instance.getConfiguration();
                PrebillingDao prebillingDao = instance.getPrebillingDao();
                List<Offerta> offerte = prebillingDao.getOfferte();
                model.addAttribute(LIST, offerte);
                AbstractController.handleVersion(model, configuration);
            }
            finally {
                instance.closeConnections();
            }
            model.addAttribute("config", config);
        }
        catch (IOException exc) {
            Warning sentence = new Warning("manage.offerte", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("manage.offerte", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    @RequestMapping(value={"/addofferta.srvl"}, method={RequestMethod.GET})
    public String aggiungiOfferta(@RequestParam(value="config") String config, ModelMap model) {
        String jsp = ADD;
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            try {
                PrebillingConfiguration configuration = instance.getConfiguration();
                AbstractController.handleVersion(model, configuration);
            }
            finally {
                instance.closeConnections();
            }
            model.addAttribute("config", config);
        }
        catch (IOException exc) {
            Warning sentence = new Warning("manage.offerte", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("manage.offerte", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    @RequestMapping(value={"/addofferta.srvl"}, method={RequestMethod.POST})
    public String salvaAdd(@RequestParam(value="indice") String indice, @RequestParam(value="mercato") String mercatoTxt, @RequestParam(value="zona") String zonaTxt, @RequestParam(value="config") String config, ModelMap model) {
        String jsp = "redirect:/offerte.srvl";
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            PrebillingConfiguration configuration = instance.getConfiguration();
            PrebillingDao prebillingDao = instance.getPrebillingDao();
            try {
                try {
                    model.addAttribute("config", config);
                    AbstractController.handleVersion(model, configuration);
                    int mercato = ControllerHelper.checkInt("mercato", mercatoTxt);
                    int zona = ControllerHelper.checkInt("zona", zonaTxt);
                    Offerta offerta = new Offerta(indice, mercato, zona, false, null, null, false);
                    prebillingDao.insertOfferta(offerta);
                }
                catch (DuplicateKeyException exc) {
                    Message sentence = new Message("manage.offerte", "duplicate.data");
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    model.addAttribute("indice", indice);
                    model.addAttribute("mercato", mercatoTxt);
                    model.addAttribute("zona", zonaTxt);
                    jsp = ADD;
                    instance.closeConnections();
                }
                catch (InvalidParameterValue exc) {
                    Message sentence = new Message("manage.offerte", "invalid.data");
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    model.addAttribute("indice", indice);
                    model.addAttribute("mercato", mercatoTxt);
                    model.addAttribute("zona", zonaTxt);
                    jsp = ADD;
                    instance.closeConnections();
                }
            }
            finally {
                instance.closeConnections();
            }
        }
        catch (IOException exc) {
            Warning sentence = new Warning("manage.offerte", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("manage.offerte", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    @RequestMapping(value={"/deleteofferta.srvl"}, method={RequestMethod.GET})
    public String deleteOfferta(@RequestParam(value="config") String config, @RequestParam(value="indice") String indiceTxt, ModelMap model) {
        String jsp = DELETE;
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            PrebillingConfiguration configuration = instance.getConfiguration();
            PrebillingDao prebillingDao = instance.getPrebillingDao();
            try {
                try {
                    model.addAttribute("config", config);
                    AbstractController.handleVersion(model, configuration);
                    int indice = ControllerHelper.checkInt("indice", indiceTxt);
                    Offerta offerta = prebillingDao.getOfferta(indice);
                    model.addAttribute("offerta", offerta);
                }
                catch (InvalidParameterValue exc) {
                    Message sentence = new Message("manage.offerte", "invalid.data");
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    jsp = "redirect:/offerte.srvl";
                    instance.closeConnections();
                }
                catch (DataNotFoundException exc) {
                    Message sentence = new Message("manage.offerte", "offerta.notfound");
                    sentence.addParam(exc.getKey());
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    jsp = "redirect:/offerte.srvl";
                    instance.closeConnections();
                }
            }
            finally {
                instance.closeConnections();
            }
        }
        catch (IOException exc) {
            Warning sentence = new Warning("manage.offerte", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("manage.offerte", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    /*
     * Loose catch block
     */
    @RequestMapping(value={"/deleteofferta.srvl"}, method={RequestMethod.POST})
    public String effettuaDelete(@RequestParam(value="indice") String indiceTxt, @RequestParam(value="config") String config, ModelMap model) {
        String jsp = "redirect:/offerte.srvl";
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            PrebillingDao prebillingDao = instance.getPrebillingDao();
            try {
                try {
                    model.addAttribute("config", config);
                    int indice = ControllerHelper.checkInt("indice", indiceTxt);
                    Offerta offerta = prebillingDao.getOfferta(indice);
                    prebillingDao.deleteOfferta(offerta);
                }
                catch (InvalidParameterValue exc) {
                    Message sentence = new Message("manage.offerte", "invalid.data");
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    instance.closeConnections();
                }
                catch (NotDeletableException exc) {
                    Message sentence = new Message("manage.offerte", "delete.error");
                    sentence.setCss("alert-danger");
                    talkManager.addSentence(sentence);
                    instance.closeConnections();
                }
                catch (DataNotFoundException exc) {
                    Message sentence = new Message("manage.offerte", "offerta.notfound");
                    sentence.addParam(exc.getKey());
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    instance.closeConnections();
                }
            }
            finally {
                instance.closeConnections();
            }
        }
        catch (IOException exc) {
            Warning sentence = new Warning("manage.offerte", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("manage.offerte", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    @RequestMapping(value={"/editofferta.srvl"}, method={RequestMethod.GET})
    public String edit(@RequestParam(value="indice") String indiceTxt, @RequestParam(value="config") String config, ModelMap model) {
        String jsp = EDIT;
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            PrebillingConfiguration configuration = instance.getConfiguration();
            PrebillingDao prebillingDao = instance.getPrebillingDao();
            try {
                try {
                    model.addAttribute("config", config);
                    AbstractController.handleVersion(model, configuration);
                    int indice = ControllerHelper.checkInt("indice", indiceTxt);
                    Offerta offerta = prebillingDao.getOfferta(indice);
                    model.addAttribute("indice", indiceTxt);
                    int mercato = offerta.getMercato();
                    model.addAttribute("mercato", mercato);
                    int zona = offerta.getZona();
                    model.addAttribute("zona", zona);
                }
                catch (DataNotFoundException exc) {
                    jsp = "redirect:/offerte.srvl";
                    Message sentence = new Message("manage.offerte", "offerta.notfound");
                    sentence.addParam(exc.getKey());
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    instance.closeConnections();
                }
                catch (InvalidParameterValue exc) {
                    Message sentence = new Message("manage.offerte", "invalid.data");
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    jsp = "redirect:/offerte.srvl";
                    instance.closeConnections();
                }
            }
            finally {
                instance.closeConnections();
            }
        }
        catch (IOException exc) {
            Warning sentence = new Warning("manage.offerte", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("manage.offerte", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    @RequestMapping(value={"/editofferta.srvl"}, method={RequestMethod.POST})
    public String aggiorna(@RequestParam(value="indice") String indiceTxt, @RequestParam(value="mercato") String mercatoTxt, @RequestParam(value="zona") String zonaTxt, @RequestParam(value="config") String config, ModelMap model) {
        String jsp = "redirect:/offerte.srvl";
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            PrebillingConfiguration configuration = instance.getConfiguration();
            PrebillingDao prebillingDao = instance.getPrebillingDao();
            try {
                try {
                    model.addAttribute("config", config);
                    AbstractController.handleVersion(model, configuration);
                    int indice = ControllerHelper.checkInt("indice", indiceTxt);
                    int mercato = ControllerHelper.checkInt("mercato", mercatoTxt);
                    int zona = ControllerHelper.checkInt("zona", zonaTxt);
                    Offerta offerta = prebillingDao.getOfferta(indice);
                    offerta.setMercato(mercato);
                    offerta.setZona(zona);
                    prebillingDao.updateOfferta(offerta);
                }
                catch (DataNotFoundException exc) {
                    Message sentence = new Message("manage.offerte", "offerta.notfound");
                    sentence.addParam(exc.getKey());
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    instance.closeConnections();
                }
                catch (InvalidParameterValue exc) {
                    Message sentence = new Message("manage.offerte", "invalid.data");
                    sentence.setCss("alert-warning");
                    talkManager.addSentence(sentence);
                    model.addAttribute("indice", indiceTxt);
                    model.addAttribute("mercato", mercatoTxt);
                    model.addAttribute("zona", zonaTxt);
                    jsp = EDIT;
                    instance.closeConnections();
                }
            }
            finally {
                instance.closeConnections();
            }
        }
        catch (IOException exc) {
            Warning sentence = new Warning("manage.offerte", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("manage.offerte", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("manage.offerte", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }
}

