/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.web;

import biz.elabor.prebilling.common.config.InvalidConfigurationException;
import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.services.common.CheckStatusStrategy;
import biz.elabor.prebilling.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.services.gas.GasService;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.web.common.AbstractPrebillingController;
import java.io.IOException;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GasController
extends AbstractPrebillingController {
    private static final String GAS = "gas";
    private static final String GAS_URL = "/gas.srvl";

    public GasController() {
        super(null);
    }

    @RequestMapping(value={"/gas.srvl"}, method={RequestMethod.GET})
    public String get(@RequestParam(value="config") String config, ModelMap model) {
        String jsp;
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            try {
                PrebillingConfiguration configuration = instance.getConfiguration();
                GasController.handleVersion(model, configuration);
            }
            finally {
                instance.closeConnections();
            }
            model.addAttribute("config", config);
            jsp = GAS;
        }
        catch (IOException exc) {
            Warning sentence = new Warning("TMV-0350", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("TMV-0350", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("TMV-0350", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("TMV-0350", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    @RequestMapping(value={"/gas.srvl"}, method={RequestMethod.POST})
    public String post(@RequestParam(value="config") String config, ModelMap model) {
        String jsp = GAS;
        TalkManager talkManager = this.getTalkManager();
        try {
            ControllerHelper.checkEmpty("config", config);
            ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
            try {
                try {
                    PrebillingConfiguration configuration = instance.getConfiguration();
                    PrebillingDao prebillingDao = instance.getPrebillingDao();
                    model.addAttribute("config", config);
                    GasController.handleVersion(model, configuration);
                    CheckStatusStrategy checkStatusService = new CheckStatusStrategy(Funzionalita.GAS, "*", "gas.check", configuration, prebillingDao, talkManager);
                    checkStatusService.execute(null);
                    GasService service = new GasService(configuration, talkManager);
                    service.execute(prebillingDao, null);
                    UpdateStatusStrategy updateStatusService = new UpdateStatusStrategy(Funzionalita.GAS, "*", TipoStato.NO_ESECUZIONE, configuration, prebillingDao);
                    updateStatusService.execute(null);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    Message sentence = new Message("TMV-0350", "internal.error");
                    talkManager.addSentence(sentence);
                    instance.closeConnections();
                }
            }
            finally {
                instance.closeConnections();
            }
        }
        catch (IOException exc) {
            Warning sentence = new Warning("TMV-0350", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("TMV-0350", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("TMV-0350", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsp = "errore";
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("TMV-0350", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsp = "errore";
        }
        return jsp;
    }

    @RequestMapping(value={"/gas.srvl"}, params={"app"})
    @ResponseBody
    public String voltureJsonPost(@RequestParam(value="config") String config) {
        String jsonResponse;
        TalkManager talkManager = this.getTalkManager();
        try {
            PrebillingConfiguration configuration;
            block10: {
                ControllerHelper.checkEmpty("config", config);
                ConfigurationInstance instance = this.configurationLoader.loadConfigurationInstance(config);
                configuration = instance.getConfiguration();
                PrebillingDao prebillingDao = instance.getPrebillingDao();
                try {
                    try {
                        GasService service = new GasService(configuration, talkManager);
                        service.execute(prebillingDao, null);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        Message sentence = new Message("TMV-0350", "internal.error");
                        talkManager.addSentence(sentence);
                        instance.closeConnections();
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    instance.closeConnections();
                    throw throwable;
                }
                instance.closeConnections();
            }
            jsonResponse = JsonHelper.buildMessage(configuration, null, talkManager);
        }
        catch (IOException exc) {
            Warning sentence = new Warning("TMV-0350", "not.found.config");
            String message = exc.getMessage();
            sentence.addParam(message);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsonResponse = JsonHelper.buildMessage(null, null, talkManager);
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("TMV-0350", message);
            String key = exc.getKey();
            sentence.addParam(key);
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsonResponse = JsonHelper.buildMessage(null, null, talkManager);
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Warning sentence = new Warning("TMV-0350", message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            jsonResponse = JsonHelper.buildMessage(null, null, talkManager);
        }
        catch (Exception exc) {
            String message = exc.getMessage();
            Message sentence = new Message("TMV-0350", message);
            talkManager.addSentence(sentence);
            exc.printStackTrace();
            jsonResponse = JsonHelper.buildMessage(null, null, talkManager);
        }
        return jsonResponse;
    }
}

