/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.utilities;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.homelinux.elabor.db.DbmsType;

public class OracleSql {
    public static void execute(String ip, int port, String sid, String user, String password, String[] queries) throws SQLException, ClassNotFoundException {
        System.out.println(String.valueOf(ip) + " - " + sid + " - " + user);
        long time = System.currentTimeMillis();
        System.out.println("connessione: " + ip + " - " + sid + " - " + user);
        Connection connection = DbmsType.ORACLE.getConnection(ip, port, sid, user, password);
        long prev = time;
        time = System.currentTimeMillis();
        System.out.println("connection: " + (time - prev));
        Statement statement = connection.createStatement();
        prev = time;
        time = System.currentTimeMillis();
        System.out.println("statement: " + (time - prev));
        String[] stringArray = queries;
        int n2 = queries.length;
        int n3 = 0;
        while (n3 < n2) {
            String query = stringArray[n3];
            prev = time;
            System.out.println(query);
            if (query.toLowerCase().startsWith("select")) {
                ResultSet rs = statement.executeQuery(query);
                System.out.println("-----");
                OracleSql.printResult(rs);
                System.out.println("-----");
                rs.close();
            } else {
                statement.execute(query);
            }
            time = System.currentTimeMillis();
            System.out.println("query: " + (time - prev));
            ++n3;
        }
        statement.close();
        connection.close();
    }

    public static void printResult(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        int columnCount = metadata.getColumnCount();
        OracleSql.printTestata(metadata, columnCount);
        System.out.println("----");
        OracleSql.printRighe(rs, columnCount);
        System.out.println("----");
    }

    public static void printRighe(ResultSet rs, int columnCount) throws SQLException {
        while (rs.next()) {
            int column = 1;
            while (column <= columnCount) {
                System.out.print(String.valueOf(rs.getString(column)) + "\t");
                ++column;
            }
            System.out.println();
        }
    }

    public static void printTestata(ResultSetMetaData metadata, int columnCount) throws SQLException {
        int column = 1;
        while (column <= columnCount) {
            System.out.print(String.valueOf(metadata.getColumnName(column)) + "\t");
            ++column;
        }
        System.out.println();
    }
}

