/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.periodo;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Mno2GE;
import biz.elabor.prebilling.services.xml.AbstractGetXmlStrategy;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.d479.GetPdo2GRXmlGetter;
import biz.elabor.prebilling.services.xml.periodo.GetPdoEA;
import biz.elabor.prebilling.services.xml.periodo.GetPdoER;
import biz.elabor.prebilling.web.xml.IsolableServiceStrategy;
import biz.elabor.prebilling.web.xml.Partition;
import biz.elabor.prebilling.web.xml.filtri.FiltriXml;
import java.util.List;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class GetPdo2GRXmlStrategy
extends AbstractGetXmlStrategy
implements IsolableServiceStrategy {
    private final String azienda;
    private final TalkManager talkManager;

    public GetPdo2GRXmlStrategy(String azienda, FiltriXml filtri, MisureDao dao, TalkManager talkManager) {
        super(filtri, dao);
        this.azienda = azienda;
        this.talkManager = talkManager;
    }

    @Override
    public boolean executePartition(ServiceStatus status, Partition partition) {
        GetPdo2GRXmlGetter pdo2GRGetter = new GetPdo2GRXmlGetter(this.talkManager, partition);
        List<Mno> misure = this.getFlussi(this.azienda, TipoFlusso.PDO2G, pdo2GRGetter);
        status.setPdo2GRXml(misure);
        this.set2GE(status, partition, this.azienda);
        return true;
    }

    private void set2GE(ServiceStatus status, Partition partition, String azienda) {
        GetPdoEA getterA = new GetPdoEA("R");
        List<Mno2GE> misureA = this.getFlussi(azienda, TipoFlusso.PDO2G, partition, getterA);
        if (!misureA.isEmpty()) {
            GetPdoER getterR = new GetPdoER("R");
            List<Mno2GE> misureR = this.getFlussi(azienda, TipoFlusso.PDO2G, partition, getterR);
            ListMap<String, Mno2GE> misureRMap = GetPdo2GRXmlStrategy.buildMisureMap(misureR);
            status.setMisure2gEA(misureA);
            status.setMisure2gER(GetPdo2GRXmlStrategy.getMisure(misureRMap, "T"));
            status.setMisure2gERc(GetPdo2GRXmlStrategy.getMisure(misureRMap, "C"));
            status.setMisure2gERi(GetPdo2GRXmlStrategy.getMisure(misureRMap, "I"));
        }
    }

    @Override
    public boolean execute(ServiceStatus status) {
        throw new RuntimeException("not allowed");
    }
}

