/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.xml.export;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Delibera;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.homelinux.elabor.db.DataNotFoundException;

public class ExportXmlSwitchNonOrarioService {
    private final String id;
    private final MisureDao misureDao;
    private final PrebillingConfiguration configuration;

    public ExportXmlSwitchNonOrarioService(String id, MisureDao misureDao, PrebillingConfiguration configuration) {
        this.id = id;
        this.misureDao = misureDao;
        this.configuration = configuration;
    }

    public String export() throws DataNotFoundException, IOException {
        String xml;
        Snf snf = this.misureDao.getSnf(this.id);
        String codiceFlusso = snf.getCodiceFlusso();
        TipoFlusso tipo = TipoFlusso.valueOf(codiceFlusso);
        Delibera delibera = snf.getDelibera();
        try (StringWriter xmlWriter = new StringWriter();){
            try (PrintWriter writer = new PrintWriter(xmlWriter);){
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                String flusso = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" CodFlusso=\":flusso:\"".replaceAll(":flusso:", tipo.name());
                writer.println("<Flusso" + delibera.getTipo(tipo) + " " + flusso + ">");
                ExportXmlHelper.printIdentificativiFlusso(snf, writer);
                String context = this.getClass().getSimpleName();
                tipo.printDatiPod(context, snf, this.configuration, this.misureDao, writer);
                writer.print("</Flusso" + delibera.getTipo(tipo) + ">");
            }
            xml = xmlWriter.toString();
        }
        return xml;
    }
}

